<cfset effMeasPairs = FORM.filterVals>

<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="BrowseCountQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="BrowseCountQueryVars">
    
        SELECT 
            count(distinct f.reference_number) as ref_count
        FROM
            references f
            INNER JOIN tests t ON t.ecoref_number = f.reference_number
            INNER JOIN results r ON r.test_id_fk = t.test_id
        WHERE (
        <cfset pairCount = 0>
        <cfloop index=pair list="#effMeasPairs#" delimiters=",">
            <cfset trimmedVal = trim(pair)>
            <cfset effCode = ListGetAt(trimmedVal, 1, "|")>
            <cfset measCode = ListGetAt(trimmedVal, 2, "|")>

            <cfif len(trim(effCode)) AND len(trim(measCode))>
                <cfif pairCount GT 0> OR </cfif>
                (REPLACE(REPLACE(r.effect, '~', ''), '/', '') = <CFQUERYPARAM VALUE="#effCode#" CFSQLTYPE="CF_SQL_VARCHAR">
                    AND REPLACE(REPLACE(r.measurement, '~', ''), '/', '') = <CFQUERYPARAM VALUE="#measCode#" CFSQLTYPE="CF_SQL_VARCHAR">)
                <cfset pairCount = pairCount + 1>
            </cfif>
        </cfloop>
        )

    </cfquery>
    
    <!---<cflog text ="#BrowseCountQueryVars.sql#">--->
    <!---<cflog text ="#ArrayToList(BrowseCountQueryVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>
