
<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="BrowseQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="BrowseQueryVars">
        
        SELECT * FROM (
            SELECT /*+ first_rows(#PAGESIZE#) */
                <!---DISTINCT---> iq.species_number, iq.common_name, iq.latin_name, iq.ncbi_taxid, iq.syn_common, iq.syn_latin, <!--- --+ ORDERED --->
                row_number() over (order by #SORTFIELD#) rn,
                COUNT(*) OVER () TotalRows
            FROM (
                SELECT iiq.species_number, iiq.common_name, iiq.latin_name, iiq.ncbi_taxid, iiq.syn_common, iiq.syn_latin
                FROM (
                    SELECT 
                        s.species_number, s.common_name, s.latin_name, s.ncbi_taxid,
                        listagg(sc.common_name, ', ') within group (order by sc.common_name) as syn_common,
                        listagg(sl.latin_name, ', ') within group (order by sl.latin_name) as syn_latin
                    FROM
                        species s
                        LEFT JOIN species_common_synonyms sc ON sc.species_number = s.species_number AND LOWER(sc.common_name) like '%#SEARCHTERM#%'
                        LEFT JOIN species_latin_synonyms sl ON sl.species_number = s.species_number AND LOWER(sl.latin_name) like '%#SEARCHTERM#%'
                    WHERE
                        (
                            LOWER(s.common_name) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(s.latin_name) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(s.ncbi_taxid) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(sc.common_name) like '%#SEARCHTERM#%'
                        )
                        OR (
                            LOWER(sl.latin_name) like '%#SEARCHTERM#%'
                        )
                    GROUP BY s.species_number, s.common_name, s.latin_name, s.ncbi_taxid
                ) iiq
                GROUP BY iiq.species_number, iiq.common_name, iiq.latin_name, iiq.ncbi_taxid, iiq.syn_common, iiq.syn_latin
            ) iq
        )
        WHERE rn between #STARTPOS#+1 AND (#PAGESIZE# + #STARTPOS#)
        ORDER BY rn

    </cfquery>
    
    <!---<cflog text ="#BrowseQueryVars.sql#">--->
    <!---<cflog text ="#ArrayToList(BrowseQueryVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>


	
