
<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
<cfset GenFunc = CreateObject("component", "cfc.generic_functions")>

<cfparam name="URL.browsetype" default="">
    
<!--- search terms - from select2 --->  
<cfparam name="URL.term" default="">
<cfparam name="URL._type" default="">
<cfparam name="URL.page" default="0">
    
<cfset SEARCHTERM = LCase(URL.term)> 
<cfset PAGESIZE = 10>
    
<cfset page_adj = URL.page>    
<cfif page_adj gt 0>
    <cfset page_adj = page_adj - 1>
</cfif>
    
<cfset STARTPOS = page_adj * PAGESIZE>

<cfif URL.browsetype eq "">
      
    <!--- SET CONDITIONS OF ERROR HERE FOR RETURN MESSAGING --->
      
    <cfinclude template="browse/error_browse_response.cfm">
      
<cfelse>
    
    <cfswitch expression="#url.browsetype#">
        <cfcase value="chemical">
            
            <cfset SORTFIELD = "chem_primary_name">

            <cfinclude template="browse/queries/chemicals_by_name_cas.cfm">
            <cfinclude template="browse/browse_response_json.cfm">

        </cfcase>
        
        <cfcase value="effect">
            
            <cfset SORTFIELD = "meas_desc, effect_desc">

            <cfinclude template="browse/queries/effects_by_effect_meas.cfm">
            <cfinclude template="browse/browse_response_json.cfm">

        </cfcase>
        
        <cfcase value="species">
            
            <cfset SORTFIELD = "latin_name">

            <cfinclude template="browse/queries/species_by_name_ncbi.cfm">
            <cfinclude template="browse/browse_response_json.cfm">

        </cfcase>
        
        <cfcase value="publications">
            
            <cfset SORTFIELD = "reference_number">

            <cfinclude template="browse/queries/publications_by_various.cfm">
            <cfinclude template="browse/browse_response_json.cfm">

        </cfcase>
        
        <cfcase value="pubspecies">
            
            <cfset SORTFIELD = "latin_name">

            <cfinclude template="browse/queries/pub_species.cfm">
            <cfinclude template="browse/browse_response_json.cfm">

        </cfcase>
        
        <cfcase value="pubtaxclass">
            
            <cfset SORTFIELD = "class">

            <cfinclude template="browse/queries/pub_tax_class.cfm">
            <cfinclude template="browse/browse_response_json.cfm">

        </cfcase>
        
        <cfcase value="pubchemicals">
            
            <cfset SORTFIELD = "chem_primary_name">

            <cfinclude template="browse/queries/pub_chemicals.cfm">
            <cfinclude template="browse/browse_response_json.cfm">

        </cfcase>
        
        <cfcase value="pubeffects">
            
            <cfset SORTFIELD = "meas_desc, effect_desc">

            <cfinclude template="browse/queries/pub_effects.cfm">
            <cfinclude template="browse/browse_response_json.cfm">

        </cfcase>
        
        <cfcase value="pubauthor">
            
            <cfset SORTFIELD = "author_name">

            <cfinclude template="browse/queries/pub_authors.cfm">
            <cfinclude template="browse/browse_response_json.cfm">

        </cfcase>
        
        <cfcase value="pubtitle">
            
            <cfset SORTFIELD = "title, author">

            <cfinclude template="browse/queries/pub_titles.cfm">
            <cfinclude template="browse/browse_response_json.cfm">

        </cfcase>
        
        <cfcase value="pubecoref">
            
            <cfset SORTFIELD = "reference_number">

            <cfinclude template="browse/queries/pub_ecoref.cfm">
            <cfinclude template="browse/browse_response_json.cfm">

        </cfcase>
        
        <cfcase value="pubdoi">
            
            <cfset SORTFIELD = "doi">

            <cfinclude template="browse/queries/pub_doi.cfm">
            <cfinclude template="browse/browse_response_json.cfm">

        </cfcase>
        
        <cfcase value="pubcitation">
            
            <cfset SORTFIELD = "reference_number">

            <cfinclude template="browse/queries/pub_citation.cfm">
            <cfinclude template="browse/browse_response_json.cfm">

        </cfcase>

        <cfcase value="getcount">

            <cfparam name="FORM.filterType" default="">
            <cfparam name="FORM.filterVals" default="">

            <cfinclude template="browse/browse_response_counts.cfm">

        </cfcase>

        <cfcase value="getcounttotal">

            <cfset FORM.filterType = "pubtotal">
            <cfparam name="FORM.filterVals_pubchemicals" default="">
            <cfparam name="FORM.filterVals_pubspecies" default="">
            <cfparam name="FORM.filterVals_pubspecgroup" default="">
            <cfparam name="FORM.filterVals_pubtaxclass" default="">
            <cfparam name="FORM.filterVals_pubeffects" default="">
            <cfparam name="FORM.filterVals_pubeffectgroups" default="">
            <cfparam name="FORM.filterVals_pubauthor" default="">
            <cfparam name="FORM.filterVals_pubtitle" default="">
            <cfparam name="FORM.filterVals_pubecoref" default="">
            <cfparam name="FORM.filterVals_pubdoi" default="">
            <cfparam name="FORM.filterVals_pubcitation" default="">
            <cfparam name="FORM.filterVals_pubreflist" default="">
            <cfparam name="FORM.filterVals_pubcaslist" default="">

            <cfinclude template="browse/browse_response_counts.cfm">

        </cfcase>

        <cfcase value="getrefsbyfilter">

            <cfparam name="FORM.pubcaslist" default="">
            <cfparam name="FORM.pubspecies" default="">
            <cfparam name="FORM.pubspecgroup" default="">
            <cfparam name="FORM.pubtaxclass" default="">
            <cfparam name="FORM.pubeffects" default="">
            <cfparam name="FORM.pubeffectgroups" default="">
            <cfparam name="FORM.ecoref" default="">
            <cfparam name="FORM.habitat" default="">

            <cfinclude template="browse/queries/ref_nums_by_filter.cfm">
            <cfinclude template="browse/browse_response_ref_nums.cfm">

        </cfcase>
        
        <cfdefaultcase>

            <!--- UNKNOWN BROWSE TYPE --->
      
            <!--- SET CONDITIONS OF ERROR HERE FOR RETURN MESSAGING --->
    
            <cfinclude template="browse/error_browse_response.cfm">

        </cfdefaultcase>
    
    </cfswitch>   
      
</cfif>