<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
<cfprocessingdirective suppressWhiteSpace = "Yes">
    
<!--- ERROR HANDLING, MAY NOT BE NEEDED HERE --->
<cfset error = "0">
<cfset errorHtml = "">
<cfset messageClass = ''>
<cfset messageTitle = ''>
<cfset messageText = ''>
    
<cfset rowCount = FullCitationQuery.TotalRows>
<cfif rowCount eq "">
    <cfset rowCount = 0>
</cfif>

<cfif rowCount eq 0>
    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "There were no results found for this selection. Please refine your search.">    
</cfif>


<cfset resultsArray = arrayNew(1)>
<cfloop query="FullCitationQuery">
    <cfset rowData = "">

    <cfset colVal = FullCitationQuery.ecoref_number>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"ecoref_number":' & colVal)>

    <cfset colVal = FullCitationQuery.citation>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"citation":' & colVal)>

    <cfset rowData = "{" & rowData & "}">
    <cfset ArrayAppend(resultsArray, rowData)>
</cfloop>

<!---construct json output --->

<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>
    
<cfset dataString = "">
<cfloop array="#resultsArray#" index="thisRow">
    <cfset dataString = listAppend(dataString, thisRow)>
</cfloop>
    
<cfset jsonString = '{"queryError":"#error#","errorHtml":"#errorHtml#","draw":"#RETURNDRAW#","recordsTotal":"#rowCount#","recordsFiltered":"#rowCount#","records":[' & dataString & ']}'>

<cfoutput>#jsonString#</cfoutput>
</cfprocessingdirective>
