<cfset GenFunc = CreateObject("component", "cfc.generic_functions")>

<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="PubsQueryRecords" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="PubsQuerySummaryVars">

        SELECT * FROM (                
            SELECT /*+ first_rows(#PAGESIZE#) */            
                <!---DISTINCT--->
                oq.ecoref_number, oq.short_ref, oq.citation, oq.test_id, oq.cas_number, oq.epa_chem_substance_name, oq.common_name, oq.effect_desc
				, oq.measurement_desc, oq.endpoint, oq.obs_duration, oq.conc1_type_desc,
				CASE
					WHEN oq.conc_std is not null THEN oq.conc_std
					WHEN oq.conc_auth is not null THEN oq.conc_auth
					ELSE ''
				END as concentration
				, oq.dtxsid, oq.title, <!--- --+ ORDERED --->
                row_number() over (order by #SORTFIELD#) rn,
                COUNT(*) OVER () TotalRows
            FROM (
				SELECT
					iq.ecoref_number, iq.short_ref, iq.citation, iq.test_id, iq.cas_number, iq.epa_chem_substance_name, iq.common_name, iq.effect_desc
					, iq.measurement_desc, iq.endpoint,
					CASE
						WHEN iq.obs_dur_std is not null
							THEN ltrim(nvl(iq.dur_mean_op, '') || ' ')
								|| rtrim(to_char(iq.obs_dur_std, 'FM999999999999990.999999999999999'), '.')
								|| ' ' || iq.dur_unit
						WHEN iq.obs_dur_min_std is not null
							THEN ltrim(nvl(iq.dur_min_op, '') || ' ')
								|| rtrim(to_char(iq.obs_dur_min_std, 'FM999999999999990.999999999999999'), '.')
								|| ' - ' ||
								ltrim(nvl(iq.dur_max_op, '') || ' ')
								|| rtrim(to_char(iq.obs_dur_max_std, 'FM999999999999990.999999999999999'), '.')
								|| ' ' || iq.dur_unit
						ELSE ''
					END as obs_duration,
					iq.conc1_type_desc,
					CASE 
						WHEN iq.conc1_mean_std_num is not null
							THEN ltrim(nvl(iq.conc_mean_op, '') || ' ')
								|| rtrim(to_char(iq.conc1_mean_std_num, 'FM999999999999990.999999999999999'), '.')
								|| ' ' || iq.conc_units_std
						WHEN iq.conc1_min_std_num is not null
							THEN ltrim(nvl(iq.conc_min_op, '') || ' ')
								|| rtrim(to_char(iq.conc1_min_std_num, 'FM999999999999990.999999999999999'), '.')
								|| ' - ' ||
								ltrim(nvl(iq.conc_max_op, '') || ' ')
								|| rtrim(to_char(iq.conc1_max_std_num, 'FM999999999999990.999999999999999'), '.')
								|| ' ' || iq.conc_units_std
						ELSE NULL
					END as conc_std,
					CASE 
						WHEN iq.conc1_mean_auth_num is not null
							THEN ltrim(nvl(iq.conc_mean_op, '') || ' ')
								|| rtrim(to_char(iq.conc1_mean_auth_num, 'FM999999999999990.999999999999999'), '.')
								|| ' ' || iq.conc_units_auth
						WHEN iq.conc1_min_auth_num is not null
							THEN ltrim(nvl(iq.conc_min_op, '') || ' ')
								|| rtrim(to_char(iq.conc1_min_auth_num, 'FM999999999999990.999999999999999'), '.')
								|| ' - ' ||
								ltrim(nvl(iq.conc_max_op, '') || ' ')
								|| rtrim(to_char(iq.conc1_max_auth_num, 'FM999999999999990.999999999999999'), '.')
								|| ' ' || iq.conc_units_auth
						ELSE NULL
					END as conc_auth,
					iq.dtxsid, iq.title
				FROM (
					SELECT
						COUNT(*) as inner_cnt_distinct, mv.ecoref_number
						, (mv.ecoref_number || '. ' || NVL(SUBSTR(f.author, 0, INSTR(f.author, ',')-1), f.author) || '. ' || mv.publication_year) as short_ref
						, mv.citation, mv.test_id, mv.result_id, mv.cas_number, mv.epa_chem_substance_name, mv.common_name, mv.effect_desc, mv.measurement_desc
						, mv.endpoint, mv.dtxsid, f.title
						, CAST(REGEXP_REPLACE(mv.obs_duration_std, '[^0-9.]', '') as FLOAT) as obs_dur_std
						, CAST(REGEXP_REPLACE(mv.obs_duration_min_std, '[^0-9.]', '') as FLOAT) as obs_dur_min_std
						, CAST(REGEXP_REPLACE(mv.obs_duration_max_std, '[^0-9.]', '') as FLOAT) as obs_dur_max_std
						, du.description as dur_unit
						, mv.obs_duration_unit_std, mv.conc1_type_desc
						, mv.conc1_mean_std_num, mv.conc1_min_std_num, mv.conc1_max_std_num, mv.conc_units_std
						, mv.conc1_mean_auth_num, mv.conc1_min_auth_num, mv.conc1_max_auth_num, mv.conc_units_auth
						, mv.conc1_mean_op as conc_mean_op, mv.conc1_min_op as conc_min_op, mv.conc1_max_op as conc_max_op
						, mv.obs_duration_std_op as dur_mean_op, mv.obs_duration_min_std_op as dur_min_op, mv.obs_duration_max_std_op as dur_max_op
					FROM
						ecotox_group_summary3_mv mv
						INNER JOIN references f ON f.reference_number = mv.ecoref_number
            			LEFT JOIN duration_unit_codes du ON du.code = mv.obs_duration_unit_std
					WHERE (1=1

	<!---
		this refers to the original group of ecorefs from EP, if applicable.  we always want to filter by these if there is a value,
		regardless of whether there is further filtering by other user inputs (ie. author/title below)
	 --->
	<cfif IN_origreflist neq "">
		<cfif ListLen(IN_origreflist) LTE 1000>
			AND mv.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_origreflist#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_origreflist, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					mv.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>

	<!--- for author / title --->
	<cfif IN_ecoref neq "All">
		<cfif ListLen(IN_ecoref) LTE 1000>
			AND mv.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_ecoref#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_ecoref, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					mv.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>

    <!--- check group selectors --->
	<cfif IN_chemGroupId neq "All">
		<cfif IN_chemGroupId eq "99" AND IN_casList neq "">
			<cfif len(IN_casList)>                
                <cfif ListLen(IN_casList) LTE 1000>
                    AND mv.cas_number IN (<CFQUERYPARAM VALUE="#IN_casList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                <cfelse>
                    <cfset arrayOfLists = GenFunc.splitListToSublists(IN_casList, 1000)>
                    <cfif ArrayLen(arrayOfLists) GTE 1>
                    AND (
                        <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                            <cfset thisSubList = arrayOfLists[i]>
                            <cfif i GT 1> OR </cfif>                            
                            mv.cas_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                        </cfloop>
                    )
                    </cfif>
                </cfif>
            </cfif>
		<cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
			AND dtxsid IN (<CFQUERYPARAM VALUE="#IN_dtsxIdList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        <cfelseif IN_chemGroupId eq "99">
            <!--- do nothing - this is handled with chemicals below --->
		<cfelse>
            AND cas_number IN (
                SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
            )
		</cfif>
	</cfif>
	
	<cfif IN_specGroupId neq "All">
		<cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">
			AND ncbi_taxid IN (<CFQUERYPARAM VALUE="#IN_ncbiList#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
        <cfelseif IN_specGroupId eq "99">
            <!--- do nothing - this is handled with species below --->
		<cfelse>
			AND mv.species_list_id in (<CFQUERYPARAM VALUE="#IN_specGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		</cfif>
	</cfif>

	<cfif IN_effGroupId neq "All" AND IN_effGroupId neq "99">
	  <cfif ListLen(IN_effGroupId, ",") gt 1>
		AND (
			<cfloop from="1" to="#ListLen(IN_effGroupId)#" index="idx">
				<cfif idx neq 1> OR </cfif>
				(effect LIKE <CFQUERYPARAM VALUE="#ListGetAt(IN_effGroupId, idx)#%" CFSQLTYPE="CF_SQL_VARCHAR">)
			</cfloop>
		)
	  <cfelse>
		AND effect LIKE <CFQUERYPARAM VALUE="#IN_effGroupId#%" CFSQLTYPE="CF_SQL_VARCHAR">
	  </cfif>
	</cfif>

	<!--- check additional filters --->
	<cfif IN_chemListId neq "All">
		AND mv.cas_number IN (
			SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		)
	</cfif>

	<cfif IN_casId neq "All">
		AND mv.cas_number IN (<CFQUERYPARAM VALUE="#IN_casId#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesListId neq "All">
		AND mv.species_list_id in (<CFQUERYPARAM VALUE="#IN_speciesListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>		

	<cfif IN_class neq "All">
		AND mv.class IN (<CFQUERYPARAM VALUE="#IN_class#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>		
	
	<cfif IN_taxOrder neq "All">
		AND mv.tax_order IN (<CFQUERYPARAM VALUE="#IN_taxOrder#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	

	<cfif IN_genus neq "All">
		AND mv.genus IN (<CFQUERYPARAM VALUE="#IN_genus#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_family neq "All">
		AND mv.family IN (<CFQUERYPARAM VALUE="#IN_family#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>

	<cfif IN_speciesId neq "All">
		AND mv.species_number IN (<CFQUERYPARAM VALUE="#IN_speciesId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>

	<cfif IN_special neq "All">
		<cfset loop = 0>
		AND (
		<cfloop index="thisSpecInt" list="#IN_special#" delimiters=",">
			<cfif loop gt 0> OR </cfif>
			 (#thisSpecInt# = 'Y')
			<cfset loop = loop + 1>
		</cfloop>
		)
	</cfif>
	
	<cfif IN_effectId neq "All">
		AND mv.effect IN (<CFQUERYPARAM VALUE="#IN_effectId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_measurementId neq "All">
		AND mv.measurement IN (<CFQUERYPARAM VALUE="#IN_measurementId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
			
	<!--- custom effects / measurement groups --->
	<cfif concatCustEffMeasList neq "All">
		AND CONCAT(mv.effect, mv.measurement) IN (<CFQUERYPARAM VALUE="#concatCustEffMeasList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_endpointId neq "All">
		AND mv.endpoint IN (<CFQUERYPARAM VALUE="#IN_endpointId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>

	<!--- DURATION LOGIC HERE (mv.) --->
	<cfinclude template="../../../pages/explore/duration_logic_sql.cfm">

	<cfif IN_habitat neq "All">
		AND mv.habitat IN (<CFQUERYPARAM VALUE="#IN_habitat#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
		AND mv.publication_year between <CFQUERYPARAM VALUE="#IN_pubYearMin#" CFSQLTYPE="CF_SQL_VARCHAR"> AND <CFQUERYPARAM VALUE="#IN_pubYearMax#" CFSQLTYPE="CF_SQL_VARCHAR">
	
		<!--- special interest groups are no longer determined by species group, so include this to make sure not to return any of these items matching species_list_id between 13-15 --->
		AND (mv.species_list_id IS NULL OR mv.species_list_id NOT IN (13,14,15))
					
					)
					GROUP BY mv.ecoref_number, (mv.ecoref_number || '. ' || NVL(SUBSTR(f.author, 0, INSTR(f.author, ',')-1), f.author) || '. ' || mv.publication_year)
						, mv.citation, mv.test_id, mv.result_id, mv.cas_number, mv.epa_chem_substance_name, mv.common_name, mv.effect_desc, mv.measurement_desc
						, mv.endpoint, mv.dtxsid, f.title
						, CAST(REGEXP_REPLACE(mv.obs_duration_std, '[^0-9.]', '') as FLOAT)
						, CAST(REGEXP_REPLACE(mv.obs_duration_min_std, '[^0-9.]', '') as FLOAT)
						, CAST(REGEXP_REPLACE(mv.obs_duration_max_std, '[^0-9.]', '') as FLOAT)
						, du.description, mv.obs_duration_unit_std, mv.conc1_type_desc
						, mv.conc1_mean_std_num, mv.conc1_min_std_num, mv.conc1_max_std_num, mv.conc_units_std
						, mv.conc1_mean_auth_num, mv.conc1_min_auth_num, mv.conc1_max_auth_num, mv.conc_units_auth
						, mv.conc1_mean_op, mv.conc1_min_op, mv.conc1_max_op, mv.obs_duration_std_op, mv.obs_duration_min_std_op, mv.obs_duration_max_std_op
                ) iq
            ) oq
        )
        WHERE rn between #STARTPOS#+1 AND (#PAGESIZE# + #STARTPOS#)
        ORDER BY rn

    </cfquery>
    
<!---     <cflog text ="#PubsQuerySummaryVars.sql#"> --->
<!---     <cflog text ="#ArrayToList(PubsQuerySummaryVars.sqlparameters)#"> --->
	
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>
