<cfset cleanInputs = CreateObject("component", "cfc.input_sanitize")>

<cfparam name="URL.type" default="">


<!--- paging / sorting vars --->  
<cfparam name="FORM.sortfield" default="">       <!--- UI will pass this or default to col 1 on DT.  Exports will use the default value here  --->
<cfparam name="FORM.sortdir" default="">
<cfparam name="FORM.length" default="10000">   <!--- default is application max.  UI will pass page size, exports will not and will be capped at 10000 rows --->
<cfparam name="FORM.start" default="0">       <!--- offset position for query results.  UI will pass this, default to beginning.  Exports will have full range 0-10000 --->

<cfset validParam = cleanInputs.checkSearchAndRefFormInputAlphaNumeric("sortfield", FORM.sortfield)>
<cfset validParam = cleanInputs.checkSearchAndRefFormInputAlphaNumeric("sortdir", FORM.sortdir)>
<cfset validParam = cleanInputs.checkSearchAndRefFormInputNumeric("length", FORM.length)>
<cfset validParam = cleanInputs.checkSearchAndRefFormInputNumeric("start", FORM.start)>
    
<cfparam name="FORM.hdnTestFlag" default="">
<cfif FORM.hdnTestFlag eq "TEST">
    <cfset testSearch = true>
<cfelse>
    <cfset testSearch = false>
</cfif>

<cfparam name="FORM.refNums" default="">
    
<cfset REFSORTFIELD = "AUTHOR " & FORM.sortdir>
<cfset REFPAGESIZE = FORM.length>
<cfset REFSTARTPOS = FORM.start>
    
<cfparam name="FORM.search" default="">
<cfset SEARCHVAL = FORM.search>
        
<!--- jquery datatable specific --->
<cfparam name ="FORM.draw" default="">
<cfset RETURNDRAW = FORM.draw>

              
<cfif testSearch>
    
    <!--- DO NOT ACTUALLY SUBMIT --->
    
    <div>URL params:</div>
    <cfset keyList = structKeyList(url)>
    <cfloop list="#keyList#" index="key">
            <div><cfoutput>#key# = #url[key]#</cfoutput></div>
    </cfloop>

    <div>FORM params:</div>
    <cfset keyList = structKeyList(form)>
    <cfloop list="#keyList#" index="key">
        <cfif key neq "FIELDNAMES">
            <div><cfoutput>#key# = #form[key]#</cfoutput></div>
        </cfif>
    </cfloop>
    
<cfelse>
    
    <cfset error = "0">
    <cfset errorHtml = "">
    <cfset messageClass = ''>
    <cfset messageTitle = ''>
    <cfset messageText = ''>

    <cfset dataArray = "">   

    <cfinclude template="report/queries/referenceQry.cfm">

    <cfset TOTALREFCOUNT = ReferenceQuery.TotalRows> 
    <cfif TOTALREFCOUNT eq "">
        <cfset TOTALREFCOUNT = 0>
    </cfif>

    <cfif TOTALREFCOUNT eq 0>

        <cfset error = "1">
        <cfset messageClass = "callout primary">
        <cfset messageTitle = "Sorry">
        <cfset messageText = "There were no results found for this search. Please refine your search.">

    </cfif>	

    <cfswitch expression="#URL.type#">
        <cfcase value="csv">
            <cfinclude template="report/ref_search_csv.cfm">
        </cfcase>
        <cfcase value="ris">
            <cfinclude template="report/ref_search_ris.cfm">
        </cfcase>
        <cfcase value="ssd">

            <!---   DO NOTHING, QUERY ONLY  --->

        </cfcase>
        <cfdefaultcase>
            <cfinclude template="report/ref_search_DT_json.cfm">
        </cfdefaultcase>
    </cfswitch>
        
</cfif>


