
<cfset ExcelFunc = CreateObject("component", "cfc.excel_functions")>
    
<CFLOCK TIMEOUT="30" throwontimeout="no" TYPE="readonly" scope="application">
    <CFSET thisRecordMax = duplicate(Application.RecordMax)>  <!--- SPE 4/27/06 --->
    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>  <!--- SPE 4/27/06 --->
</CFLOCK>

<cfif ExportQuery.RecordCount is 0>

    <div class="callout primary">
        <h5 class="title">Sorry</h5>
        <p>There were no results found for this search. Please refine your search.</p>
    </div>

<cfelseif ExportQuery.RecordCount gt thisRecordMax> <!--- SPE 04/27/06 --->

    <div class="callout alert">
        <h5 class="title">Warning</h5>
        <p>There were too many results found to display in a browser report format.  There is a limit of <cfoutput>#thisRecordMax#</cfoutput> records for a browser viewable report. Please refine your search.</p>
    </div>

<cfelse>
    
    <!--- Before you go into .xls code, find out if cbIncludeCodeDesc is in use --->
    <cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
        <cfset displayLookupCodes = True>
    <cfelse>
        <cfset displayLookupCodes = False>
    </cfif>

    <cfprocessingdirective suppressWhiteSpace = "Yes">        
    
        <cfset columnNameList_pg1 = "Species Genus,Species,Conc 1 (Standardized),Conc 1 Op (Standardized),Conc 1 Units (Standardized),Conc 1 (Author),Conc 1 Op (Author),Conc 1 Units (Author),Conc Type,Effect,Effect Measurement,Endpoint,Observed Duration (Days),Observed Duration Units (Days),Ref Number,Ref Citation,Google Scholar,Include in SSD,SSD notes,Test Number,CAS Number,Chemical Name,Chemical Grade,Chemical Analysis,Test Method,Chemical Purity,Species Scientific Name,Species Common Name,Species Kingdom,Species Phylum,Species Sub Phylum,Species Superclass,Species Class,Species Order,Species Family,Species Genus,Species,Variety,Species Group,Organism Lifestage,Organism Age,Age Units,Organism Source,Organism Strain,Organism Initial Weight Mean Op,Organism Initial Weight Mean,Organism Initial Weight Min Op,Organism Initial Weight Min,Organism Initial Weight Max Op,Organism Initial Weight Max,Organism Initial Weight Units,Organism Initial Length Mean Op,Organism Initial Length Mean,Organism Initial Length Min Op,Organism Initial Length Min,Organism Initial Length Max Op,Organism Initial Length Max,Organism Initial Length Unit,Organism Initial Length Type,Gender,Organism Comment,Exposure Type,Media Type,Test Location,Number of Doses,EE Comment,Response Site,Statistical Significance,Significance Level Mean Op,Significance Level Mean,Significance Level Min Op,Significance Level Min,Significance Level Max Op,Significance Level Max,Chemical Formulation,Chemical Comment,Species NCBI TaxID,Control,Test Type,Doses,Number of Replicates,Exposure Sample Number,Experimental Design,Other Effects,Result Comment,Temperature Mean Op,Temperature Mean,Temperature Min Op,Temperature Min,Temperature Max Op,Temperature Max,Temperature Units,pH Mean Op,pH Mean,pH Min Op,pH Min,pH Max Op,pH Max,General Comments,Author,Reference Number,Title,Source,Publication Year,Summary of Additional Parameters">

        <cfset thisExcelWorkbook = ExcelFunc.createNewWorkbookEmpty("SSD-Toolbox-Export", columnNameList_pg1)>
               
        <!--- column header formatting --->
        
        <cfset greenHdr = StructNew()>
        <cfset greenHdr.fgcolor="green">
        <cfset greenHdr.bold="true">
            
        <cfset blueHdr = StructNew()>
        <cfset blueHdr.fgcolor="light_blue">
        <cfset blueHdr.bold="true">
            
        <cfset pinkHdr = StructNew()>
        <cfset pinkHdr.fgcolor="rose">
        <cfset pinkHdr.bold="true">
     
            
        <!---   PAGE 1      --->

<!---       THESE WILL EVENTUALLY NEED TO BE REDONE
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, greenHdr, 1, 1)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, greenHdr, 1, 2)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, greenHdr, 1, 3)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, greenHdr, 1, 4)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 5)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 6)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 7)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 8)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 9)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 10)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 11)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, greenHdr, 1, 12)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, greenHdr, 1, 13)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, greenHdr, 1, 14)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, greenHdr, 1, 15)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 17)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 18)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 19)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 20)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 21)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 22)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 23)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 24)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 35)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 36)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 37)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 38)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 39)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 40)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 41)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 42)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 43)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 44)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 45)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 46)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 49)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 50)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 51)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 52)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 53)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 54)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 55)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 56)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 57)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 58)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 59)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 60)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 61)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 62)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 63)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 65)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 66)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 67)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 68)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 69)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 70)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 71)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 72)>               
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 73)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 74)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 75)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 76)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 77)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 78)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 79)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 80)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 81)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 82)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 83)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, pinkHdr, 1, 84)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 85)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 86)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 87)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 88)>
        <cfset SpreadsheetFormatCell(thisExcelWorkbook, blueHdr, 1, 89)>
--->               
    
        <cfset thisRow = 2>
        <cfloop query="ExportQuery">
            <cfset dataRow = "">
             
            <cfset thisGenus = "">
            <cfset thisSpecies = "">
                
            <cfset sciName = Trim(ExportQuery.LATIN_NAME)>
            <cfif Len(sciName)>
                <cfset sciArray = ListToArray(sciName, " ")>
                <cfif ArrayLen(sciArray) GTE 2>
                    <cfset thisGenus = sciArray[1]>
                    <cfset thisSpecies = sciArray[2]>
                </cfif>
            </cfif>
                
            <cfif thisGenus EQ "">
                <cfset thisGenus = Trim(ExportQuery.GENUS)>
            </cfif>
                
            <cfif thisSpecies EQ "">
                <cfset thisSpecies = Trim(ExportQuery.SPECIES)>
            </cfif>
                
            <cfif thisGenus EQ "">
                <cfset thisGenus = sciName>
                <cfset thisSpecies = "">
            </cfif>
                
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(thisGenus))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(thisSpecies))>
                   
            <cfset dataRow = ListAppend(dataRow, "")>       <!--- conc1 mean std --->
            <cfset dataRow = ListAppend(dataRow, "")>       <!--- conc1 op std --->
            <cfset dataRow = ListAppend(dataRow, "")>       <!--- conc1 units std --->
            
            <!--- author reported conc values may have "/" and "*" characters --->       
            <cfset concStr = OutFunc.cleanStringForExcel(ExportQuery.CONC1_MEAN)>
            <cfset concStr = Replace( concStr, "/", "", "All" )>
            <cfset concStr = Replace( concStr, "*", "", "All" )>
            <cfset dataRow = ListAppend(dataRow, concStr)>
            
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.CONC1_MEAN_OP))>                   
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.CONC1_UNIT))>
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.CONC1_TYPE))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.CONC1_TYPE_DESC))>
            </cfif>
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.EFFECT))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.EFFECT_DESC))>
            </cfif>                  
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.MEASUREMENT))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.MEASUREMENT_DESC))>
            </cfif> 
                   
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ENDPOINT))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.OBSERV_DURATION_MEAN_STD))>
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.OBSERV_DURATION_UNIT_STD))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.OBSERV_DURATION_UNIT_STD_LONG))>
            </cfif>

            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.REFERENCE_NUMBER))>    
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.FULL_CITATION))>    
              
            <!--- set placeholder for google scholar --->
            <cfset dataRow = ListAppend(dataRow, "")>
                   
            <cfset dataRow = ListAppend(dataRow, "")>       <!--- Include in SSD --->
            <cfset dataRow = ListAppend(dataRow, "")>       <!--- SSD Notes --->
                
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_NUMBER))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_CAS))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.CHEM_PRIMARY_NAME))>
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_GRADE))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_GRADE_DESC))>
            </cfif>
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.METHOD))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.METHOD_DESC))>
            </cfif>
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_METHOD))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_METHOD_DESC))>
            </cfif>
                   
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_PURITY))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.LATIN_NAME))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.COMMON_NAME))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.KINGDOM))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.PHYLUM_DIVISION))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SUBPHYLUM_DIV))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SUPERCLASS))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.CLASS))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TAX_ORDER))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.FAMILY))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.GENUS))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SPECIES))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.VARIETY))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SPECIES_LIST_DESC))>
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.LIFESTAGE))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.LIFESTAGE_DESC))>
            </cfif>
                
            <!--- placeholder for organism age --->
            <cfset dataRow = ListAppend(dataRow, "")>
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.AGE_UNITS))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.AGE_UNITS_DESC))>
            </cfif>
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_SOURCE))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_SOURCE_DESC))>
            </cfif>
            	
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_STRAIN))>
                   
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_INIT_WT_MEAN_OP))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_INIT_WT_MEAN))>	
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_INIT_WT_MIN_OP))>	
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_INIT_WT_MIN))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_INIT_WT_MAX_OP))>	
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_INIT_WT_MAX))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_INIT_WT_UNIT))>

            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_LENGTH_MEAN_OP))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_LENGTH_MEAN))>	
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_LENGTH_MIN_OP))>	
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_LENGTH_MIN))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_LENGTH_MAX_OP))>	
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_LENGTH_MAX))>

            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_LENGTH_UNIT))>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_LENGTH_TYPE))>	
            <cfelse>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_LENGTH_UNIT_DESC))>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_LENGTH_TYPE_DESC))>
            </cfif>            

            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SEX))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.ORGANISM_CHAR))>                   
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.EXPOSURE_TYPE))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.EXPOSURE_TYPE_DESC))>
            </cfif>                   
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.MEDIA_TYPE))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.MEDIA_TYPE_DESC))>
            </cfif>                   
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_LOCATION))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_LOCATION_DESC))>
            </cfif>
                
            <!--- placeholder for number of doses --->
            <cfset dataRow = ListAppend(dataRow, "")>
                
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.EECOMMENT))>                   
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SITE))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SITE_DESC))>
            </cfif>                   
                   
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SIGNIFICANCE_LEVEL))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SIGNIFICANCE_LEVEL_MEAN_OP))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SIGNIFICANCE_LEVEL_MEAN))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SIGNIFICANCE_LEVEL_MIN_OP))>	
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SIGNIFICANCE_LEVEL_MIN))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SIGNIFICANCE_LEVEL_MAX_OP))>	
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SIGNIFICANCE_LEVEL_MAX))>
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_FORMULATION))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_FORMULATION_DESC))>
            </cfif>
                   
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_CHAR))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.NCBI_TAXID))>
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.CONTROL_TYPE))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.CONTROL_TYPE_DESC))>
            </cfif>
            
            <cfif displayLookupCodes>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_TYPE))>
            <cfelse>       
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEST_TYPE_DESC))>
            </cfif>
                   
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.DOSES))>            	
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.NUMBER_REPLICATES))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcelDate(ExportQuery.ORGANISM_NUMBER))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.EXPDESIGN))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.OTHEREFFECT))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.RESULT_REMARK))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEMP_MEAN_VALUE_OP))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEMP_MEAN_VALUE))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEMP_MIN_VALUE_OP))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEMP_MIN_VALUE))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEMP_MAX_VALUE_OP))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEMP_MAX_VALUE))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TEMP_UNITS))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SOIL_PH_MEAN_OP))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SOIL_PH_MEAN))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SOIL_PH_MIN_OP))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SOIL_PH_MIN))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SOIL_PH_MAX_OP))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SOIL_PH_MAX))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.GENERALCOMMENT))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.AUTHOR))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.REFERENCE_NUMBER))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.TITLE))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.SOURCE))>
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ExportQuery.PUBLICATION_YEAR))>
                   
                   
            <!--- Summary of Additional Parameters column --->
            <cfset pipeSpacer = " | ">
            <cfset tempText = "">
            <cfif CONDENSED_EXCEL eq true>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "conc1_type" )>
                    <cfset tempVar1 = conc1_type>
                    <cfset tempVar3 = conc2_type>
                    <cfset tempVar4 = conc3_type>
                <cfelseif ListFindNoCase( ExportQuery.ColumnList, "conc1_type_desc" )>
                    <cfset tempVar1 = conc1_type_desc>
                    <cfset tempVar3 = conc2_type_desc>
                    <cfset tempVar4 = conc3_type_desc>
                <cfelse>
                    <!--- Dose(Author)|Statistical Method was not checked, so there is no output for any conc#--->
                </cfif>
                
                <cfif ListFindNoCase( ExportQuery.ColumnList, "TEST_PURITY_MEAN_OP" )>
                    <cfset tempText = tempText & "Purity:  " &
                            ExcelFunc.additionalParameters("1","",TEST_PURITY_MEAN_OP,TEST_PURITY_MEAN,TEST_PURITY_MIN_OP,TEST_PURITY_MIN,TEST_PURITY_MAX_OP,TEST_PURITY_MAX)>
                </cfif>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "ORGANISM_AGE_MEAN_OP" )>
                    <cfif len(tempText) GT 0>
                        <cfset tempText = tempText & pipeSpacer>
                    </cfif>
                    <!--- 01/19/17 SPE - added check for full age unit desc --->
                    <cfif displayLookupCodes>
                        <cfset tempText = tempText & "Organism Age:  " &
                                ExcelFunc.additionalParameters("2","",ORGANISM_AGE_MEAN_OP,ORGANISM_AGE_MEAN,ORGANISM_AGE_MIN_OP,ORGANISM_AGE_MIN,ORGANISM_AGE_MAX_OP,ORGANISM_AGE_MAX,AGE_UNITS)>
                    <cfelse>
                        <cfset tempText = tempText & "Organism Age:  " &
                                ExcelFunc.additionalParameters("2","",ORGANISM_AGE_MEAN_OP,ORGANISM_AGE_MEAN,ORGANISM_AGE_MIN_OP,ORGANISM_AGE_MIN,ORGANISM_AGE_MAX_OP,ORGANISM_AGE_MAX,AGE_UNITS_DESC)>

                    </cfif>
                </cfif>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "CONC1_MEAN_OP" )>
                    <cfif len(tempText) GT 0>
                            <cfset tempText = tempText & pipeSpacer>
                    </cfif>
                    <cfset tempText = tempText & "Conc 1 (Author):  " &
                            ExcelFunc.additionalParameters("3",tempVar1,CONC1_MEAN_OP,CONC1_MEAN,CONC1_MIN_OP,CONC1_MIN,CONC1_MAX_OP,CONC1_MAX,CONC1_UNIT)>
                </cfif>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "OBSERV_MEAN_STD_OP" )>
                    <cfif len(tempText) GT 0>
                            <cfset tempText = tempText & pipeSpacer>
                    </cfif>
                    <cfset tempText = tempText & "Duration (Days):  " &
                            ExcelFunc.additionalParameters("2","",OBSERV_MEAN_STD_OP,OBSERV_DURATION_MEAN_STD,OBSERV_MIN_STD_OP,OBSERV_DURATION_MIN_STD,OBSERV_MAX_STD_OP,OBSERV_DURATION_MAX_STD)>
                </cfif>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "CONC2_MEAN_OP" )>
                    <cfif len(tempText) GT 0>
                            <cfset tempText = tempText & pipeSpacer>
                    </cfif>
                    <cfset tempText = tempText & "Conc 2 (Author):  " &
                            ExcelFunc.additionalParameters("4",tempVar3,CONC2_MEAN_OP,CONC2_MEAN,CONC2_MIN_OP,CONC2_MIN,CONC2_MAX_OP,CONC2_MAX,CONC2_UNIT)>
                </cfif>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "CONC3_MEAN_OP" )>
                    <cfif len(tempText) GT 0>
                            <cfset tempText = tempText & pipeSpacer>
                    </cfif>
                    <cfset tempText = tempText & "Conc 3 (Author):  " &
                            ExcelFunc.additionalParameters("4",tempVar4,CONC3_MEAN_OP,CONC3_MEAN,CONC3_MIN_OP,CONC3_MIN,CONC3_MAX_OP,CONC3_MAX,CONC3_UNIT)>
                </cfif>
            </cfif>
                
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(tempText))>
                   
                   
            <cfset ExcelFunc.addRowData(thisExcelWorkbook, dataRow)>
                   
                   
            <!--- go back and fill google scholar formula --->            
            <cfset googleLink = OutFunc.generateGoogleScholarLink(ExportQuery.TITLE)>
            <cfset ExcelFunc.addGoogleScholarLink(thisExcelWorkbook, googleLink, thisRow, 17)>         
                   
            <!--- go back and fill organism age column --->    
            <cfif displayLookupCodes>
                <cfset ageValue = ExportQuery.AGE>
            <cfelse>       
                <cfset ageValue = ExportQuery.AGE_DESC>
            </cfif>
            <cfset ExcelFunc.addAlphaNumericCellValue(thisExcelWorkbook, ageValue, thisRow, 41)>
                   
            <!--- go back and fill doses column --->
            <cfset ExcelFunc.addAlphaNumericCellValue(thisExcelWorkbook, ExportQuery.DOSE_NUMBER, thisRow, 56)>
                   
            <cfset thisRow = thisRow + 1>
        </cfloop>

        <cfset SpreadsheetAddFreezePane(thisExcelWorkbook, 4, 1, 4, 1)>
               
        <!---   END PAGE 1  --->
        
               
        <!---   PAGE 2      --->
               
        <cfset columnNameList_pg2 = "Ref. Number,Author,Title,Source,Pub. Year,Ref. Type,Citation,Google Scholar">
        
        <cfset ExcelFunc.addWorksheetEmpty(thisExcelWorkbook, "References", columnNameList_pg2)>
               
        <!---   get distinct ref nums from query    --->
        <cfset distinctRefNumsAry = arrayNew(1)>
        <cfoutput query="GetDistinctReferences">
            <cfset thisRefNum = #GetDistinctReferences.REFERENCE_NUMBER#>
            <cfset ArrayAppend(distinctRefNumsAry, thisRefNum)>
        </cfoutput>

        <cfset refNumStr = "">
        <cfloop index="i" from="1" to="#ArrayLen(distinctRefNumsAry)#">
            <cfset refNumStr = listAppend(refNumStr, #distinctRefNumsAry[i]#)>
        </cfloop>          

        <!---   CALL REF HANDLER TO GET DATA    --->
        <cfset FORM.refNums = refNumStr>
        <cfset URL.type = "ssd">
        <cfinclude template="../ref_handler.cfm">
            
        <cfset thisRow = 2>
        <cfloop query="ReferenceQuery">
            <cfset dataRow = "">

            <cfset dataRow = listAppend(dataRow,"#OutFunc.cleanStringForExcel(ReferenceQuery.REFERENCE_NUMBER)#")>
            <cfset dataRow = listAppend(dataRow,"#OutFunc.cleanStringForExcel(ReferenceQuery.AUTHOR)#")>
            <cfset dataRow = listAppend(dataRow,"#OutFunc.cleanStringForExcel(ReferenceQuery.TITLE)#")>
            <cfset dataRow = listAppend(dataRow,"#OutFunc.cleanStringForExcel(ReferenceQuery.SOURCE)#")>
            <cfset dataRow = listAppend(dataRow,"#OutFunc.cleanStringForExcel(ReferenceQuery.PUBLICATION_YEAR)#")>

            <cfif ListFind("OECDF,MED03,MED04,MED02,OECDN,OECDG,MED01,MED05,OPP,RUSSN,USGS", ReferenceQuery.REFERENCE_TYPE) gt 0>
                <cfset dataRow = listAppend(dataRow,"#OutFunc.cleanStringForExcel(ReferenceQuery.REFTYPEDESC)#")>
            <cfelse>        
                <cfset dataRow = listAppend(dataRow,"")>
            </cfif>
            
            <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(ReferenceQuery.FULL_CITATION))>    
              
            <!--- set placeholder for google scholar --->
            <cfset dataRow = ListAppend(dataRow, "")>
                
                
            <cfset ExcelFunc.addRowData(thisExcelWorkbook, dataRow)>
                   
            <!--- go back and fill google scholar formula --->                   
            <cfset googleLink = OutFunc.generateGoogleScholarLink(ReferenceQuery.TITLE)>
            <cfset ExcelFunc.addGoogleScholarLink(thisExcelWorkbook, googleLink, thisRow, 8)>
                   
            <cfset thisRow = thisRow + 1>                   
        </cfloop> 

        <cfset SpreadsheetAddFreezePane(thisExcelWorkbook, 1, 1)>
        
        <!---   END PAGE 2      --->
        
        
        <!---   PAGE 3          --->
        
        <cfset columnNameList_pg3 = "Category,Parameter Group,Name,Value,Additional Info,'',Search run-time">
        
        <cfset ExcelFunc.addWorksheetEmpty(thisExcelWorkbook, "Search-Parameters", columnNameList_pg3)>
               
        <cfset rightNow = Now()>
        <cfset thisYear = dateTimeFormat(rightNow, "yyyy")>
        <cfset thisMonth = dateTimeFormat(rightNow, "mm")>
        <cfset thisDay = dateTimeFormat(rightNow, "dd")>
        <cfset thisHour = dateTimeFormat(rightNow, "HH")>
        <cfset thisMinute = dateTimeFormat(rightNow, "nn")>
        <cfset thisSecond = dateTimeFormat(rightNow, "ss")>
            
        <cfset exportTime = thisYear & "-" & thisMonth & "-" & thisDay & " " & thisHour & ":" & thisMinute & ":" & thisSecond>    
        <cfset exportTimeFile = thisYear & thisMonth & thisDay & "_" & thisHour & thisMinute & thisSecond>
                
        <cfset dataRow = " ">
        <cfset dataRow = ListAppend(dataRow, "")>
        <cfset dataRow = ListAppend(dataRow, "")>
        <cfset dataRow = ListAppend(dataRow, "")>
        <cfset dataRow = ListAppend(dataRow, "")>
        <cfset dataRow = ListAppend(dataRow, "")>
        <cfset dataRow = ListAppend(dataRow, exportTime)>
        <cfset ExcelFunc.addRowData(thisExcelWorkbook, dataRow)>
               
        <cfset dataRow = " ">
        <cfset dataRow = ListAppend(dataRow, "")>
        <cfset dataRow = ListAppend(dataRow, "")>
        <cfset dataRow = ListAppend(dataRow, "")>
        <cfset dataRow = ListAppend(dataRow, "")>
        <cfset dataRow = ListAppend(dataRow, "")>
        <cfset dataRow = ListAppend(dataRow, "")>
        <cfset ExcelFunc.addRowData(thisExcelWorkbook, dataRow)>
               

        <!---   CALL SEARCH PARAMS HANDLER TO GET DATA    --->
        <!---<cfset URL.sub = "???">--->
        <cfset URL.mode = "export">
        <cfinclude template="../search_parameter_handler.cfm">
            
        <!---
            <cfset paramGroupArray = arrayNew(1)>
        
                <cfset thisParamGroupStruct = structNew()>
                <cfset thisParamGroupStruct.categoryName = currentCardName>
                <cfset thisParamGroupStruct.categoryFields = arrayNew(1)>
        
                    <cfset thisField = structNew()>
                    <cfset thisField.name = thisTextArea>
                    <cfset thisField.value = modval>
                    <cfset thisField.info = "">
                    <cfset thisField.group1 = "NO-GROUP">
             
        --->
            
        <cfloop from="1" to="#ArrayLen(paramGroupArray)#" index="i">
            <cfset thisParamGroupStruct = paramGroupArray[i]>
             
            <cfset dataRow = OutFunc.cleanStringForExcel(thisParamGroupStruct.categoryName)>
            <cfset dataRow = ListAppend(dataRow, "")>
            <cfset dataRow = ListAppend(dataRow, "")>
            <cfset dataRow = ListAppend(dataRow, "")>
            <cfset dataRow = ListAppend(dataRow, "")>
            <cfset dataRow = ListAppend(dataRow, "")>
            <cfset dataRow = ListAppend(dataRow, "")>
            <cfset ExcelFunc.addRowData(thisExcelWorkbook, dataRow)>
                   
            <cfloop from="1" to="#ArrayLen(thisParamGroupStruct.categoryFields)#" index="j">
                <cfset thisField = thisParamGroupStruct.categoryFields[j]>
                    
                <cfif thisField.group1 EQ "NO-GROUP">
                    <cfset thisField.group1 = "">
                </cfif>
                    
                <cfset dataRow = " ">
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(thisField.group1))>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(thisField.name))>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(thisField.value))>
                <cfset dataRow = ListAppend(dataRow, OutFunc.cleanStringForExcel(thisField.info))>
                <cfset dataRow = ListAppend(dataRow, "")>
                <cfset dataRow = ListAppend(dataRow, "")>
                <cfset ExcelFunc.addRowData(thisExcelWorkbook, dataRow)>
                
            </cfloop>
                
            <cfset dataRow = " ">
            <cfset dataRow = ListAppend(dataRow, "")>
            <cfset dataRow = ListAppend(dataRow, "")>
            <cfset dataRow = ListAppend(dataRow, "")>
            <cfset dataRow = ListAppend(dataRow, "")>
            <cfset dataRow = ListAppend(dataRow, "")>
            <cfset dataRow = ListAppend(dataRow, "")>
            <cfset ExcelFunc.addRowData(thisExcelWorkbook, dataRow)>
                                
        </cfloop> 

        <cfset SpreadsheetAddFreezePane(thisExcelWorkbook, 1, 1)>
                                
        
        <!---   END PAGE 3      --->
            
            
        <!---   OUTPUT THE ENTIRE WORKBOOK  --->
        
        <cfset SpreadSheetSetActiveSheet(thisExcelWorkbook, "SSD-Toolbox-Export")>

        <cfset fileName = "ECOTOX-Terrestrial-SSD-Report_" & exportTimeFile>
        <CFHEADER NAME="Content-Disposition" VALUE="inline; filename=#fileName#.xlsx">    
            

        <!--- stream it to the browser --->
        <cfcontent type="application/vnd-ms.excel" variable="#SpreadsheetReadBinary(thisExcelWorkbook)#">
        
    </cfprocessingdirective>

</cfif>
