<cfset ParamFunc = CreateObject("component", "cfc.searchparam_functions")>
<cfset GenFunc = CreateObject("component", "cfc.generic_functions")>

<cfparam name="URL.mode" default="">

<cfscript>
	noProcessArray  = ["FIELDNAMES"];
</cfscript>

<cfset paramsToDisplay = structnew()>
<cfset unknownParams = structnew()>
<cfset selectedChems = structnew()>
<cfset selectedEffects = structnew()>
<cfset selectedSpecs = structnew()>

<cfset postedParamCount = 0>

<!--- first look for aquatic vs terrestrial --->
<cfparam name="URL.sub" default="">
<cfif URL.sub neq "">
	<cfif URL.sub eq "aquire">
		<cfset description = "Aquatic">
	<cfelseif URL.sub eq "terrestrial">
		<cfset description = "Terrestrial">
	<cfelse>
		<cfset description = "None selected">
	</cfif>
	
	<cfset groupname = "NO-GROUP">
	<cfset cardname = ParamFunc.cardnames["habitat"]>

	<cfset paramsToDisplay = ParamFunc.setParamToDisplay(paramsToDisplay, description, groupname, cardname, description)>

	<cfset postedParamCount = postedParamCount + 1>
</cfif>

<cfset keyList = structKeyList(form)>
<cfloop list="#keyList#" index="key">
	<cfset thisvalue = form[key]>
	<cfif thisvalue neq "">

		<cfif key eq "STARTING_PUBLICATION_YEAR">
			<cfif thisvalue neq "1915" OR (isdefined("form.ENDING_PUBLICATION_YEAR") AND form.ENDING_PUBLICATION_YEAR neq YEAR(NOW()))>
				<cfset description = "Year Starting:">
				<cfset groupname = "NO-GROUP">
				<cfset cardname = ParamFunc.cardnames["pubs"]>

				<cfset paramsToDisplay = ParamFunc.setParamToDisplay(paramsToDisplay, description, groupname, cardname, thisvalue)>

				<cfset postedParamCount = postedParamCount + 1>
			</cfif>
		<cfelseif key eq "ENDING_PUBLICATION_YEAR">
			<cfif thisvalue neq YEAR(NOW()) OR (isdefined("form.STARTING_PUBLICATION_YEAR") AND form.STARTING_PUBLICATION_YEAR neq "1915")>
				<cfset description = "Year Ending:">
				<cfset groupname = "NO-GROUP">
				<cfset cardname = ParamFunc.cardnames["pubs"]>

				<cfset paramsToDisplay = ParamFunc.setParamToDisplay(paramsToDisplay, description, groupname, cardname, thisvalue)>

				<cfset postedParamCount = postedParamCount + 1>
			</cfif>
		<cfelseif key eq "RBSPECSEARCHGROUP">
			<cfif URL.mode eq "modal">
				<cfset description = "Name Search Type">
				<cfset groupname = "NO-GROUP">
				<cfset cardname = ParamFunc.cardnames["species"]>

				<cfif thisvalue eq "SCIENTIFICNAME">
					<cfset thisvalue = "Genus/Species Name">
				<cfelseif thisvalue eq "COMMONNAME">
					<cfset thisvalue = "Common Name">
				<cfelseif thisvalue eq "TAXONOMICNAME">
					<cfset thisvalue = "Other Taxonomic Names">
				<cfelse>
					<cfset thisvalue = "">
				</cfif>

				<cfset paramsToDisplay = ParamFunc.setParamToDisplay(paramsToDisplay, description, groupname, cardname, thisvalue)>
			</cfif>
		<cfelseif key eq "RBSPECSEARCHKING">
			<cfset rbKingValue = thisvalue>

			<cfset description = "Kingdom">
			<cfset groupname = "NO-GROUP">
			<cfset cardname = ParamFunc.cardnames["species"]>

			<cfif thisvalue eq "ANIMALS">
				<cfset thisvalue = "Animals">
			<cfelseif thisvalue eq "PLANTS">
				<cfset thisvalue = "Plants">
			<cfelse>
				<cfset thisvalue = "">
			</cfif>

			<cfif rbKingValue neq "BOTH" OR URL.mode eq "modal">
				<cfset paramsToDisplay = ParamFunc.setParamToDisplay(paramsToDisplay, description, groupname, cardname, thisvalue)>
			</cfif>
		<cfelseif key eq "CHEMSELECTIONS">
			<cfset selIdsChem = REReplace(thisvalue,"#chr(13)#|#chr(9)#|\n|\r",",","ALL")>
			<cfinclude template="forms/queries/review_search_chemical_rem.cfm">
			<cfoutput query="GetSelectedChemicalList">
				<cfset groupname = #GetSelectedChemicalList.CHEMICAL_LIST_DESC#>
				<cfset itemName = #left(GetSelectedChemicalList.EPA_CHEM_SUBSTANCE_NAME, 45)#>
				<cfset itemId = #GetSelectedChemicalList.CAS_NUMBER#>

				<cfset selectedChems = ParamFunc.addSelectedParameter(selectedChems, groupname, itemName, itemId)>
			</cfoutput>

		<cfelseif key eq "MEASSELECTIONS">
			<cfset selIdsEffects = REReplace(thisvalue,"#chr(13)#|#chr(9)#|\n|\r",",","ALL")>
			<cfinclude template="forms/queries/review_search_effects_rem.cfm">
			<cfoutput query="GetSelectedMeasurementList">
				<cfset groupname = #GetSelectedMeasurementList.EFFECT_DESCRIPTION#>
				<cfset itemName = #left(GetSelectedMeasurementList.DESCRIPTION, 45)#>
				<cfset itemId = #GetSelectedMeasurementList.CODE#>

				<cfset selectedEffects = ParamFunc.addSelectedParameter(selectedEffects, groupname, itemName, itemId)>
			</cfoutput>

		<cfelseif key eq "SPECSELECTIONS">
			<cfset selIdsSpecies = REReplace(thisvalue,"#chr(13)#|#chr(9)#|\n|\r",",","ALL")>
			<cfinclude template="forms/queries/review_search_species_rem.cfm">
			<cfoutput query="GetSelectedSpeciesList">
				<cfset groupname = #GetSelectedSpeciesList.SPECIES_LIST_DESC#>
				<cfset itemName = #GetSelectedSpeciesList.LATIN_NAME#>
				<cfset itemId = #GetSelectedSpeciesList.COMMON_NAME#>

				<cfset selectedSpecs = ParamFunc.addSelectedParameter(selectedSpecs, groupname, itemName, itemId)>
			</cfoutput>

		<cfelseif ( GenFunc.findInArray(noProcessArray, key, false) eq 0 )>

			<cfset desc_group_str = ParamFunc.findParamInfo( key )>

			<cfif desc_group_str neq "">
				<cfset dgcArray = ListToArray(desc_group_str, "|")>
				<cfif ArrayLen(dgcArray) eq 3>
					<cfset description = dgcArray[1]>
					<cfset groupname = dgcArray[2]>
					<cfset cardname = dgcArray[3]>

					<cfif cardname neq "">
						<cfif groupname eq "">
                            <cfset groupname = "NO-GROUP">
						</cfif>

						<cfset paramsToDisplay = ParamFunc.setParamToDisplay(paramsToDisplay, description, groupname, cardname, thisvalue)>

						<cfset postedParamCount = postedParamCount + 1>
					<cfelse>
						<cfset unknownParams[key] = thisvalue>
					</cfif>
				<cfelse>
					<cfset unknownParams[key] = thisvalue>
				</cfif>
			<cfelse>
				<cfset unknownParams[key] = thisvalue>
			</cfif>
		</cfif>
	</cfif>
</cfloop>

<cfswitch expression="#url.mode#">
    <cfcase value="modal">

        <cfinclude template="forms/review_search_params.cfm">

    </cfcase>
    
    <cfcase value="export">

        <cfinclude template="forms/review_search_export.cfm">

    </cfcase>

    <cfcase value="sidebar">

        <cfinclude template="forms/sidebar_filters.cfm">

    </cfcase>

    <cfdefaultcase>
        <div>Unknown option</div>
    </cfdefaultcase>
</cfswitch>

