    
<!---    

    EXPECTED VARIABLES FROM DB/DATA TEMPLATE:

        rowCount = count of the struct/query/etc of data results
        columnDefs = array of column definition arrays (which are string arrays - "table name", "db sort column")
        resultsArray = array of result record arrays (which are string arrays)

--->
    
<!---construct csv output --->

<cfset fileName = "ECOTOX-Term-Appendix">
<cfif URL.appid NEQ "">
    <cfset fileName = fileName & "-#URL.appid#">
</cfif>
<!---
<cfif URL.said NEQ "">
    <cfset fileName = fileName & "-sub-#URL.said#">
</cfif>
<cfif URL.subgroupid NEQ "">
    <cfset fileName = fileName & "-group-#URL.subgroupid#">
</cfif>
--->
    
<CFHEADER NAME="Content-Disposition" VALUE="attachment; filename=#fileName#.csv">
<CFCONTENT TYPE="text/plain">
  
<cfprocessingdirective suppressWhiteSpace = "Yes">

<cfset columnNameList = "">
<cfloop array="#columnDefs#" index="thisDef">
    <cfset thisColName = OutFunc.cleanStringForDataTable(thisDef[1], OUTPUTFORMAT)>
    <cfset columnNameList = listAppend(columnNameList, '#thisColName#')>
</cfloop>

<cfoutput>#columnNameList##chr(13)##chr(10)#</cfoutput>
    
<cfset dataList = "">
<cfloop array="#resultsArray#" index="thisRow">
    <cfset row = "">
    <cfloop array="#thisRow#" index="thisValue">
        <cfset thisCsvValue = thisValue>
        <cfset row = listAppend(row, '#thisCsvValue#')>    
    </cfloop>
        
    <cfoutput>#row##chr(13)##chr(10)#</cfoutput>
</cfloop>
    
</cfprocessingdirective>
    
    