    
<!---    

    EXPECTED VARIABLES FROM DB/DATA TEMPLATE:

        rowCount = count of the struct/query/etc of data results
        columnDefs = array of column definition arrays (which are string arrays - "table name", "db sort column")
        resultsArray = array of result record arrays (which are string arrays)

--->

<cfset error = "0">
<cfset errorHtml = "">
<cfset messageClass = ''>
<cfset messageTitle = ''>
<cfset messageText = ''>
    

<cfif rowCount eq 0>

    <cfset rowCount = 0>
    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "There were no results found for this selection. Please refine your search.">
    
</cfif>
        
<!---construct json output --->

<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>

<cfset colList = "">
<cfloop array="#columnDefs#" index="thisDef">
    <cfset colList = listAppend(colList, '{"title":"#thisDef[1]#","sortStr":"#thisDef[2]#"}')>
</cfloop>
    
<cfset colString = "">
<cfloop list="#colList#" index="column">
    <cfset colString = listAppend(colString, column)>
</cfloop>
    
<cfset dataString = "">
<cfloop array="#resultsArray#" index="thisRow">
    <cfset row = "">
    <cfloop array="#thisRow#" index="thisValue">
        <cfset row = listAppend(row, "#thisValue#")>    
    </cfloop>
        
    <cfset row = "[" & row & "]">    
    <cfset dataString = listAppend(dataString, row)>
</cfloop>
    
<cfset jsonString = '{"queryError":"#error#","errorHtml":"#errorHtml#","draw":"#RETURNDRAW#","recordsTotal":"#rowCount#","recordsFiltered":"#rowCount#","title":"#appendixTitle#","notes":"#appendixNotes#","columns":['>
    
<cfset jsonString = jsonString & colString & '],"records":[' & dataString & ']}'>

<cfprocessingdirective suppressWhiteSpace = "Yes">
<cfoutput>
    #jsonString#
</cfoutput>
</cfprocessingdirective>

