
<cfset ExcelFunc = CreateObject("component", "cfc.excel_functions")>  
<cfset appendixDefKeys = termAppendixObj.getAllAppendixKeys()>
<cfset ArraySort(appendixDefKeys, "text", "asc")>

<cfset OUTPUTFORMAT = "EXCEL">                             <!--- might change later and there will be more formats --->   
  
<cfprocessingdirective suppressWhiteSpace = "Yes">
    
<cfset currentAppendixNum = 1>    
<cfloop index="appId" array="#appendixDefKeys#">
    
    <cfset thisAppendixDef = termAppendixObj.getAppendixDefinition(appId)>
    <cfif NOT StructIsEmpty(thisAppendixDef)>

        <cfset exportTitle = thisAppendixDef["export_title"]>
        <cfset dbTemplate = thisAppendixDef["database_template"]>
        <cfset uiTemplate = thisAppendixDef["ui_template"]>
                    
        <cfif structKeyExists(thisAppendixDef, "code_table")>    
            <cfset codeTable = thisAppendixDef["code_table"]>
        <cfelse>
            <cfset codeTable = "">
        </cfif>
            
        <cfset sheetLabel = "#appId#.#exportTitle#">
            
        <cfinclude template="queries/#dbTemplate#">
        <cfinclude template="#uiTemplate#">
            
        <!--- 
            EXPECTED VARIABLES FROM DB/DATA TEMPLATE:

                rowCount = count of the struct/query/etc of data results
                columnDefs = array of column definition arrays (which are string arrays - "table name", "db sort column")
                resultsArray = array of result record arrays (which are string arrays)
        
        --->        
        <cfset columnNameList = "">
        <cfloop array="#columnDefs#" index="thisDef">
            <cfset columnNameList = listAppend(columnNameList, thisDef[1])>
        </cfloop>

        <cfset rowDataArray = ArrayNew(1)>
        <cfloop array="#resultsArray#" index="thisRow">
            <cfset row = "">
            <cfloop array="#thisRow#" index="thisValue">
                <cfset thisCsvValue = thisValue>
                <cfset row = listAppend(row, thisCsvValue)>    
            </cfloop>

            <cfset ArrayAppend(rowDataArray, row)>
        </cfloop>
            

        <cfif currentAppendixNum EQ 1>

            <cfset ExcelWorkbook = ExcelFunc.createNewWorkbook(sheetLabel, columnNameList, rowDataArray)>

        <cfelse>

            <cfset ExcelFunc.addWorksheet(ExcelWorkbook, sheetLabel, columnNameList, rowDataArray)>

        </cfif>

        <cfset currentAppendixNum = currentAppendixNum + 1>
    </cfif>
</cfloop>

    
<cfset fileName = "ECOTOX-Term-Appendix">    
<CFHEADER NAME="Content-Disposition" VALUE="inline; filename=#fileName#.xlsx">

<!--- stream it to the browser --->
<cfcontent type="application/vnd-ms.excel" variable="#SpreadsheetReadBinary(ExcelWorkbook)#">

</cfprocessingdirective>
    
    