
<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="AppendixCodesQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="AppendixCodesQueryVars">
        
        SELECT
            ec.code as EFFECT_CODE, ec.description as EFFECT_DESC, mc.code as MEAS_CODE, mc.description as MEAS_DESC, mc.long_description as MEAS_LONG
        FROM
            effect_codes ec
            LEFT JOIN effect_measurement_pairs ep ON ec.code = ep.effect
            LEFT JOIN measurement_codes mc ON ep.measurement = mc.code
        WHERE NOT ec.code like '~%'
        #PreserveSingleQuotes(whereClause)#
        ORDER BY ec.code, mc.description                    

    </cfquery>
    
    <!---<cflog text ="#AppendixCodesQuery.sql#">--->
    <!---<cflog text ="#ArrayToList(AppendixCodesQueryVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>


