﻿<cfset PageName="Home">
<cfinclude template="includes/head.cfm" />

<div id="homePage">
  <section id="homePageHeader" class="page-header">
    <cfinclude template="includes/updates-header.cfm" />
  </section>

  <cfinclude template="images/icons/explore-icons.svg" />

  <main id="homeContent" class="main-content">

    <section id="homeTop">
      <div id="homeAbout-row1" class="clearfix">
        <div class="card card-content raised hp-tile">
            <h3>About ECOTOX<img class="float-right" width="103" src="images/eco-kb-animal-resize.png" alt="Aquatic life, terrestrial plants and wildlife"></h3>
            <p>ECOTOX is a comprehensive Knowledgebase providing single chemical environmental toxicity data on aquatic and terrestrial species.<br/>Read more in: <a href="https://doi.org/10.1002/etc.5324" title="Olker et al. doi: 10.1002/etc.5324">Olker et al. 2022</a></p>
            <a href="help.cfm" class="button primary mb0">Learn More</a>
            <!---<a href="#" class="button primary mb0">Publication</a>--->
            <!---<div id="homeDisclaimer">
                <p><small><strong>Disclaimer:</strong> You should consult the original scientific paper to ensure an understanding of the context of the data retrieved from ECOTOX.</small></p>
            </div>--->
        </div>
        <div class="card card-content raised hp-tile">
            <h3>Getting Started</h3>
            <ul>
                <li>Use <a href="search.cfm"><b>Search</b></a> if you know exact parameters or search terms (chemical, species, etc.)</li>
                <li>Use <a href="explore.cfm"><b>Explore</b></a> to see what data may be available in ECOTOX (including data plots)</li>
            </ul>
            <cfoutput>
            <ul class="link-list">
                <li>#Application.currentUpdate["quick_link"]#</li>
                <li>#Application.currentUpdate["user_link"]#</li>
                <li><a target="_blank" href="help.cfm?sub=term-appendix"><b>ECOTOX Terms Appendix</b></a></li>
            </ul>
            </cfoutput>
        </div>
        <div class="card card-content raised hp-tile">
            <h3>Other Links</h3>
            <p>ECOTOX-related documentation and resources.</p>
            <ul class="link-list">
                <li><a href="help.cfm?sub=faq">Frequent Questions</a></li>
                <li><a href="help.cfm?sub=so-site-info#info-limitations">Limitations</a></li>
                <li><a href="help.cfm?sub=mr-databases">Other Tools/Databases</a></li>
                <li><a href="help.cfm?sub=so-additions">Recent Additions</a></li>
                <li><a style="cursor: pointer; text-decoration: underline;" data-open="ChemSearchDatesModal">Literature Search Dates</a></li>
            </ul>
        </div>
      </div>      
      <div id="homeAbout-row2" class="clearfix">
        <div class="card card-content raised hp-tile">
            <h3>New Additions!</h3>
            <p>The latest updates to the ECOTOX Knowledgebase.</p>
            <div class="tile-link">
                <a style="cursor: pointer; text-decoration: underline;" data-open="hpNewAdditions">New Additions&nbsp;&nbsp;<svg class="icon arrow" width="12" height="12"><use xlink:href="#chevron-right"></use></svg></a>
            </div>
            <cfinclude template="includes/updates/signup_button.cfm" />
        </div>
        <div class="card card-content raised hp-tile">
            <h3 class="show-bulb">Search Tip</h3>
            <p>Example usage of ECOTOX Knowledgebase</p>
            <div class="tile-link">
                <a style="cursor: pointer; text-decoration: underline;" data-open="hpSearchTip">Search Tip&nbsp;&nbsp;<svg class="icon arrow" width="12" height="12"><use xlink:href="#chevron-right"></use></svg></a>
            </div>
        </div>
        <div class="card card-content raised hp-tile">
            <h3>ASCII Download</h3>
            <div id="homeDownload">
                <p>Download the entire database as an ASCII file via the button below.</p>
                <div class="download-info btn-group">
                    <a class="button success export ascii-link" data-toggle="asciiExportLinks">Download <span>ASCII Data</span></a>
                    <a class="button success small" data-toggle="asciiInfoDropdown"><img src="images/icons/info-circle-white.svg" alt="More information on ASCII Data Downloads"></a>
                </div>
            </div>
        </div>
      </div>
    </section>      
    <div class="clearfix"></div>
  </main>
</div>

<div id="asciiExportLinks" class="dropdown-pane medium" data-dropdown>
    <cfoutput>
    <div><a class="ascii-link" href="#Application.currentUpdate['ascii']#"><strong>Download for Windows (.exe)</strong></a></div>
    <div><a class="ascii-link" href="#REPLACE(Application.currentUpdate['ascii'], '.exe', '.zip', 'ALL')#"><strong>Download .zip file</strong></a></div>
    </cfoutput>
</div>

<div class="reveal" id="ChemSearchDatesModal" data-reveal>
    <button class="close-button" data-close aria-label="Close modal" type="button">
        <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
    </button>
    <cfinclude template="pages/lit-search-results.cfm" />
</div>

<div id="asciiInfoDropdown" class="dropdown-pane large" data-dropdown>
  <div class="callout primary">
    <cfoutput>
    <p>Updated Date: <strong class="date">#Application.currentUpdate["update_date_desc"]#</strong></p>
    </cfoutput>
  </div>
  <p>You can download the entire ECOTOX data set as pipe( | ) delimited ASCII files. This does not include any software and will require reconstructing various files together in order to assemble a working database. Within the zip file, you will find data tables, field descriptions and graphical relations of the data structure. Consult the <a target="_blank" href="help.cfm?sub=term-appendix">ECOTOX Terms Appendix</a> for more information on the individual fields contained in each of the records.</p>
  <p>The data files are stored in a Windows compatible self-extracting ZIP format and can be accessed by double clicking on the ecotox_ascii_**-**-****.exe file once it has been downloaded to your computer.</p>
  <p>Alternatively, the data files can be downloaded as a .zip file.</p>
</div>

<div class="reveal" id="hpNewAdditions" data-reveal>
    <button class="close-button" data-close aria-label="Close modal" type="button">
        <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
    </button>
    <div id="homeUpdatesVisuals" class="main-content">
        <div class="text">
          <h2><em><b>New</b></em> Additions!</h2>
          <p>In addition to chemical data updates, ECOTOX has added new features based on user feedback:</p>
          <cfoutput>#Application.currentUpdate["recent_additions"]#</cfoutput>
          <p><em><b>Did you know?</b></em>  There are multiple resources on how to use ECOTOX, including:
            <ul style="padding-top: 0; padding-left: 25px;">
                <li>The new ECOTOX Knowledgebase Virtual Training <a style="cursor: pointer; text-decoration: underline;" href="https://www.youtube.com/watch?v=SVBTbvNnczs" target="_blank">recording</a> and <a style="cursor: pointer; text-decoration: underline;" href="https://epa.figshare.com/articles/presentation/ECOTOXicology_Knowledgebase_Virtual_Training/19804039" target="_blank">slide deck</a> (presented in May 2022) that are now available on the EPA's new <a style="cursor: pointer; text-decoration: underline;" href="http://www.epa.gov/chemical-research/new-approach-methods-nams-training" target="_blank">New Approach Methods (NAMs) Training</a> website. This training website includes resources for multiple tools. To find the most recent ECOTOX trainings, filter the Topic and Subtopic to 'Ecotoxicology' and sort by Year.</li>
                <li><a style="cursor: pointer; text-decoration: underline;" href="help.cfm" target="_blank">Help</a> page which includes the ECOTOX <a style="cursor: pointer; text-decoration: underline;" href="https://epa.figshare.com/articles/online_resource/ECOTOX_5_6_User_Guide/26764645/1?file=48991039" target="_blank">User Guide</a>, <a style="cursor: pointer; text-decoration: underline;" href="help.cfm?sub=hd-basics" target="_blank">Learning the Basics</a>, <a style="cursor: pointer; text-decoration: underline;" href="help.cfm?sub=wi-definitions" target="_blank">Data Field Definitions and Terms</a>, and the <a style="cursor: pointer; text-decoration: underline;" href="help.cfm?sub=term-appendix" target="_blank">Terms Appendix</a> with the ECOTOX-specific controlled vocabulary.</li>            
                <li><a style="cursor: pointer; text-decoration: underline;" href="contact.cfm" target="_blank">Contact Us</a> page where you can submit comments and questions about ECOTOX including technical questions about conducting queries and exporting data.</li>
            </ul>            
          </p>
        </div>
    </div>
</div>

<div class="reveal" id="hpSearchTip" data-reveal>
    <button class="close-button" data-close aria-label="Close modal" type="button">
        <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
    </button>
    <div id="homeUpdates">
        <cfoutput>
        <div class="main-content">
            <h2>Search Tip</h2>
            <h3>#Application.currentUpdate["tip_title"]#</h3>
            #Application.currentUpdate["tip_text"]#
        </div>
        </cfoutput>
    </div>
</div>

<cfinclude template="includes/updates/signup_modal.cfm" />

<cfinclude template="includes/end.cfm" />

