<!---

	Template:			inputfilter.cfm
	Author:				Peter Muzila
	Revised:            5/20/2003   recursive tag replacement

	Source Control:		$Header: $

	Description:

		The cf_inputFilter tag removes characters or tags from all fields coming from the
		specified scopes (form,cookie, or url). This tag can be placed in the Application.cfm
		file to filter out any input coming thru these scopes to any of the templates belonging
		to the application.cfm file.

		This tag can be executed only with CF 4.5 or higher

	Usage:

		<cf_inputFilter
			scopes = "[FORM][,COOKIE][,URL]"
			chars = "list_of_chars"
			tags = "ALL|list_of_tags"
		>

	Attributes:

		scopes (string list, required) - comma-delimited list of input scopes to be filtered
		chars (string, optional) - string containing set of characters to be filtered out from the
			input scope
		tags (string list, optional) - comma-delimited list of tag names to be filtered out from the
			input scope


--->

<!--- attributes validation --->
<cfparam name="attributes.scopes">
<cfparam name="attributes.chars" default="">
<cfparam name="attributes.tags" default="">


<cfscript>

	// prepare reg expression for the tag search
	reTags = "" ;
	if ( attributes.tags eq "ALL" )
		// re for any tag - "<*>"
		reTags = "<[^>]*>" ;
	else if ( attributes.tags neq "" )
		// re for any of the listed tags - "<tag1|tag2|...|tagN>"
		reTags = "</?(#ListChangeDelims(attributes.tags,  '|', ',' )#)[^>]*>" ;

	// get comma-delimited list of chars from char set
	charList = '' ;
	if ( attributes.chars neq "" ) {
		charList = attributes.chars ;

		for ( i=Len(attributes.chars)-1; i gte 1; i=i-1 )
			charList = Insert( ",", charList, i ) ;
	}

</cfscript>


<cfloop list="#attributes.scopes#" index="scopeName">
	<cfif not findnocase("multipart/form-data",cgi.CONTENT_TYPE)>
		<cfscript>

			// get the handle for the scope (form, cookie, url)
			s = Evaluate( scopeName ) ;

			// scroll thru fields in the scope and handle only simple values
			for ( field in s )
				if ( IsSimpleValue( s[field] ) ) {

                	// replace tags - recursively until there are no more unwanted tags
                		if ( reTags neq '' )
                		do 	{	prev = s[field];
                				s[field] = REReplaceNoCase( s[field], reTags, "", "ALL" );
                			} while (prev NEQ s[field]) ;

					// replace chars
					if ( charList neq '' )
						s[field] = ReplaceList( s[field], charList, "" ) ;
				}

		</cfscript>
	</cfif>

</cfloop>
