<cfparam name="FORM.caslist" default="">
<cfparam name="FORM.dtxsidlist" default="">
<cfparam name="FORM.specidlist" default="">
<cfparam name="FORM.ncbilist" default="">
<cfparam name="FORM.custspecchemlist" default="">
<cfparam name="FORM.effmeaslist" default="">
<cfparam name="FORM.pubeffectgroups" default="">

<cfparam name="FORM.ecoref" default="">
<cfparam name="FORM.origreflist" default="">

<cfparam name="FORM.chemgroupid" default="">
<cfparam name="FORM.specgroupid" default="">
<cfparam name="FORM.effgroupid" default="">

<cfparam name="FORM.habitat" default="">
<cfparam name="FORM.chemlistid" default="">
<cfparam name="FORM.casid" default="">
<cfparam name="FORM.specieslistid" default="">
<cfparam name="FORM.class" default="">
<cfparam name="FORM.tax_order" default="">
<cfparam name="FORM.genus" default="">
<cfparam name="FORM.family" default="">
<cfparam name="FORM.speciesid" default="">
<cfparam name="FORM.special" default="">
<cfparam name="FORM.effectid" default="">
<cfparam name="FORM.measurementid" default="">
<cfparam name="FORM.endpointid" default="">
<cfparam name="FORM.obsduration" default="">
<cfparam name="FORM.obsdurmin" default="">
<cfparam name="FORM.obsdurmax" default="">
<cfparam name="FORM.pubyearmin" default="">
<cfparam name="FORM.pubyearmax" default="">


<!--- numeric size checks --->
<cfif FORM.pubyearmin NEQ "">
    <cfif FORM.pubyearmin LT 0 OR FORM.pubyearmin GT 10000>
        <cfset FORM.pubyearmin = "">
    </cfif>
</cfif>
<cfif FORM.pubyearmax NEQ "">
    <cfif FORM.pubyearmax LT 0 OR FORM.pubyearmax GT 10000>
        <cfset FORM.pubyearmax = "">
    </cfif>
</cfif>

<cfif FORM.obsdurmin NEQ "">
    <cfif IsValid("regex", FORM.obsdurmin, "^[0-9,.-]*$")>
        <cfif FORM.obsdurmin LT 0>            
            <cfset FORM.obsdurmin = "">
        </cfif>
    <cfelse>
        <cfset FORM.obsdurmin = "">
    </cfif>
</cfif>
<cfif FORM.obsdurmax NEQ "">
    <cfif IsValid("regex", FORM.obsdurmax, "^[0-9,.-]*$")>
        <cfif FORM.obsdurmax LT 0>            
            <cfset FORM.obsdurmax = "">
        </cfif>
    <cfelse>
        <cfset FORM.obsdurmax = "">
    </cfif>
</cfif>

<cfif FORM.obsduration neq "">
    <cfset validParam = 1>
    <cfloop list="#FORM.obsduration#" index="thisDuration">
        <cfif IsValid("regex", thisDuration, "^[0-9,.-]*$")>
            <cfif thisDuration LT 0>
                <cfset validParam = 0>
            </cfif>
        <cfelse>
            <cfset validParam = 0>
        </cfif>
    </cfloop>
    <cfif validParam EQ 0>
        <cfset FORM.obsduration = "">
    </cfif>
</cfif>

<cfif FORM.casid neq "">
    <cfset validParam = 1>
    <cfloop list="#FORM.casid#" index="thisCas">
        <cfif thisCas LT 0 OR thisCas GT 10000000000>
            <cfset validParam = 0>
        </cfif>
    </cfloop>
    <cfif validParam EQ 0>
        <cfset FORM.casid = "">
    </cfif>
</cfif>

<cfif FORM.speciesid neq "">
    <cfset validParam = 1>
    <cfloop list="#FORM.speciesid#" index="thisSpecId">
        <cfif thisSpecId LT 0 OR thisSpecId GT 10000000000>
            <cfset validParam = 0>
        </cfif>
    </cfloop>
    <cfif validParam EQ 0>
        <cfset FORM.speciesid = "">
    </cfif>
</cfif>

<cfif FORM.chemgroupid neq "">
    <cfset validParam = 1>
    <cfloop list="#FORM.chemgroupid#" index="thisItem">
        <cfif thisItem LT 0 OR thisItem GT 1000>
            <cfset validParam = 0>
        </cfif>
    </cfloop>
    <cfif validParam EQ 0>
        <cfset FORM.chemgroupid = "">
    </cfif>
</cfif>

<cfif FORM.specgroupid neq "">
    <cfset validParam = 1>
    <cfloop list="#FORM.specgroupid#" index="thisItem">
        <cfif thisItem LT 0 OR thisItem GT 1000>
            <cfset validParam = 0>
        </cfif>
    </cfloop>
    <cfif validParam EQ 0>
        <cfset FORM.specgroupid = "">
    </cfif>
</cfif>

<cfif FORM.chemlistid neq "">
    <cfset validParam = 1>
    <cfloop list="#FORM.chemlistid#" index="thisItem">
        <cfif thisItem LT 0 OR thisItem GT 1000>
            <cfset validParam = 0>
        </cfif>
    </cfloop>
    <cfif validParam EQ 0>
        <cfset FORM.chemlistid = "">
    </cfif>
</cfif>

<cfif FORM.specieslistid neq "">
    <cfset validParam = 1>
    <cfloop list="#FORM.specieslistid#" index="thisItem">
        <cfif thisItem LT 0 OR thisItem GT 1000>
            <cfset validParam = 0>
        </cfif>
    </cfloop>
    <cfif validParam EQ 0>
        <cfset FORM.specieslistid = "">
    </cfif>
</cfif>

<!--- white list checks --->
<cfif FORM.special neq "">
    <cfset validParam = 1>
    <cfloop list="#FORM.special#" index="thisGroup">
        <cfif thisGroup NEQ "All"
            AND thisGroup NEQ "STANDARD_TEST_SPECIES_YN"
            AND thisGroup NEQ "THREATENED_ENDANGERED_YN"
            AND thisGroup NEQ "EXOTIC_NUISANCE_YN"
        >
            <cfset validParam = 0>
        </cfif>
    </cfloop>
    <cfif validParam EQ 0>
        <cfset FORM.special = "">
    </cfif>
</cfif>

<!--- set common variables for backend --->
<cfset IN_casList = FORM.caslist>
<cfset IN_dtsxIdList = FORM.dtxsidlist>
<cfset IN_speciesIdList = FORM.specidlist>
<cfset IN_ncbiList = FORM.ncbilist>
<cfset IN_custSpecChemList = FORM.custspecchemlist>
<cfset IN_effMeasList = FORM.effmeaslist>

<cfset IN_ecoref = FORM.ecoref>
<cfset IN_origreflist = FORM.origreflist>

<cfset IN_chemGroupId = FORM.chemgroupid>
<cfset IN_specGroupId = FORM.specgroupid>
<cfset IN_effGroupId = FORM.effgroupid>

<cfset IN_habitat = FORM.habitat>
<cfset IN_chemListId = FORM.chemlistid>
<cfset IN_casId = FORM.casid>
<cfset IN_speciesListId = FORM.specieslistid>
<cfset IN_class = FORM.class>
<cfset IN_taxOrder = FORM.tax_order>
<cfset IN_genus = FORM.genus>
<cfset IN_family = FORM.family>
<cfset IN_speciesId = FORM.speciesid>
<cfset IN_special = FORM.special>
<cfset IN_effectId = FORM.effectid>
<cfset IN_measurementId = FORM.measurementid>
<cfset IN_endpointId = FORM.endpointid>
<cfset IN_obsDuration = FORM.obsduration>
<cfset IN_obsDurMin = FORM.obsdurmin>
<cfset IN_obsDurMax = FORM.obsdurmax>
<cfset IN_pubYearMin = FORM.pubyearmin>
<cfset IN_pubYearMax = FORM.pubyearmax>
    
<cfset custEffectList = "">
<cfset custMeasList = "">
<cfif IN_effMeasList neq "">
    <cfloop list="#IN_effMeasList#" index="codePair">
        <cfset codePairAry = ListToArray(codePair, "|")>
        <cfif ArrayLen(codePairAry) eq 2>
            <cfif codePairAry[1] neq "" AND codePairAry[2] neq "">
                <cfset custEffectList = listAppend(custEffectList, codePairAry[1])>
                <cfset custMeasList = listAppend(custMeasList, codePairAry[2])>
            </cfif>
        </cfif>
    </cfloop>
    <cfset concatCustEffMeasList = REPLACE(IN_effMeasList,'|', '', 'ALL')>
<cfelse>
    <cfset concatCustEffMeasList = "All">
</cfif>


<!--- Publications --->
<cfif IN_ecoref is "">
    <cfset IN_ecoref = "All">
</cfif>

<!--- Group selectors --->
<cfif IN_chemGroupId is "">
	<cfset IN_chemGroupId = "All">
</cfif>

<cfif IN_specGroupId is "">
	<cfset IN_specGroupId = "All">
</cfif>

<cfif IN_effGroupId is "">
    <cfset IN_effGroupId = FORM.pubeffectgroups>
    <cfif IN_effGroupId is "">
	    <cfset IN_effGroupId = "All">
    </cfif>
</cfif>

<!--- Filters --->
<cfif IN_habitat is "">
	<cfset IN_habitat = "All">
</cfif>

<cfif IN_chemListId is "">
	<cfset IN_chemListId = "All">
</cfif>

<cfif IN_casId is "">
    <cfif IN_custSpecChemList neq "">
        <cfset IN_casId = IN_custSpecChemList>
    <cfelse>
	    <cfset IN_casId = "All">
    </cfif>       
</cfif>

<cfif IN_speciesListId is "">
	<cfset IN_speciesListId = "All">
</cfif>

<cfif IN_class is "">
	<cfset IN_class = "All">
</cfif>

<cfif IN_taxOrder is "">
	<cfset IN_taxOrder = "All">
</cfif>

<cfif IN_genus is "">
	<cfset IN_genus = "All">
</cfif>

<cfif IN_family is "">
	<cfset IN_family = "All">
</cfif>

<cfif IN_speciesid is "">            
    <cfif IN_speciesIdList neq "">
        <cfset IN_speciesid = IN_speciesIdList>
    <cfelse>
	<cfset IN_speciesid = "All">
    </cfif>
</cfif>

<cfif IN_special is "">
	<cfset IN_special = "All">
</cfif>

<cfif IN_effectId is "">            
    <cfif custEffectList neq "">
        <cfset IN_effectId = custEffectList>
    <cfelseif FORM.pubeffectgroups neq "">        
        <cfset IN_effectId = FORM.pubeffectgroups>
    <cfelse>    
	    <cfset IN_effectId = "All">
    </cfif>
</cfif>

<cfif IN_measurementId is "">            
    <cfif custMeasList neq "">
        <cfset IN_measurementId = custMeasList>
    <cfelse>
	    <cfset IN_measurementId = "All">
    </cfif>
</cfif>

<cfif IN_endpointId is "">
	<cfset IN_endpointId = "All">
</cfif>

<cfif IN_obsDuration is "">
	<cfset IN_obsDuration = "All">
</cfif>

<cfif IN_obsDurMin is "">
	<cfset IN_obsDurMin = "All">
</cfif>

<cfif IN_obsDurMax is "">
	<cfset IN_obsDurMax = "All">
</cfif>

<cfif IN_pubYearMin is "">
	<cfset IN_pubYearMin = "1915">
</cfif>

<cfif IN_pubYearMax is "">
	<cfset IN_pubYearMax = "#Year(Now())#">
</cfif>
