<cfset GenFunc = CreateObject("component", "cfc.generic_functions")>
<cfset GroupFunc = CreateObject("component", "cfc.group_option_functions")>

<cfif URL.category eq "ChemGroup">
	<cfset value_field = "dv.chemical_list_id">
	<cfset desc_field = "dv.chemical_list_desc">
	<cfset sort_field = "dv.sel_index">
	<cfset order_by_fields = "dv.sel_index">
	<cfset joined_desc_view = "">
	<cfset mv_join_field = "">
	<cfset dv_join_field = "">
<cfelseif URL.category eq "SpecGroup">
	<cfset value_field = "v.species_list_id">
	<cfset desc_field = "dv.species_list_desc">
	<cfset sort_field = "dv.sel_index">
	<cfset order_by_fields = "dv.sel_index">
	<cfset joined_desc_view = "species_group_top_mv">
	<cfset mv_join_field = "species_list_id">
	<cfset dv_join_field = "species_list_id">
<cfelseif URL.category eq "EffectGroup">
	<cfset value_field = "v.effect">
	<cfset desc_field = "REPLACE(dv.effect_description, ' (Delayed)', '')">
	<cfset sort_field = "dv.sel_index">
	<cfset order_by_fields = "dv.sel_index">
	<cfset joined_desc_view = "effects_group_top_mv">
	<cfset mv_join_field = "effect">
	<cfset dv_join_field = "effect_code">
</cfif>

<cfquery name="OptionQuery" datasource="#application.datasource#" dbtype="Oracle80" cachedWithin="#CreateTimeSpan(0,0,5,0)#">
	SELECT DISTINCT #value_field# as SEL_VALUE, #PreserveSingleQuotes(desc_field)# as SEL_DESC, #sort_field# as SORTFIELD
	FROM #view_name# v
<cfif URL.category eq "ChemGroup">
	INNER JOIN chemical_list_xref cx ON v.cas_number = cx.cas_number
	INNER JOIN chemical_group_top_mv dv ON cx.chemical_listid = dv.chemical_list_id
<cfelse>
	LEFT OUTER JOIN #joined_desc_view# dv ON v.#mv_join_field# = dv.#dv_join_field#
</cfif>
	WHERE 1=1

	<!---
		this refers to the original group of ecorefs from EP, if applicable.  we always want to filter by these if there is a value,
		regardless of whether there is further filtering by other user inputs (ie. author/title below)
	 --->
	<cfif IN_origreflist neq "">
		<cfif ListLen(IN_origreflist) LTE 1000>
			AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_origreflist#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_origreflist, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>

	<!--- for author / title --->
	<cfif IN_ecoref neq "All">
		<cfif ListLen(IN_ecoref) LTE 1000>
			AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_ecoref#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_ecoref, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>
	
	<!--- check group selectors --->
	<cfif IN_chemGroupId neq "All">
		<cfif IN_chemGroupId eq "99" AND IN_casList neq "">
			<cfif len(IN_casList)>                
                <cfif ListLen(IN_casList) LTE 1000>
                    AND v.cas_number IN (<CFQUERYPARAM VALUE="#IN_casList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                <cfelse>
                    <cfset arrayOfLists = GenFunc.splitListToSublists(IN_casList, 1000)>
                    <cfif ArrayLen(arrayOfLists) GTE 1>
                    AND (
                        <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                            <cfset thisSubList = arrayOfLists[i]>
                            <cfif i GT 1> OR </cfif>                            
                            v.cas_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                        </cfloop>
                    )
                    </cfif>
                </cfif>
            </cfif>
		<cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
			AND v.dtxsid IN (<CFQUERYPARAM VALUE="#IN_dtsxIdList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99">
			<!--- do nothing - this is handled with chemicals below --->
		<cfelse>
			AND v.cas_number IN (
				SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
			)
		</cfif>
	</cfif>
		
	<cfif IN_specGroupId neq "All">
		<cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">
			AND ncbi_taxid IN (<CFQUERYPARAM VALUE="#IN_ncbiList#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		<cfelseif IN_specGroupId eq "99">
			<!--- do nothing - this is handled with species below --->
		<cfelse>
			AND v.species_list_id in (<CFQUERYPARAM VALUE="#IN_specGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		</cfif>
	</cfif>
		
	<cfif IN_effGroupId neq "All" AND IN_effGroupId neq "99">
		<cfif ListLen(IN_effGroupId, ",") gt 1>
			AND (
				<cfloop from="1" to="#ListLen(IN_effGroupId)#" index="idx">
					<cfif idx neq 1> OR </cfif>
					(effect LIKE <CFQUERYPARAM VALUE="#ListGetAt(IN_effGroupId, idx)#%" CFSQLTYPE="CF_SQL_VARCHAR">)
				</cfloop>
			)
		<cfelse>
			AND effect LIKE <CFQUERYPARAM VALUE="#IN_effGroupId#%" CFSQLTYPE="CF_SQL_VARCHAR">
		</cfif>
	</cfif>
	
	<!--- check additional filters --->
	<cfif IN_chemListId neq "All">
		AND v.cas_number IN (
			SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		)
	</cfif>
	
	<cfif IN_casId neq "All">
		AND v.cas_number IN (<CFQUERYPARAM VALUE="#IN_casId#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
	</cfif>	
	
	<cfif IN_speciesListId neq "All">
		AND v.species_list_id in (<CFQUERYPARAM VALUE="#IN_speciesListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>			
	
	<cfif IN_class neq "All">
		AND v.class IN (<CFQUERYPARAM VALUE="#IN_class#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>		
	
	<cfif IN_taxOrder neq "All">
		AND v.tax_order IN (<CFQUERYPARAM VALUE="#IN_taxOrder#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	
	
	<cfif IN_genus neq "All">
		AND v.genus IN (<CFQUERYPARAM VALUE="#IN_genus#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_family neq "All">
		AND v.family IN (<CFQUERYPARAM VALUE="#IN_family#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesId neq "All">
		AND v.species_number IN (<CFQUERYPARAM VALUE="#IN_speciesId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>
	
	<cfif IN_effectId neq "All">
		AND v.effect IN (<CFQUERYPARAM VALUE="#IN_effectId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_measurementId neq "All">
		AND v.measurement IN (<CFQUERYPARAM VALUE="#IN_measurementId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
                
	<!--- custom effects / measurement groups --->
	<cfif concatCustEffMeasList neq "All">
		AND CONCAT(v.effect, v.measurement) IN (<CFQUERYPARAM VALUE="#concatCustEffMeasList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_endpointId neq "All">
		AND v.endpoint IN (<CFQUERYPARAM VALUE="#IN_endpointId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	

        <!--- DURATION LOGIC HERE (v.) --->
	<cfinclude template="duration_logic_sql.cfm">
	
	<cfif IN_habitat neq "All">
		AND v.habitat IN (<CFQUERYPARAM VALUE="#IN_habitat#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
		AND v.publication_year between <CFQUERYPARAM VALUE="#IN_pubYearMin#" CFSQLTYPE="CF_SQL_VARCHAR"> AND <CFQUERYPARAM VALUE="#IN_pubYearMax#" CFSQLTYPE="CF_SQL_VARCHAR">
		
		<!--- special interest groups are no longer determined by species group, so include this to make sure not to return any of these items matching species_list_id between 13-15 --->
                <!--- algae/moss/fungi split into 3 groups so exclude the old combined group as well (11) --->
		AND (v.species_list_id IS NULL OR v.species_list_id NOT IN (11,13,14,15))

	ORDER BY #order_by_fields#	
</cfquery>


<cfset optionOutputStruct = structnew()>
<cfoutput query="OptionQuery">
	<cfif #SEL_DESC# neq "" AND #SEL_VALUE# neq "">	
		<cfset selStr = "">
		<cfset selUIval = "">
	
		<cfif URL.category eq "ChemGroup">
			
			<cfset selUIval = IN_chemListId>			
		
		<cfelseif URL.category eq "SpecGroup">
			
			<cfset selUIval = IN_speciesListId>
	
		<cfelseif URL.category eq "EffectGroup">
		
			<cfset selUIval = IN_effectId>
		
		</cfif>
	
		<cfif ListContains(selUIval, #SEL_VALUE#) gt 0>
			<cfset selStr = " selected">
		</cfif>
		
		<cfset optionOutputStruct["#SEL_VALUE#"] = selStr>	
	</cfif>	
</cfoutput>


<cfif URL.category eq "ChemGroup">			
	<cfset optionArray = GroupFunc.getFilteredChemGroupOptions(optionOutputStruct)>
<cfelseif URL.category eq "SpecGroup">	
	<cfset optionArray = GroupFunc.getFilteredSpecGroupOptions(optionOutputStruct)>
<cfelseif URL.category eq "EffectGroup">	
	<cfset optionArray = GroupFunc.getFilteredEffectGroupOptions(optionOutputStruct)>
</cfif>

<cfloop from="1" to="#ArrayLen(optionArray)#" index="i">
	<cfoutput>#optionArray[i]#</cfoutput>
</cfloop>


