
<cfparam name="URL.id" default=1>
<cfparam name="URL.category" default="">

<cfinclude template="explore_param_check.cfm" />


<cfif URL.category eq "Chemicals">
	<cfset id_field = "cas_number">
	<cfset desc_field = "epa_chem_substance_name">
	<cfset common_desc_field = "epa_chem_substance_name">

<cfelseif URL.category eq "Species">
	<cfset id_field = "species_number">
	<cfset desc_field = "latin_name">
	<cfset common_desc_field = "common_name">

<cfelseif URL.category eq "Effects">
	<cfset id_field = "measurement_desc">
	<cfset desc_field = "effect">
	<cfset common_desc_field = "measurement">

</cfif>


<cfquery name="CountQuery" datasource="#application.datasource#" dbtype="Oracle80" cachedWithin="#CreateTimeSpan(0,1,0,0)#">
	SELECT COUNT(*) as ct
	FROM (
		SELECT iq.#id_field# as THIS_ID, iq.#desc_field# as THIS_DESC, iq.#common_desc_field# as THIS_COMMON_DESC,
			COUNT (iq.result_id) AS num_records,
			COUNT (DISTINCT iq.ecoref_number) AS pub_count,
			MIN (iq.publication_year) AS year_min,
			MAX (iq.publication_year) AS year_max
		FROM (
			SELECT DISTINCT v.#id_field#, v.#desc_field#<cfif "#desc_field#" neq "#common_desc_field#">, v.#common_desc_field#</cfif>, v.result_id, v.ecoref_number, v.publication_year
			FROM ecotox_group_summary3_mv v
			WHERE 1=1
			
	<!--- check group selectors --->
	<cfif IN_chemGroupId neq "All">
		<cfif IN_chemGroupId eq "99" AND IN_casList neq "">
			AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
			AND dtxsid IN (<CFQUERYPARAM VALUE="#IN_dtsxIdList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99">
			<!--- do nothing - this is handled with chemicals below --->
		<cfelse>
			AND cas_number IN (
				SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
			)
		</cfif>
	</cfif>
		
	<cfif IN_specGroupId neq "All">
		<cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">
			AND ncbi_taxid IN (<CFQUERYPARAM VALUE="#IN_ncbiList#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		<cfelseif IN_specGroupId eq "99">
			<!--- do nothing - this is handled with species below --->
		<cfelse>
			AND species_list_id in (<CFQUERYPARAM VALUE="#IN_specGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		</cfif>
	</cfif>

	<cfif IN_effGroupId neq "All" AND IN_effGroupId neq "99">
		<cfif ListLen(IN_effGroupId, ",") gt 1>
			AND (
				<cfloop from="1" to="#ListLen(IN_effGroupId)#" index="idx">
					<cfif idx neq 1> OR </cfif>
					(effect LIKE <CFQUERYPARAM VALUE="#ListGetAt(IN_effGroupId, idx)#%" CFSQLTYPE="CF_SQL_VARCHAR">)
				</cfloop>
			)
		<cfelse>
			AND effect LIKE <CFQUERYPARAM VALUE="#IN_effGroupId#%" CFSQLTYPE="CF_SQL_VARCHAR">
		</cfif>
	</cfif>

	<!--- check additional filters --->	
	<cfif IN_chemListId neq "All">
		AND cas_number IN (
			SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		)
	</cfif>

	<cfif IN_casId neq "All">
		AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casId#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesListId neq "All">
		AND species_list_id in (<CFQUERYPARAM VALUE="#IN_speciesListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>		
	
	<cfif IN_class neq "All">
		AND class IN (<CFQUERYPARAM VALUE="#IN_class#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>		
	
	<cfif IN_taxOrder neq "All">
		AND tax_order IN (<CFQUERYPARAM VALUE="#IN_taxOrder#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	
	
	<cfif IN_genus neq "All">
		AND genus IN (<CFQUERYPARAM VALUE="#IN_genus#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_family neq "All">
		AND family IN (<CFQUERYPARAM VALUE="#IN_family#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesId neq "All">
		AND species_number IN (<CFQUERYPARAM VALUE="#IN_speciesId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>
	
	<cfif IN_special neq "All">
		<cfset loop = 0>
		AND (
		<cfloop index="thisSpecInt" list="#IN_special#" delimiters=",">
			<cfif loop gt 0> OR </cfif>
			 (#thisSpecInt# = 'Y')
			 <cfset loop = loop + 1>
		</cfloop>
		)
	</cfif>
	
	<cfif IN_effectId neq "All">
		AND effect IN (<CFQUERYPARAM VALUE="#IN_effectId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_measurementId neq "All">
		AND measurement IN (<CFQUERYPARAM VALUE="#IN_measurementId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
                
	<!--- custom effects / measurement groups --->
	<cfif concatCustEffMeasList neq "All">
		AND CONCAT(effect, measurement) IN (<CFQUERYPARAM VALUE="#concatCustEffMeasList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_endpointId neq "All">
		AND endpoint IN (<CFQUERYPARAM VALUE="#IN_endpointId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	

        <!--- DURATION LOGIC HERE --->
	<cfinclude template="duration_logic_sql.cfm">
	
	<cfif IN_habitat neq "All">
		AND habitat IN (<CFQUERYPARAM VALUE="#IN_habitat#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
		AND publication_year between <CFQUERYPARAM VALUE="#IN_pubYearMin#" CFSQLTYPE="CF_SQL_VARCHAR"> AND <CFQUERYPARAM VALUE="#IN_pubYearMax#" CFSQLTYPE="CF_SQL_VARCHAR">
		
			<!--- special interest groups are no longer determined by species group, so include this to make sure not to return any of these items matching species_list_id between 13-15 --->
                        <!--- algae/moss/fungi split into 3 groups so exclude the old combined group as well (11) --->
                        AND (v.species_list_id IS NULL OR v.species_list_id NOT IN (11,13,14,15))
			
		)
		iq
		GROUP BY iq.#id_field#, iq.#desc_field#<cfif "#desc_field#" neq "#common_desc_field#">, iq.#common_desc_field#</cfif>
	)
	oq
	
</cfquery>


<cfquery name="ReferenceQuery" datasource="#application.datasource#" dbtype="Oracle80" cachedWithin="#CreateTimeSpan(0,1,0,0)#">
	SELECT oq.THIS_ID, oq.THIS_DESC, oq.THIS_COMMON_DESC, oq.dtxsid, oq.num_records, oq.pub_count, oq.year_min, oq.year_max
	FROM (
		SELECT iq.#id_field# as THIS_ID, iq.#desc_field# as THIS_DESC, iq.#common_desc_field# as THIS_COMMON_DESC, MIN (iq.dtxsid) as dtxsid,
			COUNT (iq.result_id) AS num_records,
			COUNT (DISTINCT iq.ecoref_number) AS pub_count,
			MIN (iq.publication_year) AS year_min,
			MAX (iq.publication_year) AS year_max
		FROM (
			SELECT DISTINCT v.#id_field#, v.#desc_field#<cfif "#desc_field#" neq "#common_desc_field#">, v.#common_desc_field#</cfif>, v.result_id, v.ecoref_number, v.publication_year, v.dtxsid
			FROM ecotox_group_summary3_mv v
			WHERE 1=1	
			
	<!--- check group selectors --->
	<cfif IN_chemGroupId neq "All">
		<cfif IN_chemGroupId eq "99" AND IN_casList neq "">
			AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
			AND dtxsid IN (<CFQUERYPARAM VALUE="#IN_dtsxIdList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99">
			<!--- do nothing - this is handled with chemicals below --->
		<cfelse>
			AND cas_number IN (
				SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
			)
		</cfif>
	</cfif>
		
	<cfif IN_specGroupId neq "All">
		<cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">
			AND ncbi_taxid IN (<CFQUERYPARAM VALUE="#IN_ncbiList#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		<cfelseif IN_specGroupId eq "99">
			<!--- do nothing - this is handled with species below --->
		<cfelse>
			AND species_list_id in (<CFQUERYPARAM VALUE="#IN_specGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		</cfif>
	</cfif>

	<cfif IN_effGroupId neq "All" AND IN_effGroupId neq "99">
		<cfif ListLen(IN_effGroupId, ",") gt 1>
			AND (
				<cfloop from="1" to="#ListLen(IN_effGroupId)#" index="idx">
					<cfif idx neq 1> OR </cfif>
					(effect LIKE <CFQUERYPARAM VALUE="#ListGetAt(IN_effGroupId, idx)#%" CFSQLTYPE="CF_SQL_VARCHAR">)
				</cfloop>
			)
		<cfelse>
			AND effect LIKE <CFQUERYPARAM VALUE="#IN_effGroupId#%" CFSQLTYPE="CF_SQL_VARCHAR">
		</cfif>
	</cfif>

	<!--- check additional filters --->	
	<cfif IN_chemListId neq "All">
		AND cas_number IN (
			SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		)
	</cfif>

	<cfif IN_casId neq "All">
		AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casId#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesListId neq "All">
		AND species_list_id in (<CFQUERYPARAM VALUE="#IN_speciesListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>		
	
	<cfif IN_class neq "All">
		AND class IN (<CFQUERYPARAM VALUE="#IN_class#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>		
	
	<cfif IN_taxOrder neq "All">
		AND tax_order IN (<CFQUERYPARAM VALUE="#IN_taxOrder#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	
	
	<cfif IN_genus neq "All">
		AND genus IN (<CFQUERYPARAM VALUE="#IN_genus#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_family neq "All">
		AND family IN (<CFQUERYPARAM VALUE="#IN_family#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesId neq "All">
		AND species_number IN (<CFQUERYPARAM VALUE="#IN_speciesId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>
	
	<cfif IN_special neq "All">
		<cfset loop = 0>
		AND (
		<cfloop index="thisSpecInt" list="#IN_special#" delimiters=",">
			<cfif loop gt 0> OR </cfif>
			 (#thisSpecInt# = 'Y')
			 <cfset loop = loop + 1>
		</cfloop>
		)
	</cfif>
	
	<cfif IN_effectId neq "All">
		AND effect IN (<CFQUERYPARAM VALUE="#IN_effectId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_measurementId neq "All">
		AND measurement IN (<CFQUERYPARAM VALUE="#IN_measurementId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
                
	<!--- custom effects / measurement groups --->
	<cfif concatCustEffMeasList neq "All">
		AND CONCAT(effect, measurement) IN (<CFQUERYPARAM VALUE="#concatCustEffMeasList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_endpointId neq "All">
		AND endpoint IN (<CFQUERYPARAM VALUE="#IN_endpointId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	

        <!--- DURATION LOGIC HERE --->
	<cfinclude template="duration_logic_sql.cfm">
	
	<cfif IN_habitat neq "All">
		AND habitat IN (<CFQUERYPARAM VALUE="#IN_habitat#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
		AND publication_year between <CFQUERYPARAM VALUE="#IN_pubYearMin#" CFSQLTYPE="CF_SQL_VARCHAR"> AND <CFQUERYPARAM VALUE="#IN_pubYearMax#" CFSQLTYPE="CF_SQL_VARCHAR">
		
			<!--- special interest groups are no longer determined by species group, so include this to make sure not to return any of these items matching species_list_id between 13-15 --->
			AND (v.species_list_id IS NULL OR v.species_list_id NOT IN (13,14,15))
			
		)
		iq
		GROUP BY iq.#id_field#, iq.#desc_field#<cfif "#desc_field#" neq "#common_desc_field#">, iq.#common_desc_field#</cfif>
		<cfif URL.category eq "Species">
			ORDER BY iq.#desc_field#
		<cfelse>
			ORDER BY iq.#id_field#
		</cfif>
	)
	oq
	WHERE rownum <= #Application.ExploreRecordMax#  <!--- prevent overload of jQuery datatable; 5000 worked too. --->

</cfquery>


<cfset jsonString = '{"totalCount":"#CountQuery.ct#","data":['>
<cfset dataArray = "">
<cfoutput>

<cfloop query="ReferenceQuery">

	<cfif URL.category eq "Chemicals">
		<cfset category_id = "#THIS_ID#">
		<cfset column1 = "#THIS_ID#">
		<cfset column2 = "#trim(THIS_DESC)#">

	<cfelseif URL.category eq "Species">
		<cfset category_id = "#THIS_ID#">
		<cfset column1 = "#THIS_DESC#">
		<cfset column2 = "#THIS_COMMON_DESC#">

	<cfelseif URL.category eq "Effects">
		<cfset category_id = "#THIS_COMMON_DESC#">
		<cfset column1 = "#THIS_ID#">
		<cfset column2 = "">

	</cfif>

	<cfset dataArray = listAppend(dataArray,'{"categoryId":"#category_id#","column1":"#column1#","column2":"#column2#","numRecords":"#num_records#","pubCount":"#pub_count#","yearMin":"#year_min#","yearMax":"#year_max#","dtxsid":"#dtxsid#"}')>
</cfloop>

<cfset jsonString = jsonString & dataArray & ']}'>
#jsonString#
</cfoutput>
