<section id="basics-search" data-magellan-target="basics-search">
	<h2>Search Basics</h2>
	<p>The "Search" function provides a direct method to retrieve data that can be refined by limiting the search based on specific parameters including but not limited to Chemicals, Species, Endpoints, Effects, and Test Conditions. Once you have selected your search options, you are able to view the report in the browser or export to Excel spreadsheet or as delimited text.   If the number of retrieved records is greater than 10,000, the export functionality will be disabled.</p>
	<p>The "Explore" function is a great tool for searching the ECOTOX Knowledgebase if you do not know the exact parameters you want to search, or would like a visual representation of general and specific data trends. The "Explore" function provides an interactive way to examine search paths by Chemical, Species, and Effects.</p>
	<p>The Search and Explore pages are designed to search on all data in the Knowledgebase, unless you restrict the search by adding refinements (e.g., adding the check in the check box, enter text in a text entry field). Uncheck the box "All" in order to specify your search on a single (or many) parameters. If the "All" checkbox is checked, and you uncheck a single selection from the options below, that will be the only selection in that group of parameters selected. You may perform the search at any time after you have specified your search criteria. You must enter at least one search parameter, but you do not need to enter something in every search criteria area.</p>
	<p>Once you have completed your search, the search strategy will remain intact, so you may go back and refine your search if you wish. If you want to conduct another search, you may clear the search by clicking the "Reset All" button at the bottom of the search parameter window.</p>
	<p>The search logic includes two basic strategies, combination/union and intersection. Within a search area (e.g., chemical), the search will combine all your search selections. Between each search area, the search will intersect your selections (e.g., intersection between chemical and taxonomic selections).</p>
</section>
<hr>
<section id="basics-search-next" data-magellan-target="basics-search-next">
	<h2>Search</h2>
	<p>The "Search" function page on the ECOTOX Knowledgebase is designed to lead you through a session using multiple parameters.  Each parameter provides a menu and navigational drop-down sub-menus that will allow you to refine your search parameters.  At the left of the Search page are the parameters which can be used to conduct each Search.  You must select at least one parameter to begin your search.</p>
	<p>Options available under the "Search" function are:</p>  
	<ul>
		<li><b>All Chemicals</b> - Chemical Entry, Predefined Chemical Groups</li>
		<li><b>All Effects</b> - Effect Measurements (Avoidance, Behavior, Growth, Mortality, etc.)</li>
		<li><b>All Endpoints</b> - Concentration Based Endpoints (LC/LDxx, EC/Edxx, etc), Time based Endpoints, Bioconcentration Factor, Statistics</li>
		<li><b>All Species</b> - Taxonomic Entry, Predefined Taxonomic Groups</li>
		<li><b>All Test Conditions</b> - Test Locations, Exposure Media or Type, Control Type, Chemical Analysis</li>
		<li><b>All Publications/Updates</b> - Publication Years, Author, ECOTOX Reference Number, Independently Compiled Data and Recent Modifications/Additions</li>
	</ul>
	<p>There are buttons located throughout the Search page which provide key functions to aid the search process.  Key Functions include:</p>
	<ul>
		<li><b>View All Applied</b> - Exportable date stamped data parameters report</li>
		<li><b>Reset All</b> - Erases previously selected search criteria on all search pages and restores the default report format</li>
		<li><b>Reset</b> - Erases only the parameters in your current menu</li>
		<li><b>Aquatic Button</b> - Displays aquatic data results in window</li>
		<li><b>Terrestrial Button</b> - Displays terrestrial data results in window</li>
		<li><b>Update Search</b> - Runs your search parameters</li>
		<li><b>Customize Output Fields</b> - Allows you to select which fields you would like to display in the search results</li>
		<li><b>Contains and Exact Match Radio Buttons</b> - Allows you to search Chemicals, Effects or Species on partial or exact name matches</li>
	</ul>
	<h3>View/Modify Entries</h3>
	<p>For predefined lists within the Chemical, Species, and Effect Measurements search windows, you can view and/or edit your selected parameters. To view filters, click on the "View All Applied" box located at the bottom of the parameter search box. This will display the details you selected, and you can export information to a date stamped .txt file.</p>
	<p>If you want to refine or edit your selection(s), select the parameters or filters of interest. Multiple selections can be made by holding the Ctrl key down while clicking the item. You may restore the default selections by clicking on the "Reset All" button. When your refinements are complete, click on the "Update Search" to apply your new search criteria.  NOTE: If you click on your browser's "Back" button, your edits will not be saved.</p>
</section>
<hr>
<section id="basics-explore" data-magellan-target="basics-explore">
	<h2>Explore</h2>
	<p>The "Explore" function allows users to quickly search by Chemicals, Species, or Effects.</p>
	<p><u>Chemical</u> - Search by either predefined chemical groups or custom groups.</p>	
	<ul>
		<li>Predefined chemical groups: There are numerous predefined chemical groups on the Explore page. Clicking on the desired chemical group and clicking "Explore Data" provides a Group Summary table of data.  You can then choose to apply additional filters such as Chemical, Species Group, Effect Group, or Effect Measurement, etc.</li>
		<li>You can click on "Records" button above data table to show all records in table.</li>
	</ul>
	<p>Note: The Custom Group search box allows users to enter a chemical of interest by CAS numbers. You cannot enter both a chemical in the Custom Group box, and select a chemical from the Chemical Group list, but you can enter both into the Custom Group box</p>
	<p><u>Species</u> -</p>
	<ul>
		<li>There are numerous predefined Species Groups on the Explore page. Clicking on the desired Species Group and clicking "Explore Data" provides a Group Summary table of data.  You can then choose to apply additional filters such as Chemical, Species, Effect Group, or Effect Measurement, etc.</li>
		<li>You can click on "Records" button above data table to show all records in table.</li>
	</ul>
	<p><u>Effects</u> -</p>
	<ul>
		<li>There are numerous predefined Effect Groups on the Explore page. Clicking on the desired Effect Group and clicking "Explore Data" provides a Group Summary table of data.  You can then choose to apply additional filters such as Chemical, Species Group, or Effect Measurement, etc.</li>
		<li>You can click on "Records" button above data table to show all records in table.</li>
	</ul>
        <p>Under any of the Explore options:</p>
	<ul>
            <li>You may filter the habitat which you are exploring by Aquatic, Terrestrial, or both Aquatic and Terrestrial. The default selection is that both habitat types are selected.  Clicking on one habitat removes it from the query output and updates the records displayed.</li>
            <li><img src="images/hd_basics_7.png" alt="Aquatic and Terrestrial checkboxes are checked"> - Both Aquatic and Terrestrial habitats selected to Explore.</li>
            <li><img src="images/hd_basics_8.png" alt="Aquatic checkbox is checked"> - Only Aquatic habitat selected to Explore.</li>
            <li><img src="images/hd_basics_9.png" alt="Terrestrial checkbox is checked"> - Only Terrestrial habitat selected to Explore.</li>
            <li>You can send your query filters to the Search screen by selecting the green Send Query Filters to Search button.<br/><img src="images/explore-buttons-bridge.png" alt="Send Query Filters to Search button"><br/>This will pre-populate the corresponding parameters from Explore to the Search page. From there, you can select additional parameters or run a query on the pre-populated fields.</li>
	</ul>
        <p>Within the Explore page, you can view your results in a scatter plot view by clicking on the "Plot View" button above data table.<br/>
            <img src="images/explore-buttons-plot.png" alt="Explore Group, Records, and Plot buttons with Plot View selected">
        </p>
        <p>Results will automatically populate onto a scatter plot view. Click on the buttons above the plot to change parameters shown on the graph (Effect by Chemical, Duration by Chemical, or Duration by Endpoint).</p>
	<p>Using the Scatter Plot feature:</p>
	<ul>
		<li>Hovering over individual data points will display specific information on that data point. For example:</li>
		<img src="images/hd_basics_2.jpg" alt="The following information is displayed in a hover-over above a data point: 60207901 Propiconazole, 46 days, 0.23 ug/L">
		<li>If you click on an individual data point on the graph you will be brought to that point on the table below the plot.</li>
		<li>Export the information on the scatter plot by clicking the "Export" button. Export options include exporting the table as CSV or printing the chart.</li>
		<img src="images/hd_basics_3.png" alt="Export menu, showing options to export the table as CSV and to print the chart">
		<li>To zoom in on the scatter plot, you can click and drag your mouse over the particular area you wish to zoom in, or move the slider bar at the bottom of the plot.</li>
		<img src="images/hd_basics_4.jpg" alt="A scatter plot with several data points selected within a zoom window">
		<li>You can further filter which data to display on the scatter plot using the legend. By clicking to select or deselect items in the legend, you will filter displayed data. The lighter colored or greyed-out items in the legend do not get displayed, however the data remains in the Table below the plot.</li>
		<img src="images/hd_basics_5.jpg" alt="This image shows that all chemicals in the scatter plot besides Prochloraz have been deselected">
		<li>To reset the scatter plot to settings after zooming, click the "Reset" button.</li>
		<img src="images/hd_basics_6.jpg" alt="Reset Zoom button">	
	</ul>
	<p>NOTE: Using your browser's Back button will result in the loss of all entries made in any of the ECOTOX forms.</p>
</section>
<hr>
<section id="basics-practice" data-magellan-target="basics-practice">
	<h2>Practice Searches</h2>
	<h3>Example A - Search</h3>
	<p><i>You want to locate all Reproductive effects data for Buprofezin. What types of reproductive effects were measured?</i></p>
	<ol>  
		<li>From the ECOTOX home page, click <b>"Search"</b> on the top banner.</li>
		<li>Select the <b>"All Chemicals"</b> tab from the left frame.</li>
		<li>Type "Buprofezin" into the chemical name search box.</li>
		<li>Select the <b>"All Effects"</b> tab from the left frame.</li>
		<li>Deselect the checkbox next to <b>"Any Effect Group"</b> and select the checkbox next to <b>"Reproduction Group"</b></li>		
		<li>Select the <b>"Aquatic"</b> button for aquatic data or <b>"Terrestrial"</b> button for terrestrial data then click on <img src="images/search-buttons-update.png" alt="Update Search button"> button to view the data.</li>
		<li>The data fields and display format is different for an Aquatic exposure versus a Terrestrial exposure. If you would like to view data for both habitats, you can toggle between them by selecting/deselecting Aquatic or Terrestrial button at top of the table.</li>
	</ol>  
	<h3>Example B - Explore</h3>	
	<p><i>You want to Explore data on the Reproductive effects of Cadmium compounds in fish.</i></p>
	<ol>
		<li>From the ECOTOX home page, click <b>"Explore"</b> on the top banner.</li>
		<li>While on the main Explore page, click the <b>"Chemicals"</b> icon as your starting point.</li>
		<img src="images/hd_basics_10.png" alt="Icon for Chemicals">
		<li>From the list of chemicals that are displayed, select the checkbox in the table located next to Cadmium.</li>
		<img src="images/hd_basics_14.png" alt="A checkbox list of chemical groups that has Cadmium selected">
		<li>Click the green <b>"Explore Data"</b> button at the top right of the table to begin exploring.</li>
		<img src="images/explore-buttons-exp.png" alt="Explore Data button">
		<li>From the list of additional filters, click the drop down <b>"Species Group"</b> selection box and select "Fish". If you wish to further narrow your search, you can refine by specific "Family" or "Genus" or "Species."  Click outside of the Query filter boxes or click "Enter" on your keyboard to apply new parameters.</li>
		<li>Select <b>"Reproduction"</b> from the drop down <b>"Effect Groups"</b> selection box. Again, click outside of the dropdown menu or click "Enter" on your keyboard to apply new parameters.</li>
		<li>On the top left corner of the page, above additional Query Filters, ensure that only the Aquatic checkbox is selected (as Fish was the Species Group of interest).</li>
		<img src="images/hd_basics_8.png" alt="Aquatic checkbox is checked.  Terrestrial checkbox is grayed out as there are no results for it.">
	</ol>
	<p>The data matching your Explore criteria will automatically display in the Group Summary view. You can view records individually by clicking the <b>"Records"</b> button located under the top banner.</p>
</section>
