<section id="navigating-navigating" data-magellan-target="navigating-navigating">
  <h2 class="show-for-sr">Navigating this Web Site</h2>
  <p>When you are within "Search" or "Explore" page and click on a <img src="images/icons/question-circle-gray.svg" alt="gray question mark">, context-sensitive help will display. You may navigate within the help window without affecting your search session.</p>
  <p>From the Home page, you may select one of two ways to search ECOTOX. The "Explore" function allows a simple search for a limited number of chemicals, species, and effects groups to allow users to explore a variety of data results. The "Search" function is menu driven and uses navigation links to direct you through multiple search criteria pages. The "Search" page utilizes all available search and display fields. The "Explore" page allows data records to be plotted.</p>
  <p>To conduct a search, click on either the "Search" or "Explore" option from the Home page. The "Search" or "Explore" page will then load. If you move between the “Search” and “Explore” page functions, you will lose your current selections.</p>
  <h3>Home</h3>
  <p>The Home page provides a general overview of ECOTOX with links to Search, Explore, Help, Contact Us, About ECOTOX, Getting Started, Data Visualizations, Search Tips, ASCII Data Download, Limitations, Frequent Questions, Other Tools/Databases and Recent Additions. These selections will open the requested information. To avoid losing your current Explore and Search selections, right click and open the link in a new window/tab.</p>

  <h3>Search</h3>
    <p>The ECOTOX Knowledgebase Search function provides a direct method to retrieve data that can be refined by limiting the search parameters, e.g. Chemical, Species, Endpoint, Control, Media Type. Once you have selected your search options, you are able to view the report in the browser or export in an Excel or delimited format.</p>

  <h3>Explore</h3>
    <p>The ECOTOX Knowledgebase Explore function is an interactive way to examine search paths by Chemical, Species, and Effects. Once you selected the path to explore, additional data fields will be displayed to filter your data, e.g. Effects, Endpoints, and Publication Year.</p>

    <p>During the exploration there are also options to examine the data visually via plotting functions.</p>

  <h3>Help</h3>
    <p>Help Center: Our Help Center describes the ECOTOX web site contents and navigational resources available. Printable help is available in PDF (Portable Document Format) format for the ECOTOX User Guide 5 and Excel format for the ECOTOX Terms Appendix. To ensure you will be able to see a PDF file in its entirety, please obtain the most recent edition of the free Acrobat Reader from <a href="http://www.adobe.com">Adobe (www.adobe.com)</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a>. The Help center resources are located in one of four web pages, and a brief description of each help file is presented below:</p>

    <p><b>Starting Out:</b> Find information on how to begin navigating and searching the ECOTOX Web site. This page also provides links to the limitations associated with ECOTOX, frequent questions, recent additions, and PDF versions of the ECOTOX User Guide (this document), and the ECOTOX Terms Appendix, which provides detailed information regarding terms presented in the aquatic and terrestrial reports.</p>

    <ul>
      <li>Web Site Information: This section of the website provides a general overview of ECOTOX, including the history of the system's development and the ECOTOX Disclaimer and Limitations.</li>

      <li>Recent Additions: This link provides information on recent data updates (typically done three to four times per year), and changes to the functionality of the web site.</li>

      <li>Navigating this Web Site: Provides guidance in moving through the web site.</li>

      <li>Frequent Questions: The Frequent Questions page provides quick access to typical questions we receive.</li>

      <!--- <li><i>How do I&hellip;</i> - How to perform your search and retrieve output in ECOTOX.</li>
      <li><i>What is&hellip;</i> - Lists and provides links to descriptions and terms for each field available within ECOTOX searches and output. Includes links to the a <a href="help.cfm?sub=wi-documentation#documentation-database">database overview</a>, AQUIRE and TERRETOX extracting guidelines and full list of ECOTOX terms used by the ECOTOX staff.</li>
      <li><i>More Resources</i> - Other useful aids within ECOTOX and related resources on the World Wide Web. Providing these links does not imply endorsement by the U.S. EPA.</li> --->
    </ul>

  <p><b>How do I... :</b> How to perform your search and retrieve output in ECOTOX.</p>
    <ul>
      <li>Learn Basics: The Learn Basics provides basic steps to Explore/Search ECOTOX</li>

      <li>Select Search Parameters: The Select Search Parameters provides an overview to selecting search parameters on the Explore/Search screens in ECOTOX</li>

      <li>Select Report Format/Sort Order: The Select Report Format/Sort Order provides an overview to report options within Explore/Search in ECOTOX</li>

      <li>Navigate/View Reports: The Navigate/View Reports provides navigation instructions for the Explore/Search in ECOTOX</li>
    </ul>

  <p><b>What is... :</b> Provides links to descriptions and terms for each field available within ECOTOX searches and output.</p>
  <ul>
    <li>Data Field Definitions and Terms: The Data Field Definitions and Terms provides documentations of all terms used in the ECOTOX Knowledgebase.</li>
    <li>ECOTOX Documentation: Gives an overview of the Data Sources, Quality Assurance, Species and Chemical Verification procedures, as well as a link to the Terms Appendix.</li>
  </ul>

  <p><b>More Resources: </b>Other useful aids within ECOTOX and related resources on the World Wide Web. Providing these links does not imply endorsement by the U.S. EPA. </p>
    <ul>
      <li>Glossary: The Glossary provides definitions to commonly used terms in the ECOTOX Knowledgebase.</li>

      <li>EPA Database/System Websites: The EPA Database/System Websites provides links to other EPA databases and websites.</li>

      <li>Related Websites: The Related Websites provides links to other databases, tools and websites.</li>
    </ul>

  <h3>Contact Us</h3>
  <p>Use the Contact Us link if you have a specific question or request. This link appears on the top right hand of the ECOTOX toolbar.</p>
<hr>

<section id="navigating-moving" data-magellan-target="navigating-moving">
  <h2>Moving within Pages and Target Menu</h2>
  <p>You may need to move within an ECOTOX screen by using the scroll bars at the right and bottom within your monitor. The right scroll bar moves up and down, the bottom moves left and right. You may also scroll up/down, and left/right by clicking the wheel on your mouse. When you click the wheel on your mouse, a directional arrow will appear and you can simply move your mouse in the direction you want the page to move. Click the mouse on your wheel again to disable the directional navigation arrows.</p>
  <h3>Selection Box and Types</h3>  
  <p>All search and report selections will be displayed in a box using multiple selection methods (radio button, checkbox, dropdown lists, typing in text (one entry per line)). Each search selection box is labeled and a question mark to click on to locate more information. When you click on "Reset All", all search selections will reset to default. Search selection types include:</p>
  <ul>
	<li><b>Checkbox: </b>To select an item, click on the check box you want to include. To unselect, click on the checkbox again. You can select one or more items.</li>
	<li><b>Radio button:</b> To select an option, click on the radio button box you want to include. To unselect, click on the radio button again. Only one option listed can be chosen.</li>
	<li><b>Dropdown List:</b> To modify searches using the dropdown list, click on the plus icon on the right side. Clicking on this icon drops down a list and shows which values can be chosen. Click on the entry item you want selected.</li>
	<li><b>Text Entry:</b> Chemical, Species and Publication Options searches also allow typing the search criteria. You must enter one entry per line and end the final line with a Return (enter key). All numeric entries will be searched exactly as entered. You can mix numeric and text data.</li>
  </ul>
</section>
