<cfset termAppendixObj = CreateObject("component", "cfc.term-appendix_functions")>
<cfset appendixListPairs = termAppendixObj.getAllAppendixIDsNames()>

<section class="data-table" id="term-appendix" data-magellan-target="term-appendix">
    <div class="clearfix">
        <div class="float-left">
            <h2>ECOTOX Terms Appendix</h2>
        </div>
        <div class="float-right">
            <button id="btnExportAll" class="button success export">Export All&nbsp;&nbsp;<span data-tooltip class="has-tip image float-right" data-position-class="bottom" data-disable-hover="false" title="Export all Terms Appendices to an Excel spreadsheet."><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg></span></button>
        </div>
    </div>
    <p class="small">This new format for the Terms Appendix is currently under development and will continually be updated with new terms and definitions. If you need more information or a pdf copy of the Terms Appendix, please Contact Us using the link above</p>
<!---    <p>Hello, I am a TERM APPENDIX.</p>        --->
    <p>
        <label for="selAppendix">Select Appendix:</label>
        <select name="selAppendix" id="selAppendix">
        <cfloop index="appendixItem" list="#appendixListPairs#" delimiters=";">
            <cfset apxId = listGetAt(appendixItem,1,'|')>
            <cfset apxTitle = listGetAt(appendixItem,2,'|')>
            <cfoutput>
            <option value="#apxId#">#apxId#. #apxTitle#</option>
            </cfoutput>
        </cfloop>
        </select>
    </p>
    <div id="resultsLoading" class="loading-overlay"></div>
    <div class="clearfix">
        <div class="float-left">
            <h3 id="appendixTitle" class="float-left">&nbsp;</h3>
        </div>
        <div class="button-group datatable-options float-right">
        </div>
    </div>
    <p id="notesDiv" class="help-text" style="padding-bottom: 10px; display: none;"></p>
    <div id="subAppendixMenu" class="inlineMenu clearfix" style="display: none;">        
        <ul></ul>
    </div>
    <div id="appendixSubNav">
        <div id="subGroupMenu" class="inlineMenu clearfix" style="display: none;">
            <div class="float-left">
                <h4 id="subAppendixTitle" class="float-left">&nbsp;</h4>
            </div>
            <div class="float-right">
                <ul></ul>
            </div>
        </div>
        <div class="clearfix">
            <div class="float-right" style="width: 50%"><input id="txtAppendixSearch" name="txtAppendixSearch" type="text" class="small" placeholder="type to find..."/></div>
        </div>
    </div>
    <div id="appendixDataTableDiv">
        <table id="appendixDataTable" class="hover" width="100%"></table>
    </div>
    <div id="appendixDataTableError" style="padding-top: 15px;"></div>
</section>