
<cfset ParamFunc = CreateObject("component", "cfc.searchparam_functions")>
<cfset animalsArray = ParamFunc.speciesAnimalsArray>
<cfset plantsArray = ParamFunc.speciesPlantsArray>
<cfset specialsArray = ParamFunc.speciesSpecialsArray>

<div id="speciesParamsSidebar" class="secondary-sidebar off-canvas-absolute position-left" data-off-canvas data-transition="overlap" data-search-param="Species">

  <h2 class="header"><button data-toggle="speciesParamsSidebar">
    <svg class="icon arrow" width="12" height="12"><use xlink:href="#chevron-left"></use></svg>
    Species</button></h2>

  <button class="button warning reset-all">Reset</button>

  <p class="form-error no-params">You must input or check at least one option.</p>

  <form id="speciestextentry" action="" class="search" data-searchparam>
  
	<div class="select-all">Specific Species</div>
  
    <p class="help-text">Enter each species name on separate lines. <u>NOTE:</u> This filter will attempt to use ALL Ecotox values that match the search term.</p>
	
    <div class="input-group prepend append mt0 mb0" tabindex="0">
      <textarea id="speciesSearchInput" rows="1" class="input-group-field auto-height"
                name="txAdvancedSpecEntries"
                placeholder="Species name(s)"></textarea>
      <label class="input-group-label" for="speciesSearchInput">
        <span class="show-for-sr">Search:</span>
        <svg class="icon" width="24" height="24"><use xlink:href="#search"></use></svg></label>
      <a href="help.cfm?sub=hd-parameters#parameters-taxonomic" target="_blank" class="input-group-button button help" title="Enter one or more species using either the scientific name or common name. Note that this search includes historical synonyms for species and results presented will use the currently acceptable genus and species name."><svg class="icon" width="16" height="16" alt="Help"><use xlink:href="#question-circle"></use></svg></a>
    </div>
	
	<div class="pl2">
	  <div class="columns medium-4">
		<input type="radio" name="RBSPECSEARCHTYPE" value="CONTAINS" id="RBSPECSEARCHTYPE_C" checked="checked">
		<label for="RBSPECSEARCHTYPE_C">Contains</label>
	  </div>
	  <div class="columns medium-8">
		<input type="radio" name="RBSPECSEARCHTYPE" value="EXACT" id="RBSPECSEARCHTYPE_E">
		<label for="RBSPECSEARCHTYPE_E">Exact Match</label>
	  </div>
	</div>

    <div class="row card mt0">
      <div class="columns medium-4">
        <fieldset class="fieldset small mt0">
          <legend>Kingdom</legend>
          <ul class="no-bullet">
            <li>
              <input type="radio" name="rbSpecSearchKing" value="ANIMALS" id="kindgomAnimals">
              <label for="kindgomAnimals">Animals</label>
            </li>
            <li>
              <input type="radio" name="rbSpecSearchKing" value="PLANTS" id="kindgomPlants">
              <label for="kindgomPlants">Plants</label>
            </li>
            <li>
              <input type="radio" name="rbSpecSearchKing" value="BOTH" id="kindgomBtoh" checked>
              <label for="kindgomBtoh">Both</label>
            </li>
          </ul>
        </fieldset>
      </div>
      <div class="columns medium-8">
        <fieldset class="fieldset small mt0">
          <legend>For Name Searches</legend>
          <ul class="no-bullet">
            <li><input type="radio" name="rbSpecSearchGroup" value="SCIENTIFICNAME" id="nameSpecies" checked>
                <label for="nameSpecies">Genus/Species Name</label></li>
            <li><input type="radio" name="rbSpecSearchGroup" value="COMMONNAME" id="nameCommon">
                <label for="nameCommon">Common Name</label></li>
            <li><input type="radio" name="rbSpecSearchGroup" value="TAXONOMICNAME" id="nameOther">
                <label for="nameOther">Other Taxonomic Names</label></li>
          </ul>
		</fieldset>
      </div>
    </div>
  </form>
  
  <form>
    <p class="select-all help-text"><strong>OR:</strong> Select from Species Groups below, with the option to limit results by Special Interest groups.</p>
  </form>

  <form id="speciesgroups" data-searchparam data-mod-entries-speciesgroups>
    <input class="select-all" id="allSpeciesGroups" name="allSpeciesGroups" type="checkbox" checked>
    <label class="select-all" for="allSpeciesGroups">Any Species Group</label>

	<cfset subHeader = #animalsArray[1]#>
    <cfset inputsArray = #animalsArray[2]#>

    <fieldset>
      <legend><cfoutput>#subHeader#</cfoutput></legend>
      <ul class="no-bullet col-small-2">
        <cfloop index="animalGroup" array="#inputsArray#">
          <cfoutput>
            <li>
              <input value ="#listGetAt(animalGroup,1)#"
                     id    ="#listGetAt(animalGroup,3)#"
                     name  ="#listGetAt(animalGroup,3)#" type="checkbox" checked>
              <label for   ="#listGetAt(animalGroup,3)#">
                #listGetAt(animalGroup,2)#</label>
            </li>
          </cfoutput>
        </cfloop>
      </ul>
    </fieldset>

	<cfset subHeader = #plantsArray[1]#>
    <cfset inputsArray = #plantsArray[2]#>

    <fieldset>
      <legend><cfoutput>#subHeader#</cfoutput></legend>
      <ul class="no-bullet col-small-2">
        <cfloop index="plantGroup" array="#inputsArray#">
          <cfoutput>
            <li>
              <input value ="#listGetAt(plantGroup,1,';')#"
                     id    ="#listGetAt(plantGroup,3,';')#"
                     name  ="#listGetAt(plantGroup,3,';')#" type="checkbox" checked>
              <label for   ="#listGetAt(plantGroup,3,';')#">
                #listGetAt(plantGroup,2,';')#</label>
            </li>
          </cfoutput>
        </cfloop>
      </ul>
    </fieldset>
  </form>
  
  <form id="specialspecgroups" data-searchparam data-mod-entries-speciesgroups>
	
	<p class="help-text">Click any of the checkboxes below to limit results by Special Interest group.</p>

	<cfset subHeader = #specialsArray[1]#>
    <cfset inputsArray = #specialsArray[2]#>

    <fieldset>
      <legend><cfoutput>#subHeader#</cfoutput></legend>
      <ul class="no-bullet col-small-1">
        <cfloop index="specialGroup" array="#inputsArray#">
          <cfoutput>
            <li>
              <input value ="#listGetAt(specialGroup,1)#"
                     id    ="#listGetAt(specialGroup,3)#"
                     name  ="#listGetAt(specialGroup,3)#" type="checkbox" class="supporting">
              <label for   ="#listGetAt(specialGroup,3)#">
                #listGetAt(specialGroup,2)#</label>
            </li>
          </cfoutput>
        </cfloop>
      </ul>
      <p class="help-text ml1"><strong>Note:</strong> See 'Help' for more information about <a href="help.cfm?sub=hd-parameters#parameters-special" target="_blank" title="Special Interest Species Lists">Special Interest Species Lists</a></p>
    </fieldset>

    <!--- View/Edit List Entries - populated by subform --->
    <input aria-hidden="true" class="hide" type="hidden" id="specSelections" name="specSelections" value="">

    <a data-open="speciesGroupEntriesModal" data-open-exclusions class="button centered modify">View/Modify Entries for Selected Group(s)</a>
  </form>
</div>


<div class="reveal modify-entries" id="speciesGroupEntriesModal" data-reveal data-close-on-click="false">
  <h2>View/Modify Entries for Selected Group(s)</h2>
  <button class="close-button" data-close aria-label="Close modal" type="button">
    <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
  </button>
  <p>The table below contains the expanded species associated with the species groups you selected. To remove individual species from your query, uncheck the box in the appropriate row.</p>
  <p>When you have completed your selections, click on the <strong>Save Modifications</strong> button.</p>

  <form id="speciesModal" class="content"></form>

  <div class="reveal-footer">
    <button class="button secondary float-left" data-reset-exclusions="speciesGroupEntriesModal">Restore All</button>
    <button class="button secondary float-left" data-clear-exclusions="speciesGroupEntriesModal">Clear All</button>
    <button class="button cancel" data-close>Cancel</button>
    <button class="button success" data-close data-save-exclusions="speciesGroupEntriesModal">Save Modifications</button>
  </div>
</div>
