
<cfset ParamFunc = CreateObject("component", "cfc.searchparam_functions")>
<cfset testConditionsArray[1] = ParamFunc.testLocationsArray>
<cfset testConditionsArray[2] = ParamFunc.testExpMediaArray>
<cfset testConditionsArray[3] = ParamFunc.testExpTypesArray>
<cfset testConditionsArray[4] = ParamFunc.testControlTypesArray>
<cfset testConditionsArray[5] = ParamFunc.testChemAnalysisArray>

<div id="testParamsSidebar" class="secondary-sidebar off-canvas-absolute position-left" data-off-canvas data-transition="overlap" data-search-param="Test Conditions">
    <h2 class="header"><button data-toggle="testParamsSidebar">
        <svg class="icon arrow" width="12" height="12"><use xlink:href="#chevron-left"></use></svg>
        Test Conditions</button>
    </h2>

    <button class="button warning reset-all">Reset</button>

    <p class="form-error no-params">You must check at least one option.</p>

    <cfloop index="testConditionGroup" array="#testConditionsArray#">

        <cfset header = #testConditionGroup[1]#>
        <cfset spaceFreeHeader = ReReplace(header, "[[:space:]]","","ALL")>
        <cfset namePrefix = #testConditionGroup[2]#>
        <cfset subGroupsArray = #testConditionGroup[3]#>

        <cfoutput>
            <form id="#spaceFreeHeader#Form" action="" data-searchparam>
                <input class="select-all" id="ckAll#spaceFreeHeader#" name="ckAll#spaceFreeHeader#" type="checkbox" checked>
                <label class="select-all" for="ckAll#spaceFreeHeader#">Any #header#</label>

                <cfloop index="testConditionSubGroup" array="#subGroupsArray#">

                    <cfset subHeader = #testConditionSubGroup[1]#>
                    <cfset inputsArray = #testConditionSubGroup[2]#>

                    <cfif header eq "Exposure Media" AND subHeader eq "">
                        <fieldset class="card">
                            <cfloop index="inputItem" array="#inputsArray#">
                                <cfset inputName = #namePrefix# & listGetAt(inputItem,1,';')>
                                <cfset inputText = listGetAt(inputItem,2,';')>

                                <input id="cb#inputName#" name="cb#inputName#" value="#inputName#" type="checkbox" checked>
                                <label for="cb#inputName#"><b>#inputText#</b></label>
                            </cfloop>
                        </fieldset>
                    <cfelse>

                        <fieldset>
                            <legend>#subHeader#</legend>
                            <ul class="no-bullet col-small-2">
                                <cfloop index="inputItem" array="#inputsArray#">

                                    <cfif IsArray(inputItem)>
                                        <cfset inputSubGroupArray = inputItem[2]>
                                        <cfset inputItem = inputItem[1]>

                                        <cfset inputName = #namePrefix# & listGetAt(inputItem,1,';')>
                                        <cfset inputText = listGetAt(inputItem,2,';')>

                                        <li>
                                            <input id="cb#inputName#" name="cb#inputName#" value="#inputName#" type="checkbox" checked class="sub-select-all">
                                            <label for="cb#inputName#">#inputText#</label>

                                            <ul class="no-bullet ml3">
                                                <cfloop index="inputSubGroupItem" array="#inputSubGroupArray#">

                                                    <cfset inputSubName = #namePrefix# & listGetAt(inputSubGroupItem,1,';')>
                                                    <cfset inputSubText = listGetAt(inputSubGroupItem,2,';')>

                                                    <li>
                                                        <input id="#inputSubName#" name="#inputSubName#" value="#inputSubName#" type="checkbox" checked>
                                                        <label for="#inputSubName#">#inputSubText#</label>
                                                    </li>
                                                </cfloop>
                                            </ul>
                                        </li>

                                    <cfelse>

                                        <cfset inputName = #namePrefix# & listGetAt(inputItem,1,';')>
                                        <cfset inputText = listGetAt(inputItem,2,';')>

                                        <li>
                                            <input id="cb#inputName#" name="cb#inputName#" value="#inputName#" type="checkbox" checked>
                                            <label for="cb#inputName#">#inputText#</label>
                                        </li>

                                    </cfif>
                                </cfloop>
                            </ul>
                        </fieldset>
                    </cfif>
                </cfloop>
            </form>
        </cfoutput>
    </cfloop>

    <form action="" data-searchparam>
        <fieldset>
            <div class="select-all">Specify Duration (Observed):</div>
            <label class="mt0">
                <p class="help-text">Insert specific duration (days):</p>
                <div id="exposureDurationStd" class="input-group prepend append">
                    <input id="txExposureDurationStd" name="txExposureDurationStd" class="input-group-field" type="number" placeholder="days, eg. 2, 4, 7, etc.">
                    <label class="input-group-label" for="txExposureDurationStd">Days:</label>
                    <a href="help.cfm?sub=hd-parameters#parameters-conditions" target="_blank" class="input-group-button button help" title="Test Conditions text search help"><svg class="icon" width="16" height="16" alt="Help"><use xlink:href="#question-circle"></use></svg></a>
                </div>
            </label>
            <p class="select-all help-text"><strong>OR:</strong></p>
            <label class="mt0">
                <p class="help-text">Enter range for duration (days):</p>
                <span id="exposureDurationRange" class="input-group">
                    <span class="select-all help-text center"><strong>&gt;=</strong>&nbsp;&nbsp;</span>
                    <input id="txExposureDurationMin" name="txExposureDurationMin" class="input-group-field" type="number">&nbsp;&nbsp;&nbsp;&nbsp;
                    <span class="select-all help-text center"><strong>&lt;=</strong>&nbsp;&nbsp;</span>
                    <input id="txExposureDurationMax" name="txExposureDurationMax" class="input-group-field" type="number">
                </span>
            </label>
        <fieldset>
    </form>

</div>