
<cfset GenFunc = CreateObject("component", "cfc.generic_functions")>
    
<cfset paramGroups = arrayNew(1)>
<cfset ArrayAppend(paramGroups, ParamFunc.cardnames["habitat"])>
<cfset ArrayAppend(paramGroups, ParamFunc.cardnames["chemicals"])>
<cfset ArrayAppend(paramGroups, ParamFunc.cardnames["effect"])>
<cfset ArrayAppend(paramGroups, ParamFunc.cardnames["endpoint"])>
<cfset ArrayAppend(paramGroups, ParamFunc.cardnames["species"])>
<cfset ArrayAppend(paramGroups, ParamFunc.cardnames["test"])>
<cfset ArrayAppend(paramGroups, ParamFunc.cardnames["pubs"])>
       
 
<cfset paramGroupArray = arrayNew(1)>
<cfloop from="1" to="#ArrayLen(paramGroups)#" index="j">
    <cfset currentCardName = paramGroups[j]>
        
    <cfif currentCardName EQ ParamFunc.cardnames["chemicals"]>
        <cfset currentModList = selectedChems>
    <cfelseif currentCardName EQ ParamFunc.cardnames["effect"]>
        <cfset currentModList = selectedEffects>  
    <cfelseif currentCardName EQ ParamFunc.cardnames["species"]>
        <cfset currentModList = selectedSpecs>      
    <cfelse>
        <cfset currentModList = structnew()>          
    </cfif>
    
    <cfset thisParamGroupStruct = structNew()>
    <cfset thisParamGroupStruct.categoryName = currentCardName>
    <cfset thisParamGroupStruct.categoryFields = arrayNew(1)>

    <cfif StructKeyExists(paramsToDisplay, "#currentCardName#")>
        <cfset currentCardGroups = paramsToDisplay["#currentCardName#"]>
        <cfif NOT StructIsEmpty(currentCardGroups)>

            <!--- DO ITEMS WITHOUT A GROUP FIRST, AND TEXT AREAS WITHIN THAT FIRST --->
            <cfif StructKeyExists(currentCardGroups, "NO-GROUP")>
                <cfset thisNoGroupParams = currentCardGroups["NO-GROUP"]>
                <cfif NOT StructIsEmpty(thisNoGroupParams)>
                    <cfset thisGroupsTextAreas = ParamFunc.getCardTextAreas(currentCardName)>
                    <cfif ArrayLen(thisGroupsTextAreas) gt 0>

                        <cfloop from="1" to="#ArrayLen(thisGroupsTextAreas)#" index="i">
                            <cfset thisTextArea = thisGroupsTextAreas[i]>
                            <cfif StructKeyExists(thisNoGroupParams, "#thisTextArea#")>
                                <cfset thisTextAreaVal = thisNoGroupParams["#thisTextArea#"]>
                                <cfif thisTextAreaVal neq "">
                                    <cfset modval = replace(thisTextAreaVal," ","","ALL")>
                                    <cfset modval = REReplace(modval,"#chr(13)#|#chr(9)#|\n|\r",";","ALL")>
                                    <cfset valArray = ListToArray(modval, ";")>
                                    <cfset modval = ArrayToList(valArray, ", ")>
                                        
                                    <cfset thisField = structNew()>
                                    <cfset thisField.name = thisTextArea>
                                    <cfset thisField.value = modval>
                                    <cfset thisField.info = "">
                                    <cfset thisField.group1 = "NO-GROUP">
                                        
                                    <cfif currentCardName eq ParamFunc.cardnames["species"]>
                                        <cfif StructKeyExists(thisNoGroupParams, "Kingdom")>  
                                            <cfset thisTextAreaVal = thisNoGroupParams["Kingdom"]>
                                            <cfif thisTextAreaVal neq "">
                                                <cfset thisField.info = "Kingdom: " & thisTextAreaVal>
                                            </cfif>
                                        </cfif>
                                        <cfif StructKeyExists(thisNoGroupParams, "Name Search Type")>
                                            <cfset thisTextAreaVal = thisNoGroupParams["Name Search Type"]>
                                            <cfif thisTextAreaVal neq "">
                                                <cfset thisField.info = "Name Search Type: " & thisTextAreaVal>
                                            </cfif>
                                        </cfif>
                                    </cfif>
                                        
                                    <cfset ArrayAppend(thisParamGroupStruct.categoryFields, thisField)>
                                </cfif>		
                            </cfif>
                        </cfloop>
                    </cfif>

                    <cfloop item="paramname" collection="#thisNoGroupParams#">
                        <cfif ( GenFunc.findInArray(thisGroupsTextAreas, paramname, false ) eq 0 )>
                            
                            <cfif paramname neq "Kingdom" AND paramname neq "Name Search Type">
                                <cfset thisField = structNew()>
                                <cfset thisField.name = paramname>
                                <cfset thisField.value = thisNoGroupParams["#paramname#"]>
                                <cfset thisField.info = "">
                                <cfset thisField.group1 = "NO-GROUP">
                                    
                                <cfset ArrayAppend(thisParamGroupStruct.categoryFields, thisField)>
                            </cfif>
                        </cfif>
                    </cfloop>
                </cfif>
            </cfif>

            <cfset sortedCardGroups = "">  
            <cfloop item="currentGroupName" collection="#currentCardGroups#">
                <cfset sortedCardGroups = ListAppend(sortedCardGroups, currentGroupName)>
            </cfloop>  
            <cfset sortedCardGroups = ListSort(sortedCardGroups, "textnocase", "asc")>

            <cfloop index="currentGroupName" list="#sortedCardGroups#">
                <cfif currentGroupName neq "NO-GROUP">                           

                    <cfset currentGroupParams = currentCardGroups["#currentGroupName#"]>
                    <cfloop item="paramname" collection="#currentGroupParams#">
                        <!---<cfset paramval = currentGroupParams["#paramname#"]>--->
                      
                        <cfset thisField = structNew()>
                        <cfset thisField.name = paramname>
                        <cfset thisField.value = "">
                        <cfset thisField.info = "">
                        <cfset thisField.group1 = currentGroupName>
                        
                        <cfif StructIsEmpty("#currentModList#")>
                            <cfset thisField.value = "ALL">
                        <cfelse>
                            <cfset modItemArray = currentModList["#paramname#"]>
                            <cfif ArrayLen(modItemArray) lt 1>
                                  
                                <cfset thisField.value = "ALL">

                            <cfelse>

                                <cfset thisField.value = "MODIFIED">
                                    
                                <cfloop from="1" to="#ArrayLen(modItemArray)#" index="k">
                                    <cfset thisval = modItemArray[k]>
                                    <cfset thisField.info = ListAppend(thisField.info, thisval, ",")>
                                </cfloop>

                            </cfif>
                        </cfif>
                            
                        <cfset thisField.info = REPLACE(thisField.info, ",", ", ", "ALL")>

                        <cfset ArrayAppend(thisParamGroupStruct.categoryFields, thisField)>
                            
                    </cfloop>
                      
                </cfif>
            </cfloop>
                
        </cfif>
    </cfif>
    
    <cfset ArrayAppend(paramGroupArray, thisParamGroupStruct)>
    
</cfloop>
