
<cfset termAppendixObj = CreateObject("component", "cfc.term-appendix_functions")>
<cfset OutFunc = CreateObject("component", "cfc.output_functions")>  
    
<cfparam name="URL.mode" default="">
<cfparam name="URL.appid" default="">
<cfparam name="URL.said" default="">
<cfparam name="URL.subgroupid" default="">
    
<cfparam name="URL.export" default="">
        
<!--- paging / sorting vars --->  
<cfparam name="URL.sortfield" default="">       <!--- UI will pass this or default to col 1 on DT.  Exports will use the default value here  --->
<cfparam name="URL.sortdir" default="">
<cfparam name="URL.length" default="10000">   <!--- default is application max.  UI will pass page size, exports will not and will be capped at 10000 rows --->
<cfparam name="URL.start" default="0">       <!--- offset position for query results.  UI will pass this, default to beginning.  Exports will have full range 0-10000 --->
    
<cfparam name="URL.searchstr" default="">
 
<cfif URL.appid EQ "L">
    <cfset SORTFIELD = URL.sortfield>
<cfelse>
    <cfset SORTFIELD = OutFunc.generateOrderByClause( URL.sortfield, URL.sortdir )>
</cfif>
<cfset PAGESIZE = URL.length>
<cfset STARTPOS = URL.start>
<cfset STARTPOSPLUS1 = STARTPOS + 1>
<cfset ENDPOS = PAGESIZE + STARTPOS>
    
<!--- jquery datatable specific --->
<cfparam name ="URL.draw" default="">
<cfset RETURNDRAW = URL.draw>    
    

<cfswitch expression="#URL.mode#">
    <cfcase value="submenu">

        <cfif URL.appid EQ "S">
            <cfinclude template="term-appendix/queries/effect_group_codes.cfm">
            <cfinclude template="term-appendix/effect_groups_to_map.cfm">
        </cfif>

    </cfcase>

<!---    NOT USED FOR NOW (6/1/2020)
    <cfcase value="exportall">
        
        <cfset URL.export = "1">
        <cfinclude template="term-appendix/export_all.cfm">

    </cfcase>
--->
    
    <cfdefaultcase>

        <cfif URL.appid eq "">

            <!--- SET CONDITIONS OF ERROR HERE FOR RETURN MESSAGING --->

            <!---   TODO
            <cfinclude template="browse/error_browse_response.cfm">
            --->

        <cfelse>

            <cfset thisAppendixDef = termAppendixObj.getAppendixDefinition(URL.appid)>
            <cfif NOT StructIsEmpty(thisAppendixDef)>

                <cfset appendixTitle = thisAppendixDef["title"]>
                <cfset dbTemplate = thisAppendixDef["database_template"]>
                <cfset uiTemplate = thisAppendixDef["ui_template"]>
                    
                <cfif structKeyExists(thisAppendixDef, "code_table")>    
                    <cfset codeTable = thisAppendixDef["code_table"]>
                <cfelse>
                    <cfset codeTable = "">
                </cfif>
                    
                <cfif structKeyExists(thisAppendixDef, "where_clause")>    
                    <cfset whereClause = thisAppendixDef["where_clause"]>
                <cfelse>
                    <cfset whereClause = "">
                </cfif>

                <cfif structKeyExists(thisAppendixDef, "notes")>
                    <cfset appendixNotes = thisAppendixDef["notes"]>
                <cfelse>
                    <cfset appendixNotes = "">
                </cfif>

                <cfif structKeyExists(thisAppendixDef, "long_definition")>
                    <cfset useLongDefinition = thisAppendixDef["long_definition"]>
                <cfelse>
                    <cfset useLongDefinition = "1">
                </cfif>

                <cfif structKeyExists(thisAppendixDef, "col1name")>
                    <cfset COL1_NAME = thisAppendixDef["col1name"]>
                <cfelse>
                    <cfset COL1_NAME = "">
                </cfif>

                <cfif structKeyExists(thisAppendixDef, "col2name")>
                    <cfset COL2_NAME = thisAppendixDef["col2name"]>
                <cfelse>
                    <cfset COL2_NAME = "">
                </cfif>

                <cfif structKeyExists(thisAppendixDef, "col3name")>
                    <cfset COL3_NAME = thisAppendixDef["col3name"]>
                <cfelse>
                    <cfset COL3_NAME = "">
                </cfif>

                <cfinclude template="term-appendix/queries/#dbTemplate#">

                <cfif URL.export EQ "1">
                    <cfset OUTPUTFORMAT = "CSV">                             <!--- might change later and there will be more formats --->
                <cfelse>
                    <cfset OUTPUTFORMAT = "JSON">                    
                </cfif>
                    
                <cfinclude template="term-appendix/#uiTemplate#">


            <cfelse>

                <!--- SET CONDITIONS OF ERROR HERE FOR RETURN MESSAGING --->

                <!---   TODO
                <cfinclude template="browse/error_browse_response.cfm">
                --->       

            </cfif> 
        </cfif>

    </cfdefaultcase>
</cfswitch>
    
    

