<cfset cleanInputs = CreateObject("component", "cfc.input_sanitize")>
<cfset GroupFunc = CreateObject("component", "cfc.group_option_functions")>

<cfparam name="url.ecoref" default="0">
<cfparam name="url.hero" default="0">   
<cfparam name="url.toxval" default="0">
<!--- NOT ON THIS PAGE --->
<cfparam name="url.cas" default="0">
<cfparam name="url.dtxsid" default="0">   
<cfparam name="url.ncbi" default="0">
<cfparam name="url.cgid" default="0"> 
<cfparam name="url.csid" default="0">

<cfset validParam = cleanInputs.checkParamNumeric("ecoref", URL.ecoref, "URL")>
<cfset validParam = cleanInputs.checkParamNumeric("hero", URL.hero, "URL")>
<cfset validParam = cleanInputs.checkParamNumeric("toxval", URL.toxval, "URL")>

<div id="exploreLoading" class="loading-overlay-long"></div>
<div id="chartLoading" class="loading-overlay-long"></div>
<div id="explorePubsLanding">
    <section class="main-content datatable-results">
        <div id="explorePubsLandingContent">
            <div id="pubsLandHeader" class="clearfix">
                <div class="col-50-layout">
                    <header class="table-header">
                        <h2>Explore Publications</h2>
                        <p class="help-text mb2"><span class="has-tip add-image" data-tooltip data-allow-html="true" data-position-class="bottom" data-disable-hover="false" title="In the browse options, enter relevant text (listed in the box). Hold the <code>ctrl/cmd</code> key to select multiple options.">Browse or make selections</span> in the below options to begin exploring by Publication.</p>
                        <p class="help-text">The # of Publications meeting all of the entered parameters will display in the top right-hand corner. When finished with selections, click 'Explore Data' to see results.</p>
                    </header>
                </div>
                <div class="col-50-layout">
                    <div id="pubsLandingAction">
                        <div id="pubsActionContainer">
                            <div class="clearfix">
                                <!--- INPUT TO HOLD REF NUMS, OR SELECTIONS? --->
                                <button class="button success next">Explore Data</button>
                                <button class="reset-all button warning">Reset All</button>
                            </div>
                            <p class="pub-count"># Publications (all parameters):&nbsp;&nbsp;<span id="count-pubtotal">999</span></p>
                        </div>
                    </div>
                </div>
            </div>
            <div id="pubsFilters" class="clearfix">
                <div class="col-50-layout">
                    <div class="filter-section card raised card-content">
                        <ul id="pubRefTabs" data-tabs class="tabs-as-buttons button-group">
                            <li class="tabs-title is-active">
                                <a id="browseAuthor" href="#browsePubAuthor" class="button">Browse by Citation</a></li>
                            <li class="tabs-title">
                                <a id="enterEcoref" href="#enterPubEcoref" class="button">Enter by ECOREF Number</a></li>
                        </ul>
                        <div data-tabs-content="pubRefTabs">
                            <div class="tabs-panel is-active" id="browsePubAuthor">
                                <dl>
                                    <dt>Author</dt>
                                    <dd><select name="selAuthorBrowse" id="selAuthorBrowse" data-browse-pubs="pubauthor" multiple="multiple" style="width: 100%"></select></dd>
                                    <dt>Citation</dt>
                                    <dd><select name="selCitationBrowse" id="selCitationBrowse" data-browse-pubs="pubcitation" multiple="multiple" style="width: 100%"></select></dd>
                                </dl>
                            </div>
                            <div class="tabs-panel" id="enterPubEcoref">
                                <dl>
                                    <dt>ECOREF Number</dt>
                                    <dd><textarea rows="10" name="txtPubEcoref" id="txtPubEcoref" data-browse-pubs="pubreflist" placeholder="Enter comma separated list of ECOREF numbers..."></textarea></dd>
                                </dl>
                            </div>
                        </div>
                    </div>
                    <p class="help-text"><b>NOTE:</b> This search includes all chemicals and species currently verified in ECOTOX, however some may not have test results extracted to ECOTOX. In addition, authors and citations included in the browse may not have full data extraction completed at this time.</p>
                    <p class="help-text">* This new Explore module has functionality that is being piloted for potential future inclusion in all the Explore modules (Chemicals, Species, Effects).</p>
                </div>
                <div class="col-50-layout">
                    <div class="filter-section card raised card-content">
                        <ul id="pubChemTabs" data-tabs class="tabs-as-buttons button-group">
                            <li class="tabs-title is-active">
                                <a id="browseChem" href="#browsePubChem" class="button">Browse Chemicals</a></li>
                            <li class="tabs-title">
                                <a id="enterCasnum" href="#enterPubCasnum" class="button">Enter by CAS Number</a></li>
                        </ul>
                        <div data-tabs-content="pubChemTabs">
                            <div class="tabs-panel is-active" id="browsePubChem">
                                <dl>
                                    <dt>Chemicals</dt>
                                    <dd><select name="selChemicalsBrowse" id="selChemicalsBrowse" data-browse-pubs="pubchemicals" multiple="multiple" style="width: 100%"></select></dd>
                                </dl>
                            </div>
                            <div class="tabs-panel" id="enterPubCasnum">
                                <dl>
                                    <dt>CAS Number</dt>
                                    <dd><textarea rows="10" name="txtPubCasnum" id="txtPubCasnum" data-browse-pubs="pubcaslist" placeholder="Enter comma separated list of CAS numbers..."></textarea></dd>
                                </dl>
                            </div>
                        </div>
                    </div>
                    <div class="filter-section card raised card-content">
                        <ul id="pubSpecTabs" data-tabs class="tabs-as-buttons button-group">
                            <li class="tabs-title is-active">
                                <a id="browseSpec" href="#browsePubSpec" class="button">Browse Species</a></li>
                            <li class="tabs-title">
                                <a id="browseSpecGroup" href="#browsePubSpecGrp" class="button">Species by Group</a></li>
                            <li class="tabs-title">
                                <a id="browseClass" href="#browsePubClass" class="button">By Class</a></li>
                        </ul>
                        <div data-tabs-content="pubSpecTabs">
                            <div class="tabs-panel is-active" id="browsePubSpec">
                                <dl>
                                    <dt>Species</dt>
                                    <dd><select name="selSpeciesBrowse" id="selSpeciesBrowse" data-browse-pubs="pubspecies" multiple="multiple" style="width: 100%"></select></dd>
                                </dl>
                            </div>
                            <div class="tabs-panel" id="browsePubSpecGrp">
                                <dl>
                                    <dt>Search by Species Group(s)</dt>
                                    <dd>
                                        <select name="selSpecGrp" id="selSpecGrp" data-browse-pubs="pubspecgroup" multiple size="10">
                                            <cfset specOptionArray = GroupFunc.getAllSpecGroupOptions()>
                                            <cfloop from="1" to="#ArrayLen(specOptionArray)#" index="i">
                                                <cfif i NEQ "1">
                                                    <cfoutput>#specOptionArray[i]#</cfoutput>
                                                </cfif>
                                            </cfloop>
                                        </select>
                                    </dd>
                                </dl>
                            </div>
                            <div class="tabs-panel" id="browsePubClass">
                                <dl>
                                    <dt>Search by Taxonomic Class</dt>
                                    <dd><select name="selTaxClass" id="selTaxClass" data-browse-pubs="pubtaxclass" multiple="multiple" style="width: 100%"></select></dd>
                                </dl>
                            </div>
                        </div>
                    </div>
                    <div class="filter-section card raised card-content">
                        <ul id="pubEffTabs" data-tabs class="tabs-as-buttons button-group">
                            <li class="tabs-title is-active">
                                <a id="browseEff" href="#browsePubEff" class="button">Browse Effects / Measurements</a></li>
                            <li class="tabs-title">
                                <a id="selEGroups" href="#selEffGroups" class="button">Effects by Group</a></li>
                        </ul>
                        <div data-tabs-content="pubEffTabs">
                            <div class="tabs-panel is-active" id="browsePubEff">
                                <dl>
                                    <dt>Effects / Measurements</dt>
                                    <dd><select name="selEffectsBrowse" id="selEffectsBrowse" data-browse-pubs="pubeffects" multiple="multiple" style="width: 100%"></select></dd>
                                </dl>
                            </div>
                            <div class="tabs-panel" id="selEffGroups">
                                <dl>
                                    <dt>Search by Effect Group(s)</dt>
                                    <dd>
                                        <select name="selEffectGroups" id="selEffectGroups" data-browse-pubs="pubeffectgroups" multiple size="10">
                                            <cfset effOptionArray = GroupFunc.getAllEffectGroupOptions()>
                                            <cfloop from="1" to="#ArrayLen(effOptionArray)#" index="i">
                                                <cfif i NEQ "1">
                                                    <cfoutput>#effOptionArray[i]#</cfoutput>
                                                </cfif>
                                            </cfloop>
                                        </select>
                                    </dd>
                                </dl>
                            </div>
                        </div>
                    </div>
                </div>
            </div>               
        </div>        
    </section>
</div>

<div id="explorePubs" class="with-sidebar">
    <aside id="exploreSidebar" class="sidebar">
        <cfinclude template="filters.cfm" />
    </aside>
    <section class="main-content datatable-results">
        <div id="explorePubsRecordsContent">
            <div id="explorePubsContent" class="tabs-panel is-active">
                <ul id="explorePubsDataTabs" data-tabs class="tabs-as-buttons button-group">
                    <li class="tabs-title is-active">
                        <a href="#explorePubsSummary" class="button">Summary</a></li>
                    <li class="tabs-title">
                        <a href="#explorePubsRecords" class="button">Records</a></li>
                    <li class="tabs-title">
                        <a href="#explorePubsCharts" class="button">Plot View</a></li>
                </ul>

                <button id="btnBridgePubs" class="button success export" data-toggle="bridgeConfirmationPubsModal">Send Query Filters to Search&nbsp;&nbsp;<span data-tooltip class="has-tip image float-right" data-position-class="bottom" data-disable-hover="false" title="Begin a Search using the selected values from the Query Filters in the left sidebar. Selected values will pre-populate the corresponding parameters on the Search page."><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg></span></button>

                <div id="explorePubsData" data-tabs-content="explorePubsDataTabs">
                    <div id="explorePubsSummary" class="tabs-panel is-active">
                        <div class="clearfix">
                            <h2 class="float-left">
                                <span class="title" id="ref_count"></span>
                            </h2>
                            <div class="button-group datatable-options float-right"></div>
                        </div>
                        <p class="small">References summarized by <span data-tooltip data-position-class="bottom" class="has-tip add-image small" title="A unique experimental design that may be characterized by a different chemical, species, location, or exposure type. A computer-generated number is used to designate each test.">Tests</span> and <span data-tooltip data-position-class="bottom" class="has-tip add-image small" title="A reported result of a discrete measurement or endpoint from either a unique experimental design or within one design scenario for statistically defined effects or endpoints. A computer-generated number is used to designate each result (record) within a Test.">Records</span>, ordered by <b class="orderedBy">Reference Number</b>.</p>
                        <table class="hover" width="100%">
                        </table>
                    </div>
                    <div id="explorePubsRecords" class="tabs-panel">
                        <div class="clearfix">
                            <h2 class="float-left">
                                <span class="title" id="ref_record_count"></span>
                            </h2>
                            <div class="button-group datatable-options float-right"></div>
                        </div>
                        <p class="small">Records summarized by <b class="selectedBy">Effect, Endpoint, Duration, &amp; Concentration</b> and ordered by <b class="orderedBy"><span id="orderby_span"></span></b>.</p>
                        <table class="hover" width="100%">
                        </table>
                    </div>
                    <div id="explorePubsCharts" class="tabs-panel">
                        <div id="exploreChartsHeader"></div>
                        <div class="card raised card-content">
                            <nav class="button-group">
                                <button class="button secondary" id="plotEffectByCAS">Effect <small>&times;</small> Chem</button>
                                <button class="button secondary" id="plotDurByCAS">Dur <small>&times;</small> Chem</button>
                                <button class="button secondary" id="plotDurByEndpoint">Dur <small>&times;</small> Endpt</button>
                                <button class="button primary" id="plotCustom">Custom</button>
                            </nav>                                    
                            <div id="customAxesDiv" class="clearfix" style="display: none;">
                                <p class="small float-left">
                                    <span class="small" data-selected-axis="selCustomPlotY"></span> x <span class="small" data-selected-axis="selCustomPlotX"></span>, categorized by <span class="small" data-selected-axis="selCustomPlotSig"></span>
                                </p>                                
                                <div class="float-right">
                                    <a data-open="customPlotModal" class="centered button success">Change Plot Parameters...</a>
                                </div>
                            </div>
                            <div id="chartYScale" class="inlineMenu clearfix">
                                <span>Y-axis scale: </span>
                                <ul>
                                    <li>
                                        <input type="radio" name="rbChartScale" value="LINEAR" id="rbChartScaleLin">
                                        <label for="rbChartScaleLin">Linear</label>
                                    </li>
                                    <li>
                                        <input type="radio" name="rbChartScale" value="LOG" id="rbChartScaleLog" checked>
                                        <label for="rbChartScaleLog">Logarithmic</label>
                                    </li>            
                                </ul>
                            </div>
                            <div id="exploreChart"></div>
                            <div id="exploreChartCaption"></div>
                            <div id="sliderContainer">
                                <p class="small">
                                    <span class="y-axis-category">Concentration</span> Range:&nbsp;&nbsp;<span id="y-axis_range_min"></span>&nbsp;&nbsp;<strong>to</strong>&nbsp;&nbsp;<span id="y-axis_range_max"></span>&nbsp;&nbsp;in&nbsp;<span data-tooltip data-position-class="bottom" class="y-axis-unit has-tip add-image small" title="Unit ratio equivalent to ppm">Standardized Concentration Units</span>
                                </p>
                                <div id="y-axis-slider"></div>
                                <p style="padding: 10px 0px 0px 0px;" class="small caption">Click and drag slider endpoints to zoom in by <span class="y-axis-category">Concentration</span> value.  Click 'Reset' to restore original values.</p>
                                
                                <p id="chartYAxisLine" class="small">
                                    <input type="checkbox" name="chkDisplayYAxisLine" value="TRUE" id="chkDisplayYAxisLine" />
                                    <label for="chkDisplayYAxisLine">Display <span class="y-axis-category">Concentration</span> Line at</label>
                                    <input type="number" name="txtYAxisLineValue" id="txtYAxisLineValue" step="0.01">&nbsp;&nbsp;&nbsp;
                                    <span data-tooltip data-position-class="bottom" class="y-axis-unit has-tip add-image small" title="Unit ratio equivalent to ppm">Standardized Concentration Units</span>
                                </p>                                
                            </div>
                            <div id="exploreChartTable"></div>
                        </div>
                    </div>
                </div>                
            </div>
        </div>
    </section>
</div>


<div class="reveal" id="bridgeConfirmationPubsModal" data-reveal>
    <button class="close-button" data-close aria-label="Close modal" type="button">
        <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
    </button>    
    <div class="callout primary">
        <h5 class="title">Send Query Filters to Search</h5>
        <p>Clicking 'Send to Search' will begin a Search using the selected values from the Query Filters in the left sidebar. Selected values will pre-populate the corresponding parameters on the Search page.</p>
        <p>Search will open in a new tab. Selections from Query Filters will pre-populate in the Aquatic search tab unless only Terrestrial is selected as habitat in Explore.</p>
    </div>
    <div class="reveal-footer">
        <button class="button cancel" data-close>Cancel</button>
        <button id="btnConfirmBridgePubs" class="button success next" data-close>Send to Search</button>
    </div>
</div>

<!--- <cfinclude template="modal_filter_refs.cfm"> --->
<cfinclude template="modal_custom_plot.cfm">