<cfset cleanInputs = CreateObject("component", "cfc.input_sanitize")>

<cfparam name="url.cas" default="0">
<cfparam name="url.dtxsid" default="0">   
<cfparam name="url.ncbi" default="0">
<cfparam name="url.cgid" default="0"> 
<cfparam name="url.csid" default="0">
<!--- NOT ON THIS PAGE --->
<cfparam name="url.ecoref" default="0">
<cfparam name="url.hero" default="0">   
<cfparam name="url.toxval" default="0">   

<cfset validParam = cleanInputs.checkParamNumeric("cas", URL.cas, "URL")>
<cfset validParam = cleanInputs.checkParamAlphaNumeric("dtxsid", URL.dtxsid, "URL")>
<cfset validParam = cleanInputs.checkParamNumeric("ncbi", URL.ncbi, "URL")>
<cfset validParam = cleanInputs.checkParamNumeric("cgid", URL.cgid, "URL")>
<cfset validParam = cleanInputs.checkParamNumeric("csid", URL.csid, "URL")>

<div id="explorePage" class="with-sidebar">

    <aside id="exploreSidebar" class="sidebar">
        <cfinclude template="filters.cfm" />
    </aside>

    <section class="main-content datatable-results">
        
        <div id="exploreLoading" class="loading-overlay"></div>
        <div id="chartLoading" class="loading-overlay-long"></div>

        <div id="exploreGroupsContent"></div>

        <div id="exploreRecordsContent">
            <div id="exploreContent" class="tabs-panel is-active">
                <ul id="exploreDataTabs" data-tabs class="tabs-as-buttons button-group">
                    <li class="tabs-title is-active">
                        <a href="#exploreSummary" class="button">Group Summary</a></li>
                    <li class="tabs-title">
                        <a href="#exploreRecords" class="button">Records</a></li>
                    <li class="tabs-title">
                        <a href="#exploreCharts" class="button">Plot View</a></li>
                </ul>
                
                <button id="btnBridge" class="button success export" data-toggle="bridgeConfirmationModal">Send Query Filters to Search&nbsp;&nbsp;<span data-tooltip class="has-tip image float-right" data-position-class="bottom" data-disable-hover="false" title="Begin a Search using the selected values from the Query Filters in the left sidebar. Selected values will pre-populate the corresponding parameters on the Search page."><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg></span></button>

                <div id="exploreData" data-tabs-content="exploreDataTabs">
                    <div id="exploreSummary" class="tabs-panel is-active"></div>
                    <div id="exploreRecords" class="tabs-panel"></div>
                    <div id="exploreCharts" class="tabs-panel">
                        <div id="exploreChartsHeader"></div>
                        <div class="card raised card-content">
                            <nav class="button-group">
                                <button class="button secondary" id="plotEffectByCAS">Effect <small>&times;</small> Chem</button>
                                <button class="button secondary" id="plotDurByCAS">Dur <small>&times;</small> Chem</button>
                                <button class="button secondary" id="plotDurByEndpoint">Dur <small>&times;</small> Endpt</button>
                                <button class="button primary" id="plotCustom">Custom</button>
                            </nav>
                            <div id="customAxesDiv" class="clearfix" style="display: none;">
                                <p class="small float-left">
                                    <span class="small" data-selected-axis="selCustomPlotY"></span> x <span class="small" data-selected-axis="selCustomPlotX"></span>, categorized by <span class="small" data-selected-axis="selCustomPlotSig"></span>
                                </p>                                
                                <div class="float-right">
                                    <a data-open="customPlotModal" class="centered button success">Change Plot Parameters...</a>
                                </div>
                            </div>
                            <div id="chartYScale" class="inlineMenu clearfix">
                                <span>Y-axis scale: </span>
                                <ul>
                                    <li>
                                        <input type="radio" name="rbChartScale" value="LINEAR" id="rbChartScaleLin">
                                        <label for="rbChartScaleLin">Linear</label>
                                    </li>
                                    <li>
                                        <input type="radio" name="rbChartScale" value="LOG" id="rbChartScaleLog" checked>
                                        <label for="rbChartScaleLog">Logarithmic</label>
                                    </li>            
                                </ul>
                            </div>
                            <div id="exploreChart"></div>
                            <div id="exploreChartCaption"></div>
                            <div id="sliderContainer">
                                <p class="small">
                                    <span class="y-axis-category">Concentration</span> Range:&nbsp;&nbsp;<span id="y-axis_range_min"></span>&nbsp;&nbsp;<strong>to</strong>&nbsp;&nbsp;<span id="y-axis_range_max"></span>&nbsp;&nbsp;in&nbsp;<span data-tooltip data-position-class="bottom" class="y-axis-unit has-tip add-image small" title="Unit ratio equivalent to ppm">Standardized Concentration Units</span>
                                </p>
                                <div id="y-axis-slider"></div>
                                <p style="padding: 10px 0px 0px 0px;" class="small caption">Click and drag slider endpoints to zoom in by <span class="y-axis-category">Concentration</span> value.  Click 'Reset' to restore original values.</p>
                                
                                <p id="chartYAxisLine" class="small">
                                    <input type="checkbox" name="chkDisplayYAxisLine" value="TRUE" id="chkDisplayYAxisLine" />
                                    <label for="chkDisplayYAxisLine">Display <span class="y-axis-category">Concentration</span> Line at</label>
                                    <input type="number" name="txtYAxisLineValue" id="txtYAxisLineValue" step="0.01">&nbsp;&nbsp;&nbsp;
                                    <span data-tooltip data-position-class="bottom" class="y-axis-unit has-tip add-image small" title="Unit ratio equivalent to ppm">Standardized Concentration Units</span>
                                </p>
                                
                            </div>
                            <div id="exploreChartTable"></div>
                        </div>
                    </div>
                </div>                
            </div>
        </div>
    </section>
</div>
    
<div class="reveal" id="bridgeConfirmationModal" data-reveal>
    <button class="close-button" data-close aria-label="Close modal" type="button">
        <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
    </button>    
    <div class="callout primary">
        <h5 class="title">Send Query Filters to Search</h5>
        <p>Clicking 'Send to Search' will begin a Search using the selected values from the Query Filters in the left sidebar. Selected values will pre-populate the corresponding parameters on the Search page.</p>
        <p>Search will open in a new tab. Selections from Query Filters will pre-populate in the Aquatic search tab unless only Terrestrial is selected as habitat in Explore.</p>
    </div>
    <div class="reveal-footer">
        <button class="button cancel" data-close>Cancel</button>
        <button id="btnConfirmBridge" class="button success next" data-close>Send to Search</button>
    </div>
</div>

<cfinclude template="modal_custom_plot.cfm">