<cfset GenFunc = CreateObject("component", "cfc.generic_functions")>
<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<cfinclude template="explore_param_check.cfm" />

<!--- Determine how many records meet the search criteria --->
<cfquery name="CountQuery" datasource="#application.datasource#" cachedWithin="#CreateTimeSpan(0,0,5,0)#" result="CountQueryVars">

SELECT SUM(oq.cnt_distinct) AS ct_all, 
  SUM (CASE 
            WHEN  oq.obs_duration_std <> 'NR'
      AND oq.conc1_mean_std <> 'NR'
      AND (oq.conc_units_std IN ('AI mg/L','AI mg/kg food','AI mg/kg bdwt','AI mg/kg soil','AI ug/g food','AI ug/g org')
              OR oq.conc_units_std IN (SELECT code FROM concentration_conversions WHERE mg_l_mult = 1)) 
              AND oq.conc_units_std NOT LIKE '%/org%' 
            THEN oq.cnt_distinct 
            ELSE NULL 
          END) AS ct_plottable
FROM (
  SELECT MIN(iq.inner_cnt_distinct) as cnt_distinct, iq.obs_duration_std, iq.conc1_mean_std, iq.conc_units_std
  FROM (
    SELECT COUNT(*) as inner_cnt_distinct, cas_number, epa_chem_substance_name, common_name, effect_desc, measurement_desc, endpoint, publication_year, ecoref_number
      , obs_duration_std, conc1_mean_std, conc_units_std
    FROM ecotox_group_summary3_mv
    WHERE 1=1

	<!---
		this refers to the original group of ecorefs from EP, if applicable.  we always want to filter by these if there is a value,
		regardless of whether there is further filtering by other user inputs (ie. author/title below)
	 --->
	<cfif IN_origreflist neq "">
		<cfif ListLen(IN_origreflist) LTE 1000>
			AND ecoref_number IN (<CFQUERYPARAM VALUE="#IN_origreflist#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_origreflist, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>

	<!--- for author / title --->
	<cfif IN_ecoref neq "All">
		<cfif ListLen(IN_ecoref) LTE 1000>
			AND ecoref_number IN (<CFQUERYPARAM VALUE="#IN_ecoref#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_ecoref, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>
	
	<!--- check group selectors --->
	<cfif IN_chemGroupId neq "All">
		<cfif IN_chemGroupId eq "99" AND IN_casList neq "">
			AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
			AND dtxsid IN (<CFQUERYPARAM VALUE="#IN_dtsxIdList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99">
			<!--- do nothing - this is handled with chemicals below --->
		<cfelse>
			AND cas_number IN (
				SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
			)
		</cfif>
	</cfif>
		
	<cfif IN_specGroupId neq "All">
		<cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">
			AND ncbi_taxid IN (<CFQUERYPARAM VALUE="#IN_ncbiList#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		<cfelseif IN_specGroupId eq "99">
			<!--- do nothing - this is handled with species below --->
		<cfelse>
			AND species_list_id in (<CFQUERYPARAM VALUE="#IN_specGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		</cfif>
	</cfif>

	<cfif IN_effGroupId neq "All" AND IN_effGroupId neq "99">
		<cfif ListLen(IN_effGroupId, ",") gt 1>
			AND (
				<cfloop from="1" to="#ListLen(IN_effGroupId)#" index="idx">
					<cfif idx neq 1> OR </cfif>
					(effect LIKE <CFQUERYPARAM VALUE="#ListGetAt(IN_effGroupId, idx)#%" CFSQLTYPE="CF_SQL_VARCHAR">)
				</cfloop>
			)
		<cfelse>
			AND effect LIKE <CFQUERYPARAM VALUE="#IN_effGroupId#%" CFSQLTYPE="CF_SQL_VARCHAR">
		</cfif>
	</cfif>

	<!--- check additional filters --->	
	<cfif IN_chemListId neq "All">
		AND cas_number IN (
			SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		)
	</cfif>

	<cfif IN_casId neq "All">
		AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casId#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesListId neq "All">
		AND species_list_id in (<CFQUERYPARAM VALUE="#IN_speciesListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>		
	
	<cfif IN_class neq "All">
		AND class IN (<CFQUERYPARAM VALUE="#IN_class#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>		
	
	<cfif IN_taxOrder neq "All">
		AND tax_order IN (<CFQUERYPARAM VALUE="#IN_taxOrder#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	
	
	<cfif IN_genus neq "All">
		AND genus IN (<CFQUERYPARAM VALUE="#IN_genus#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_family neq "All">
		AND family IN (<CFQUERYPARAM VALUE="#IN_family#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesId neq "All">
		AND species_number IN (<CFQUERYPARAM VALUE="#IN_speciesId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>
	
	<cfif IN_special neq "All">
		<cfset loop = 0>
		AND (
		<cfloop index="thisSpecInt" list="#IN_special#" delimiters=",">
			<cfif loop gt 0> OR </cfif>
			 (#thisSpecInt# = 'Y')
			 <cfset loop = loop + 1>
		</cfloop>
		)
	</cfif>
	
	<cfif IN_effectId neq "All">
		AND effect IN (<CFQUERYPARAM VALUE="#IN_effectId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_measurementId neq "All">
		AND measurement IN (<CFQUERYPARAM VALUE="#IN_measurementId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
                
	<!--- custom effects / measurement groups --->
	<cfif concatCustEffMeasList neq "All">
		AND CONCAT(effect, measurement) IN (<CFQUERYPARAM VALUE="#concatCustEffMeasList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_endpointId neq "All">
		AND endpoint IN (<CFQUERYPARAM VALUE="#IN_endpointId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	

        <!--- DURATION LOGIC HERE --->
	<cfinclude template="duration_logic_sql.cfm">
	
	<cfif IN_habitat neq "All">
		AND habitat IN (<CFQUERYPARAM VALUE="#IN_habitat#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
		AND publication_year between <CFQUERYPARAM VALUE="#IN_pubYearMin#" CFSQLTYPE="CF_SQL_VARCHAR"> AND <CFQUERYPARAM VALUE="#IN_pubYearMax#" CFSQLTYPE="CF_SQL_VARCHAR">
		
		<!--- special interest groups are no longer determined by species group, so include this to make sure not to return any of these items matching species_list_id between 13-15 --->
                <!--- algae/moss/fungi split into 3 groups so exclude the old combined group as well (11) --->
		AND (species_list_id IS NULL OR species_list_id NOT IN (11,13,14,15))
      
    GROUP BY cas_number, epa_chem_substance_name, common_name, effect_desc, measurement_desc, endpoint, publication_year, ecoref_number, obs_duration_std, conc1_mean_std, conc_units_std
  ) iq
  GROUP BY iq.cas_number, iq.epa_chem_substance_name, iq.common_name, iq.effect_desc, iq.measurement_desc, iq.endpoint, iq.publication_year, iq.ecoref_number, iq.obs_duration_std, iq.conc1_mean_std, iq.conc_units_std
) oq		
		
</cfquery>
<!---
<cflog text ="#CountQueryVars.sql#">
<cflog text ="#ArrayToList(CountQueryVars.sqlparameters)#">
--->

<!--- limiting search results to Application.ExploreRecordMax for performance reasons --->
<cfquery name="DetailQuery" datasource="#application.datasource#" cachedWithin="#CreateTimeSpan(0,0,5,0)#">

SELECT oq.test_id, oq.cas_number, oq.epa_chem_substance_name, oq.latin_name, oq.common_name, oq.effect_desc, oq.measurement_desc, oq.endpoint, oq.ecoref_number, oq.publication_year
  , oq.obs_duration_std, oq.conc1_type_desc, oq.cleanConc, oq.conc_units_std, oq.result_id, oq.inner_citation, (select title from references where reference_number = oq.ecoref_number) as title, oq.dtxsid
FROM (
  SELECT MIN(iq.inner_cnt_distinct) as rec_count, iq.test_id, iq.cas_number, iq.epa_chem_substance_name, iq.latin_name, iq.common_name, iq.effect_desc, iq.measurement_desc, iq.endpoint
    , iq.ecoref_number, iq.publication_year, iq.obs_duration_std, iq.conc1_type_desc, iq.conc as cleanConc, iq.conc_units_std, iq.result_id, iq.inner_citation, iq.dtxsid
  FROM (
    SELECT COUNT(*) as inner_cnt_distinct, test_id, cas_number, epa_chem_substance_name, latin_name, common_name, effect_desc, measurement_desc, endpoint, ecoref_number, publication_year
      , obs_duration_std, conc1_type_desc, CAST(REGEXP_REPLACE(conc1_mean_std, '[^0-9.]', '') as FLOAT) as conc, conc_units_std, result_id, citation as inner_citation, dtxsid
    FROM ecotox_group_summary3_mv v
    WHERE obs_duration_std <> 'NR'
      AND conc1_mean_std <> 'NR'
      AND (conc_units_std IN ('AI mg/L','AI mg/kg food','AI mg/kg bdwt','AI mg/kg soil','AI ug/g food','AI ug/g org')
      OR conc_units_std IN (SELECT code FROM concentration_conversions WHERE mg_l_mult = 1))
      AND conc_units_std NOT LIKE '%/org%'

	<!---
		this refers to the original group of ecorefs from EP, if applicable.  we always want to filter by these if there is a value,
		regardless of whether there is further filtering by other user inputs (ie. author/title below)
	 --->
	<cfif IN_origreflist neq "">
		<cfif ListLen(IN_origreflist) LTE 1000>
			AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_origreflist#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_origreflist, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>

	<!--- for author / title --->
	<cfif IN_ecoref neq "All">
		<cfif ListLen(IN_ecoref) LTE 1000>
			AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_ecoref#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_ecoref, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>
	
	<!--- check group selectors --->
	<cfif IN_chemGroupId neq "All">
		<cfif IN_chemGroupId eq "99" AND IN_casList neq "">
			<cfif len(IN_casList)>                
                <cfif ListLen(IN_casList) LTE 1000>
                    AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                <cfelse>
                    <cfset arrayOfLists = GenFunc.splitListToSublists(IN_casList, 1000)>
                    <cfif ArrayLen(arrayOfLists) GTE 1>
                    AND (
                        <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                            <cfset thisSubList = arrayOfLists[i]>
                            <cfif i GT 1> OR </cfif>                            
                            cas_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                        </cfloop>
                    )
                    </cfif>
                </cfif>
            </cfif>
		<cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
			AND dtxsid IN (<CFQUERYPARAM VALUE="#IN_dtsxIdList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99">
			<!--- do nothing - this is handled with chemicals below --->
		<cfelse>
			AND cas_number IN (
				SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
			)
		</cfif>
	</cfif>
		
	<cfif IN_specGroupId neq "All">
		<cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">
			AND ncbi_taxid IN (<CFQUERYPARAM VALUE="#IN_ncbiList#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		<cfelseif IN_specGroupId eq "99">
			<!--- do nothing - this is handled with species below --->
		<cfelse>
			AND species_list_id in (<CFQUERYPARAM VALUE="#IN_specGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		</cfif>
	</cfif>

	<cfif IN_effGroupId neq "All" AND IN_effGroupId neq "99">
		<cfif ListLen(IN_effGroupId, ",") gt 1>
			AND (
				<cfloop from="1" to="#ListLen(IN_effGroupId)#" index="idx">
					<cfif idx neq 1> OR </cfif>
					(effect LIKE <CFQUERYPARAM VALUE="#ListGetAt(IN_effGroupId, idx)#%" CFSQLTYPE="CF_SQL_VARCHAR">)
				</cfloop>
			)
		<cfelse>
			AND effect LIKE <CFQUERYPARAM VALUE="#IN_effGroupId#%" CFSQLTYPE="CF_SQL_VARCHAR">
		</cfif>
	</cfif>

	<!--- check additional filters --->	
	<cfif IN_chemListId neq "All">
		AND cas_number IN (
			SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		)
	</cfif>

	<cfif IN_casId neq "All">
		AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casId#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesListId neq "All">
		AND species_list_id in (<CFQUERYPARAM VALUE="#IN_speciesListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>		
	
	<cfif IN_class neq "All">
		AND class IN (<CFQUERYPARAM VALUE="#IN_class#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>		
	
	<cfif IN_taxOrder neq "All">
		AND tax_order IN (<CFQUERYPARAM VALUE="#IN_taxOrder#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	
	
	<cfif IN_genus neq "All">
		AND genus IN (<CFQUERYPARAM VALUE="#IN_genus#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_family neq "All">
		AND family IN (<CFQUERYPARAM VALUE="#IN_family#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesId neq "All">
		AND species_number IN (<CFQUERYPARAM VALUE="#IN_speciesId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>
	
	<cfif IN_special neq "All">
		<cfset loop = 0>
		AND (
		<cfloop index="thisSpecInt" list="#IN_special#" delimiters=",">
			<cfif loop gt 0> OR </cfif>
			 (#thisSpecInt# = 'Y')
			 <cfset loop = loop + 1>
		</cfloop>
		)
	</cfif>
	
	<cfif IN_effectId neq "All">
		AND effect IN (<CFQUERYPARAM VALUE="#IN_effectId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_measurementId neq "All">
		AND measurement IN (<CFQUERYPARAM VALUE="#IN_measurementId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
                
	<!--- custom effects / measurement groups --->
	<cfif concatCustEffMeasList neq "All">
		AND CONCAT(effect, measurement) IN (<CFQUERYPARAM VALUE="#concatCustEffMeasList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_endpointId neq "All">
		AND endpoint IN (<CFQUERYPARAM VALUE="#IN_endpointId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	

        <!--- DURATION LOGIC HERE --->
	<cfinclude template="duration_logic_sql.cfm">
	
	<cfif IN_habitat neq "All">
		AND habitat IN (<CFQUERYPARAM VALUE="#IN_habitat#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
		AND publication_year between <CFQUERYPARAM VALUE="#IN_pubYearMin#" CFSQLTYPE="CF_SQL_VARCHAR"> AND <CFQUERYPARAM VALUE="#IN_pubYearMax#" CFSQLTYPE="CF_SQL_VARCHAR">
		
		<!--- special interest groups are no longer determined by species group, so include this to make sure not to return any of these items matching species_list_id between 13-15 --->
		AND (species_list_id IS NULL OR species_list_id NOT IN (13,14,15))
		
	GROUP BY test_id, cas_number, epa_chem_substance_name, latin_name, common_name, effect_desc, measurement_desc, endpoint, ecoref_number, publication_year
    , obs_duration_std, conc1_type_desc, CAST(REGEXP_REPLACE(conc1_mean_std, '[^0-9.]', '') as FLOAT), conc_units_std, result_id, citation, dtxsid
  ) iq
  GROUP BY iq.test_id, iq.cas_number, iq.epa_chem_substance_name, iq.latin_name, iq.common_name, iq.effect_desc, iq.measurement_desc, iq.endpoint, iq.ecoref_number, iq.publication_year
    , iq.obs_duration_std, iq.conc1_type_desc, iq.conc, iq.conc_units_std, iq.result_id, iq.inner_citation, iq.dtxsid
  ORDER BY iq.conc, iq.cas_number, iq.common_name, iq.effect_desc
) oq  
WHERE rownum <= #Application.ExploreRecordMax#  <!--- prevent overload of jQuery datatable; 5000 worked too. --->

</cfquery>

<cfoutput>
<cfset jsonString = '{"totalCount":"#CountQuery.ct_all#","plottableCount":"#CountQuery.ct_plottable#","data":['>
<cfset dataArray = "">
<cfloop query="DetailQuery">
    
    <cfset obs_duration_std_clean = OutFunc.strReplace( obs_duration_std, "Not coded", "" )>
    <cfset obs_duration_std_clean = OutFunc.strReplace( obs_duration_std_clean, "Not Extracted", "" )>
    
    <cfset conc1_type_desc_clean = OutFunc.strReplace( conc1_type_desc, "Not coded", "" )>
    <cfset conc1_type_desc_clean = OutFunc.strReplace( conc1_type_desc_clean, "Not Extracted", "" )>  
           
    <cfset cleanConc_clean = OutFunc.strReplace( cleanConc, "Not coded", "" )>
    <cfset cleanConc_clean = OutFunc.strReplace( cleanConc_clean, "Not Extracted", "" )>  
           
    <cfset conc_units_std_clean = OutFunc.strReplace( conc_units_std, "Not coded", "" )>
    <cfset conc_units_std_clean = OutFunc.strReplace( conc_units_std_clean, "Not Extracted", "" )>           
           
    <cfset dataArray = listAppend(dataArray,'{"resultId":"#result_id#","testId":"#test_id#","casNumber":"#cas_number#","dtxsid":"#dtxsid#","chemName":"#epa_chem_substance_name#","latinName":"#latin_name#","commonName":"#common_name#","effect":"#effect_desc#","effectMeas":"#measurement_desc#","endpoint":"#endpoint#","obsDurStd":"#obs_duration_std_clean#","conc1Type":"#conc1_type_desc_clean#","conc1Mean":"#cleanConc_clean#","concUnits":"#conc_units_std_clean#","year":"#publication_year#","reference":{"citation":"#EncodeForHTML(PreserveSingleQuotes(inner_citation))#","title":"#EncodeForHTML(PreserveSingleQuotes(title))#","refNum":"#replace(ecoref_number," ","&nbsp;","All")#"}}')>
</cfloop>

<cfset jsonString = jsonString & dataArray & ']}'>
#jsonString#
</cfoutput>
