<section id="databases-glted" data-magellan-target="databases-glted">
  <h2>Great Lakes Toxicology Ecology Division Databases</h2>
  <dl>
    <dt id="aster">ASTER</dt>
    <dd>
	NOTE: This site is located under EPA Archives.  <a class="epa-archive-link" href="https://archive.epa.gov/" title="EPA's Archive">Search EPA Archive</a><br/>
	(ASsessment Tools for the Evaluation of Risk) structure-activity based expert system that provides information on toxic effects, physical/chemical properties, and fate and exposure models. ASTER is an integration of the <a href="help.cfm">ECOTOX</a> (ECOTOXicology) toxic effects database and the QSAR (Quantitative Structure Activity Relationships) system, a structure activity based expert system.
    <br> View <a href="help.cfm?sub=faq#faq-aster">ASTER Questions</a></dd>
    <dt id="minnow">Fathead Minnow</dt>
	<dd>
	NOTE: This site is located under EPA Archives.  <a class="epa-archive-link" href="https://archive.epa.gov/" title="EPA's Archive">Search EPA Archive</a><br/>
	Compilation of results from a series of industrial organic compounds using the fathead minnow conducted at the Mid-Continent Ecology Division to support development of an expert system to predict the acute mode of toxic action from chemical structure.</dd>
    <dt>Toxicity/Residue</dt>
	<dd>
	NOTE: This site is located under EPA Archives.  <a class="epa-archive-link" href="https://archive.epa.gov/" title="EPA's Archive">Search EPA Archive</a><br/>
	Data results of toxicity / tissue residue data for aquatic organisms exposed to single chemicals.</dd>
    <dt>PCBRes</dt>
	<dd>
	NOTE: This site is located under EPA Archives.  <a class="epa-archive-link" href="https://archive.epa.gov/" title="EPA's Archive">Search EPA Archive</a><br/>
	U.S. EPA PCB Residue Effects (PCBRes) Database correlating PCB and dioxin-like compound residues with toxic effects on fish, birds and mammal species.</dd>
    <dt>BSAF Data Set</dt>
	<dd>
	NOTE: This site is located under EPA Archives.  <a class="epa-archive-link" href="https://archive.epa.gov/" title="EPA's Archive">Search EPA Archive</a><br/>
	U.S. EPA Biota-Sediment Accumulation Factors (BSAFs) dataset from 20 locations for nonionic organic chemicals.</dd>
</dl>
</section>

<hr>

<section id="databases-stewards" data-magellan-target="databases-stewards">
  <h2>Data Stewards</h2>
  <p>The available data sets, available data, institution address and contacts are listed below:</p>
  <p class="help-text"><strong>NOTE:</strong> The number of records and reference IDs displayed below reflect the contents of each dataset at the time it was imported to Ecotox.  The values listed here may not match current Ecotox search results.</p>

  <table class="bordered only">
    <thead>
      <th>Institution Contact Information</th>
      <th>Data Summary and Reference Numbers</th>
    </thead>
   <tbody>
    <tr>
     <td>
       <h3>EPA: Fathead Minnow Acute Toxicity Database (MED-Duluth)</h3>
       <h4>To obtain hard copies of the University of Wisconsin-Superior (UWS) volumes contact:</h4>
       <p>University of Wisconsin/ Lake Superior Research Institute<br>
        PO Box 2000<br>
        Superior, WI  54880<br>
       Contact: Matt TenEyck<br>
       E-mail: <a href="mailto:MTenEyck@uwsuper.edu">MTenEyck@uwsuper.edu</a><br>
       Phone: 715-394-8160</p>
       <h4>For technical information on the database contact:</h4>
       <p>U.S. EPA/ORD/CCTE/GLTED<br>
       Contact: Jennifer Olker<br>
       E-mail: <a href="mailto:olker.jennifer@epa.gov">olker.jennifer@epa.gov</a></p>
     </td>
     <td>
       <p>5 references (#3217, 12447, 12448, 12858, 12859)</p>
       <p>1133 aquatic records</p>
     </td>
    </tr>

    <tr>
     <td>
       <h3>French (OECD-IRCHA)</h3>
       <p>Ecotoxicology Department, INERIS<br>
       Rue Lavoisier, B.P. 1<br>
       F-91710 Vert Le Petit<br>
       France<br>
       <a href="http://www.ineris.fr/">http://www.ineris.fr/</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a><br>
       Contact: Dr. Roger Cabridenc<br>
       Phone: 33-1-45960956; Fax: 33-1-45960957</p>
     </td>
     <td>
       <p>13 references (#20, 3397, 3516, 3517, 3518, 3519, 3520, 3521, 5161, 6771, 9170, 10724, 15300)</p>
       <p>256 aquatic records</p>
     </td>
    </tr>

    <tr>
     <td>
     <h3>German (OECD)</h3>
     <p>Umweltbundesamt, Federal Environmental Agency
        Dienstgebaude Berlin-Mitte<br/>
        Mauerstrabe 45-52<br/>
        0-1080 Berlin Germany<br/>
        W&ouml;rlitzer Platz 1<br/>
        06844 Dessau-Ro&szlig;lau<br/>
        Germany<br/>
        Tel: +49-340-2103-0<br/>
        Fax: +49-340-2103-2285<br/>
        Email: <a href="mailto:Gerlinde.knetsch@uba.de">Gerlinde.knetsch@uba.de</a><br/>
        <a href="https://www.umweltbundesamt.de/sites/default/files/medien/479/dokumente/flyer_bibliothek_service_etc_oktober_2018-_englisch.pdf">https://www.umweltbundesamt.de</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a>
     </p>
     <p>Dieter Schudoma<br/>
        German Environment Agency<br/>
        Section IV 2.4:   Water-hazardous substances/ Ecotoxicology laboratory<br/>
        Schichauweg 58, <br/>
        12307 Berlin<br/>
        Tel: (+49-30) 8903 4225<br/>
        Fax: (+49-30) 8903 4233<br/>
        Email: <a href="mailto:dieter.schudoma@uba.de">dieter.schudoma@uba.de</a>
     </p>
    </td>
     <td>
       <p>186 references</p>
       <p>10494 aquatic records</p>
       <p>1873 terrestrial records</p>
     </td>
    </tr>
    <tr>
     <td>
     <h3>Dutch (OECD)</h3>
     <p>National Institute of Public Health and Environmental Protection (RIVM/ACT)<br>
     PO Box 1, 3720 BA Bilthoven<br>
     The Netherlands<br>
     <a href="http://www.rivm.nl/en/">http://www.rivm.nl/en/</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a><br>
     Contact: Dr. Hans Canton<br>
     E-mail: <a href="mailto:ecocr@sb615.rivm.nl">ecocr@sb615.rivm.nl</a></p>
     </td>
     <td>
       <p>17 references (#5180, 5331, 5333, 5336, 5337, 5356, 5367, 5370, 5374, 5375, 5378, 5390, 5400, 5411, 5414, 11039, 11044)</p>
       <p>1992 aquatic records</p>
     </td>
    </tr>
    <tr>
     <td>
     <h3>Russia</h3>
     <p>Borok Institute, Institute for Biology of Inland Waters, Academy of Sciences<br>
     152742 Borok, Nekouz, Yaroslavsky Region<br>
     Rusian Republic<br>
     <a href="http://www.ibiw.ru/">http://www.ibiw.ru/</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a><br>
     Contact: Victor Komov<br>
     E-mail: <a href="mailto:vkomov@ibiw.yaroslavl.su">vkomov@ibiw.yaroslavl.su</a></p>
     </td>
     <td>
       <p>55 references</p>
       <p>257 aquatic records</p>
     </td>
    </tr>
    <tr>
     <td>
     <h3>EPA: Office of Pesticide Programs Database (OPP)</h3>
     <p>(Pesticide Ecotoxicity Database -formerly Ecological Effects Database)<br>
     U.S. Environmental Protection Agency<br>
     Office of Pesticide Programs<br>
     Environmental Fate and Effects Division,<br>
     Environmental Information and Support Branch<br>
     1200 Pennsylvania Ave., NW<br>
     Washington, DC 20460<br>
     <a href="https://www.epa.gov/pesticide-contacts/office-pesticide-programs-contacts-division-and-topic">https://www.epa.gov/pesticide-contacts/office-pesticide-programs-contacts-division-and-topic</a><br>
     Contact: Lee Kyle<br>
     E-mail: <a href="mailto:Kyle.Lee@epa.gov"> Kyle.Lee@epa.gov</a></p>
     </td>
     <td>
       <p>Reference #344</p>
       <p>16,956 aquatic records</p>
       <p>17,681 terrestrial records</p>
       <p>&nbsp;</p>
       <p>Reference #184644 - Bee Studies</p>
       <p>4,225 terrestrial records</p>
     </td>
    </tr>

    <tr>
     <td>
     <h3>USGS:&nbsp; Acute Toxicity Database</h3>
     <p><em>Mayer &amp; Ellersieck, 1986 - commonly referred to as the 'Gold Book')</em></p>
     <h4>For data format questions contact:</h4>
     <p>Columbia Environmental Research Center<br>
     U.S. Geological Survey<br>
     4200 New Haven Road, Columbia, Missouri 65201<br>
     Phone: 573-875-5399<br>
     (<a href="http://www.cerc.usgs.gov/data/acute/acute.html">http://www.cerc.usgs.gov/data/acute/acute.html</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a>) <br>
     Contact: Linda Sappington<br>
     E-mail: <a href="mailto:linda_sappington@usgs.gov)">linda_sappington@usgs.gov</a></p>
    <h4>For data interpretation contact:</h4>
    <p>Center for Computational Toxicology and Exposure<br/>
    U.S. Environmental Protection Agency<br/>
    Great Lakes Toxicology and Ecology Division<br/>
    Duluth, Minnesota 55806<br/>
    Phone: 218-529-5011<br/>
    Contact: Dale Hoff<br/>
    E-mail: <a href="mailto:hoff.dale@epa.gov">hoff.dale@epa.gov</a></p>
    </td>
    <td>
       <p>1 reference (#6797)</p>
       <p>8761 aquatic records</p>
    </td>
    </tr>
   </tbody>
  </table>
</section>

<hr>

<section id="databases-other" data-magellan-target="databases-other">
  <h2>Other Databases</h2>
  <dl>
    <dt><a href="http://www3.epa.gov/enviro/">Envirofacts Warehouse</a></dt>
<dd>Retrieve environmental information from EPA databases on <a href="https://www.epa.gov/enviro/topic-searches#air">Air</a>, <a href="https://www.epa.gov/enviro/topic-searches#toxics">Toxics</a>, <a href="https://www.epa.gov/enviro/topic-searches#facility">Facility Information</a>, <a href="https://www.epa.gov/enviro/igms-overview">Grants/Funding</a>, <a href="https://www.epa.gov/enviro/rcrainfo-overview">Hazardous Waste</a>, <a href="https://www.epa.gov/superfund">Superfund</a>, <a href="https://www.epa.gov/enviro/topic-searches#toxics">Toxic Releases</a>, and <a href="https://www.epa.gov/enviro/topic-searches#water">Water</a>.</dd>
    <dt><a href="https://www.epa.gov/chemical-research/ecological-soil-screening-level">EcoSSL</a></dt>
<dd>U.S. EPA Ecological Soil Screening Level guidance for mammals, birds, soil invertebrates and plants.</dd>
    <dt><a href="https://www.epa.gov/iris">IRIS - Integrated Risk Information System</a></dt>
<dd>Human health effects database.</dd>
    <dt><a href="https://www.epa.gov/pesticide-contacts/office-pesticide-programs-contacts-division-and-topic">Pesticide Ecotoxicity Database, Office of Pesticide Programs (OPP)</a></dt>
<dd>U.S. EPA database containing environmental endpoints for over 13,000 toxicity studies for over 630 pesticides. The database is comprised of studies submitted by pesticide manufacturers. The OPP database was last updated in ECOTOX in 2021.</dd>
    <dt><a href="https://www.epa.gov/aboutepa/about-office-water">Office of Water</a></dt>
<dd>Links to Water Quality Criteria and other <a href="http://water.epa.gov/scitech/swguidance/standards/criteria/ambientwqc_index.cfm">publications</a> and <a href="http://water.epa.gov/scitech/swguidance/standards/criteria/current/index.cfm">compilations</a>.</dd>
    <dt><a href="http://www.atsdr.cdc.gov/">ATSDR - Agency for Toxic Substances and Disease Registry</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></dt>
<dd>Human health toxicity database.</dd>
    <dt><a href="https://www.nlm.nih.gov/toxnet/index.html">National Library of Medicine - TOXNET</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></dt>
<dd>Search Toxline, MEDLINE and other medical literature databases.</dd>
    <dt><a href="https://cfpub.epa.gov/si/si_public_record_Report.cfm?Lab=&dirEntryId=2855">Toxic Substance Control Act Test Submission (TSCATS) Database</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></dt>
<dd>Central system for collection, maintenance, and dissemination of information on unpublished technical reports submitted by industry to the U.S. EPA under the Toxic Substances Contract Act (TSCA).</dd>
    <dt><a href="https://cfpub.epa.gov/si/si_public_record_Report.cfm?Lab=NHEERL&dirEntryId=198289&CFID=44090232&CFTOKEN=88024324">Wildlife Toxicology Web Portal</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></dt>
<dd>The portal provides access to over 25 wildlife toxicology sites and databases from government, academia and non-profit organizations that deal with contaminant monitoring, mortality incidents, acute and chronic toxicity data, accumulation factors, toxicological reference values, interspecies correlations, and more general wildlife toxicology literature.</dd>
    <dt><a href="http://www.pwrc.usgs.gov/contaminants-online/">Contaminant Exposure and Effects - Terrestrial Vertebrate Database</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></dt>
<dd>Contaminant exposure and effects for terrestrial vertebrates residing on the Atlantic and Gulf Coasts.</dd>
    <dt><a href="https://irma.nps.gov/DataStore/Reference/Profile/2257033">National Parks Service Environmental Contaminants Encyclopedia</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></dt>
<dd>Summarizes information related to fish, wildlife, invertebrates, and other non-human living resources.</dd>
    <dt><a href="http://www.inchem.org/pages/sids.html">OECD/UNEP Chemical Screened Information Dataset (SIDS)</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></dt>
<dd>for high volume chemicals. Physical/chemical information, human and ecological toxicity summaries.</dd>
    <dt><a href="http://publications.gc.ca/Collection/CW69-5-357E.pdf">Reptile and Amphibian Toxicity Literature (RATL) (PDF)</a> 494 pp, 3560 K, <a target="_blank" href="https://www.epa.gov/home/pdf-files">About PDF</a>) <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></dt>
<dd>Canadian Wildlife Service database capturing amphibian and reptile toxicity data published in the year 2000.</dd>
    <dt><a href="http://www.pesticideinfo.org/">Pesticide Action Network (PAN) Pesticide Database</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></dt>
<dd>Contains pesticide toxicity and regulatory information.</dd>
    <dt><a href="https://www.echemportal.org/echemportal/">eChemPortal</a> <a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></dt>
<dd>eChemPortal provides free public access to information on properties of chemicals.</dd>
  </dl>
</section>
