
<cfset ParamFunc = CreateObject("component", "cfc.searchparam_functions")>
<cfset chemicalGroupsArray[1] = ParamFunc.chemicalMetalArray>
<cfset chemicalGroupsArray[2] = ParamFunc.chemicalOrganicArray>

<div id="chemicalsParamsSidebar" class="secondary-sidebar off-canvas-absolute position-left" data-off-canvas data-transition="overlap" data-search-param="Chemicals">
  <h2 class="header"><button data-toggle="chemicalsParamsSidebar">
    <svg class="icon arrow" width="12" height="12"><use xlink:href="#chevron-left"></use></svg>
    Chemicals</button></h2>

  <button class="button warning reset-all">Reset</button>

  <p class="form-error no-params">You must input or check at least one option.</p>

  <form action="" class="search" data-searchparam>
	
    <div class="input-group prepend append mt0 mb0" tabindex="0">
      <textarea id="txAdvancedChemicalEntries" rows="1" class="input-group-field auto-height"
                name="txAdvancedChemicalEntries"
                placeholder="Name(s) or CAS number(s)"></textarea>
      <label class="input-group-label" for="chemicalSearchInput">
        <span class="show-for-sr">Chemical names or CAS registry numbers</span>
        <svg class="icon" width="24" height="24"><use xlink:href="#search"></use></svg></label>
      <a href="help.cfm?sub=hd-parameters#parameters-chemical" target="_blank" class="input-group-button button help" title="Chemical text search help"><svg class="icon" width="16" height="16" alt="Help"><use xlink:href="#question-circle"></use></svg></a>
    </div>
	
	<div class="row card mt0 pl2">
	  <div class="columns medium-4">
		<input type="radio" name="RBCHEMSEARCHTYPE" value="CONTAINS" id="RBCHEMSEARCHTYPE_C" checked="checked">
		<label for="RBCHEMSEARCHTYPE_C">Contains</label>
	  </div>
	  <div class="columns medium-8">
		<input type="radio" name="RBCHEMSEARCHTYPE" value="EXACT" id="RBCHEMSEARCHTYPE_E">
		<label for="RBCHEMSEARCHTYPE_E">Exact Match</label>
	  </div>
	</div>
	
    <p class="help-text">Enter each chemical name and/or CAS registry number on separate lines. <u>NOTE:</u> This filter will attempt to use ALL Ecotox values that match the search term.</p>
    <p class="pb0 mt1">See <a href="https://comptox.epa.gov/dashboard/" target="_blank">US EPA CompTox Chemicals Dashboard</a>.</p>
  </form>

  <form id="chemicalgroups" data-searchparam data-mod-entries-chemicalgroups>
    <input class="select-all" id="ckAllChemicalGroups" name="ckAllChemicalGroups" type="checkbox" checked>
    <label class="select-all" for="ckAllChemicalGroups">Any Chemical Group</label>

    <cfloop index="chemicalGroupArray" array="#chemicalGroupsArray#">

      <cfset subHeader = #chemicalGroupArray[1]#>
      <cfset inputsArray = #chemicalGroupArray[2]#>

      <cfoutput>
        <fieldset>
          <legend>#subHeader#</legend>
          <ul class="no-bullet col-small-2">
            <cfloop index="inputItem" array="#inputsArray#">

              <cfset inputName = listGetAt(inputItem,3)>
              <cfset inputText = listGetAt(inputItem,2)>
              <cfset inputValue = listGetAt(inputItem,1)>

              <li>
                <input id="#inputName#" name="#inputName#" value="#inputValue#" type="checkbox">
                <label for="#inputName#">#inputText#</label>
              </li>
            </cfloop>
          </ul>
        </fieldset>
      </cfoutput>
    </cfloop>

    <!--- View/Edit List Entries - populated by subform --->
    <input class="hide" aria-hidden="true" type="hidden" id="chemSelections" name="chemSelections" value="">

    <a data-open="chemicalGroupEntriesModal" data-open-exclusions class="button centered modify">View/Modify Entries for Selected Group(s)</a>
  </form>
</div>


<div class="reveal modify-entries" id="chemicalGroupEntriesModal" data-reveal data-close-on-click="false">
  <h2>View/Modify Entries for Selected Group(s)</h2>
  <button class="close-button" data-close aria-label="Close modal" type="button">
    <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
  </button>
  <p>The table below contains the expanded chemicals associated with the chemical groups you selected. To remove individual chemicals from your query, uncheck the box in the appropriate row.</p>
  <p>When you have completed your selections, click on the <strong>Save Modifications</strong> button.</p>

  <form id="chemicalsModal" class="content"></form>

  <div class="reveal-footer">
    <button class="button secondary float-left" data-reset-exclusions="chemicalGroupEntriesModal">Restore All</button>
    <button class="button secondary float-left" data-clear-exclusions="chemicalGroupEntriesModal">Clear All</button>
    <button class="button cancel" data-close>Cancel</button>
    <button class="button success" data-close data-save-exclusions="chemicalGroupEntriesModal">Save Modifications</button>
  </div>
</div>
