
<cfset ParamFunc = CreateObject("component", "cfc.searchparam_functions")>
<cfset publicationOptionsArray[1] = ParamFunc.pubsIndependentDataArray>
<cfset publicationOptionsArray[2] = ParamFunc.pubsRecentModsArray>

<div id="publicationParamsSidebar" class="secondary-sidebar off-canvas-absolute position-left" data-off-canvas data-transition="overlap" data-search-param="Publication Options">
  <h2 class="header"><button data-toggle="publicationParamsSidebar">
    <svg class="icon arrow" width="12" height="12"><use xlink:href="#chevron-left"></use></svg>
    Publication Options</button></h2>

  <button class="button warning reset-all">Reset</button>

  <form action="" data-searchparam>
    <label class="mt0">
      <b>Publication Years</b>
      <span class="input-group">
	  <cfoutput>
		<cfset minYear = 1915>
		<cfset maxYear = #year(now())#>
      <select id="Starting_Publication_Year" name="Starting_Publication_Year" class="default">
		  <cfloop index = "LoopCount" from = "#minYear#" to = "#maxYear#">
  		  <cfset optionClass = (LoopCount EQ minYear) ? 'default' : ''>
  			<option class="#optionClass#" value="#LoopCount#">#LoopCount#</option>
		  </cfloop>
      </select>

      <span class="input-group-label center">to</span>
      <select id="Ending_Publication_Year" name="Ending_Publication_Year" class="default">
		  <cfloop index = "LoopCount" from = "#maxYear#" to = "#minYear#" step="-1">
  			<cfset optionClass = (LoopCount EQ maxYear) ? 'default' : ''>
  			<option class="#optionClass#" value="#LoopCount#">#LoopCount#</option>
		  </cfloop>
      </select>
	  </cfoutput>
      </span>
    </label>

    <div class="input-group prepend append" tabindex="0">
      <textarea id="txAdvancedAuthorsEntries" rows="1" class="input-group-field auto-height" name="txAdvancedAuthorsEntries" placeholder="All"></textarea>
      <label class="input-group-label" for="txAdvancedAuthorsEntries">Author(s):</label>
      <a href="help.cfm?sub=hd-parameters#parameters-publications" target="_blank" class="input-group-button button help" title="Author text search help"><svg class="icon" width="16" height="16" alt="Help"><use xlink:href="#question-circle"></use></svg></a>
    </div>

    <div class="input-group prepend append" tabindex="0">
      <textarea id="txAdvancedPublicationsEntries" rows="1" class="input-group-field auto-height" name="txAdvancedPublicationsEntries" placeholder="All"></textarea>
      <label class="input-group-label" for="txAdvancedPublicationsEntries">Ref Num(s):</label>
      <a href="help.cfm?sub=hd-parameters#parameters-publications" target="_blank" class="input-group-button button help" title="Reference number text search help"><svg class="icon" width="16" height="16" alt="Help"><use xlink:href="#question-circle"></use></svg></a>
    </div>

    <p class="help-text">Enter each author and/or reference number on separate lines.</p>
  </form>

  <cfloop index="publicationOptionsGroup" array="#publicationOptionsArray#">

    <cfset header = #publicationOptionsGroup[1]#>
    <cfset spaceFreeHeader = ReReplace(header, "[[:space:]]","","ALL")>
	<cfset spaceFreeHeader = Replace(spaceFreeHeader, "/","","ALL")>
    <cfset inputsArray = #publicationOptionsGroup[2]#>

    <cfoutput>
      <form id="#spaceFreeHeader#Form" action="" data-searchparam>
        <input class="select-all" id="ckAll#spaceFreeHeader#" name="ckAll#spaceFreeHeader#" type="checkbox" checked>
        <label class="select-all" for="ckAll#spaceFreeHeader#">Any #header#</label>

        <fieldset>
          <legend class="show-for-sr">#header#</legend>
          <ul class="no-bullet">
            <cfloop index="inputItem" array="#inputsArray#">

              <cfset inputName = listGetAt(inputItem,3,';')>
              <cfset inputText = listGetAt(inputItem,2,';')>
              <cfset inputValue = listGetAt(inputItem,1,';')>

              <li>
                <input id="#inputName#" name="#inputName#" value="#inputValue#" type="checkbox" checked>
                <label for="#inputName#">#inputText#</label>
              </li>

            </cfloop>
          </ul>
        </fieldset>
      </form>
    </cfoutput>
  </cfloop>
</div>
