<!---
 * =================================================================================================
 *                           ADVANCED SEARCH ADVANCED CHEMICAL SEARCH FORM TEMPLATE
 * =================================================================================================
 * AUTHOR              : r.s.
 * FILENAME            : advanced_chemical.cfm
 * DESCRIPTION         : Template used to display chemical search form content.
 *
 *                       References alfincludes button action and caller.buttonStruct.  Also sets
 *                       hidden holdstate fields onClick/onBlur of form elements needing to be saved.
 * HISTORY             : 12/22/2002 - created file (r.s.)
 *						 01/02/2003 - modified comment structure (r.s.)
 *						 10/02/2014 SPE - ticket 3399: added new chemical group checkboxes
 *
 * =================================================================================================
--->

<cfinclude template="queries/advanced_species_query.cfm">
<cfset loopcount = 1>
<cfset groupFlag = "">
    
<cfset allChecked = 0>
<cfif not isdefined("form.specSelections")>
    <cfset form.specSelections = "">
</cfif>
<cfif form.specSelections eq "">
    <cfset allChecked = 1>
</cfif>

<cfif results.RecordCount gt 0>
    <cfoutput query="GetSpeciesList">
        <cfif groupFlag is not "#GetSpeciesList.species_listid#">
            <cfif loopcount gt 1>
                    </ul>
                    <hr>
                </fieldset>
            </cfif>
              
                <fieldset class="multi-select small" data-toggle="checkboxes" data-range="true">
                    <legend>#GetSpeciesList.species_list_desc#</legend>
                    <ul class="no-bullet col-medium-2">

            <cfset groupFlag = "#GetSpeciesList.species_listid#">
        </cfif>
        
    
        <cfset checkedStr = "">        
        <cfif allChecked eq 1>
            <cfset checkedStr = " checked">
        <cfelse>
            <cfset selectionListIdx = #ListFind(form.specSelections, GetSpeciesList.species_number)#>
            <cfif selectionListIdx gt 0>
                <cfset checkedStr = " checked">
            </cfif>
        </cfif>
                        <li>
                            <input id="itemInGroup-#GetSpeciesList.species_number#" type="checkbox" value="#GetSpeciesList.species_number#"#checkedStr#>
                            <label for="itemInGroup-#GetSpeciesList.species_number#">#GetSpeciesList.LATIN_NAME# <cfif GetSpeciesList.common_name neq "">- #GetSpeciesList.common_name#</cfif></label>
                        </li>

        <cfset loopcount = loopcount + 1>
    </cfoutput>
<cfelse>
    <div class="callout primary">
        <h5 class="title">Sorry</h5>
        <p>There were no results found for this search. Please refine your search.</p>
    </div>
</cfif>