<cfset GenFunc = CreateObject("component", "cfc.generic_functions")>
<cfset cleanInputs = CreateObject("component", "cfc.input_sanitize")>

<cfoutput>

<cfparam name="URL.toggle" default="">
<cfparam name="URL.dclose" default="">
<cfparam name="URL.modalid" default="">

<cfset validParam = cleanInputs.checkParamAlphaNumeric("toggle", URL.toggle, "URL")>
<cfset validParam = cleanInputs.checkParamAlphaNumeric("dclose", URL.dclose, "URL")>
<cfset validParam = cleanInputs.checkParamAlphaNumeric("modalid", URL.modalid, "URL")>

<cfset totalCount = 0>
<cfset innerLoopTooMany = 0>

<cfset cardKeys = structKeyList(paramsToDisplay)>

<cfloop list="#cardKeys#" index="cardid">

  <!---  SET SELECTED ITEMS LIST  --->
  <cfif cardid eq ParamFunc.cardnames["chemicals"]>
  	<cfset currentModList = selectedChems>
  <cfelseif cardid eq ParamFunc.cardnames["effect"]>
  	<cfset currentModList = selectedEffects>
  <cfelseif cardid eq ParamFunc.cardnames["species"]>
  	<cfset currentModList = selectedSpecs>
  <cfelse>
  	<cfset currentModList = structnew()>
  </cfif>

  <!---  LOOP THROUGH GROUPS  --->
  <cfset currentCardGroups = paramsToDisplay[cardid]>
  <!--- <cfdump var="#currentCardGroups#"> --->
  <cfif NOT StructIsEmpty(currentCardGroups)>

    <!---  SET IF CARD HAS NO-GROUPS --->
    <cfif StructKeyExists(currentCardGroups, "NO-GROUP")>
      <cfset thisNoGroupParams = currentCardGroups["NO-GROUP"]>

      <!---  SET IF CARD NO-GROUP HAS TEXT AREAS --->
      <cfif NOT StructIsEmpty(thisNoGroupParams)>
      	<cfset thisGroupsTextAreas = ParamFunc.getCardTextAreas(cardid) />
      </cfif>
    </cfif>
    <!--- DO PUB YEARS FIRST if exists --->
    <cfif isDefined("thisNoGroupParams") AND StructKeyExists(thisNoGroupParams, "Year Ending:")>
      <h5>Years: <span class="year">#thisNoGroupParams['Year Starting:']#</span> to <span class="year">#thisNoGroupParams['Year Ending:']#</span></h5>
    </cfif>

    <!--- DO ITEMS WITH TEXT AREAS FIRST if exists --->
    <cfif isDefined("thisGroupsTextAreas") AND ArrayLen(thisGroupsTextAreas) gt 0>	  
	  <cfloop index="i" from="1" to="#arrayLen(thisGroupsTextAreas)#">
		<cfset thisTextArea = thisGroupsTextAreas[i]>
  	    <cfif StructKeyExists(thisNoGroupParams, "#thisTextArea#")>

          <!---  Add a heading if there's more than 1 text area or if it's the publication or test options  --->
      		<cfif i gt 1 OR cardid eq "Publication Options" OR cardid eq "Test Conditions">
        		<h5>#thisTextArea#</h5>
      		</cfif>

      		<ul>

      		  <cfset thisTextAreaVal = thisNoGroupParams["#thisTextArea#"]>
      		  <cfif thisTextAreaVal neq "">
				<cfset modval = REReplace(thisTextAreaVal,"#chr(13)#|#chr(9)#|\n|\r",";","ALL")>
				<cfset splitValArray = ListToArray(modval,";",false,true)>

			<!--- Only loop through first 5, then append more link --->

				<cfset innertotalcount = ArrayLen(splitValArray)>
				<cfset innerloopcount = innertotalcount>
				<cfif innerloopcount gt 5>
				  <cfset innerloopcount = 5>
				</cfif>

				<cfloop from="1" to="#innerloopcount#" index="m">
					<li>#splitValArray[m]#</li>
				</cfloop>

				<cfif innertotalcount gt 5>
				  <li class="more">
				<button
				  data-open="<cfoutput>#URL.toggle#</cfoutput>"
				  data-close="<cfoutput>#URL.dclose#</cfoutput>">
				  #innertotalcount - 5# more...</button></li>
				</cfif>
      		  </cfif>

          </ul>

        </cfif>
  	  </cfloop>
    </cfif>

    <!--- START: LOOP THROUGH EACH GROUP --->

      <!--- CHEMICALS && ENDPOINTS && SPECIES - all under 1 group heading --->
      <cfif cardid EQ "Chemicals" OR cardid EQ "Endpoints" OR cardid EQ "Species">
        <cfset allItems = "" />

        <cfloop item="currentGroupName" collection="#currentCardGroups#">
          <!--- Append ALL params under one group --->
          <cfif currentGroupName neq "NO-GROUP">
            <cfset currentGroupParams = currentCardGroups["#currentGroupName#"]>
        	  <cfset groupParamsKeys = StructKeyList(#currentGroupParams#, ";")>
            <cfset allItems = ListAppend(allItems, groupParamsKeys, ";") />
          </cfif>
        </cfloop>

        <!--- IF THIS IS ENDPOINTS, don't show sub-children of (all % values) if checked
          NOT SURE IF THE IDEA IS CORRECT HERE
        <cfif cardid EQ "Endpoints">
          <cfset tempStr = "" />

          <cfloop list="#allItems#" item="item" delimiters=";" index="j">
            <cfset strPos = Find("xx", item) />

            <cfif strPos GT 0>
              <cfset tempStr = Trim(RemoveChars(item, strPos, Len(item))) />
            </cfif>

            <cfloop list="#tempStr#" item="str" delimiters="/" index="k">
              <cfif >

              </cfif>
            </cfloop>
          </cfloop>
        </cfif>
        --->

        <!--- Sort alphabetically --->
    	  <cfset allItems = ListSort(allItems, "textnocase", "asc", ";") />
    	  <cfset innertotalcount = ListLen(allItems, ";") />

        <cfif innertotalcount gt 0>

          <!--- Only show Groups heading for params without text search ability --->
          <cfif cardid EQ "Chemicals" OR cardid EQ "Species">
            <h5>Groups
              <cfif NOT StructIsEmpty("#currentModList#")>
                <a class="modified" data-open="#URL.modalid#" data-open-exclusions-sb>(Modified)</a>
              </cfif>
            </h5>
          </cfif>

      		<ul>	
			<cfset m = 1>
            <cfloop list="#allItems#" delimiters=";" index="paramname">
      				<li>#paramname#</li>
      				<cfif m eq 5><cfbreak></cfif>
					<cfset m = m + 1>
    			  </cfloop>

    			  <cfif innertotalcount gt 5>
      			  <li class="more">
                <button
                  data-open="<cfoutput>#URL.toggle#</cfoutput>"
                  data-close="<cfoutput>#URL.dclose#</cfoutput>">
                  #innertotalcount - 5# more...</button></li>
    			  </cfif>
      		</ul>
        </cfif>

      <!--- EFFECTS - all under 1 group heading including all but one NO-GROUP --->
      <cfelseif cardid EQ "Effect Measurements">
        <cfset allItems = "" />

        <cfloop item="currentGroupName" collection="#currentCardGroups#">
          <!--- Append ALL params under one group --->
          <cfset groupParamsKeys = "">

          <!--- Groups without children are NO-GROUPS,
                handle by adding to all items and removing from thisNoGroupParams --->
          <cfif currentGroupName eq "NO-GROUP">
            <cfloop item="noGroupParamName" collection="#currentCardGroups[currentGroupName]#">
              <cfif noGroupParamName neq "Exclude Post-exposure Measurements" && noGroupParamName neq "Effect(s)">
                <cfset deleted = StructDelete(thisNoGroupParams, noGroupParamName) >
                <cfset groupParamsKeys = ListAppend(groupParamsKeys, noGroupParamName, ";")>
              </cfif>
            </cfloop>
          <cfelse>
            <cfset currentGroupParams = currentCardGroups["#currentGroupName#"]>
        	  <cfset groupParamsKeys = StructKeyList(#currentGroupParams#, ";")>
          </cfif>

          <cfset allItems = ListAppend(allItems, groupParamsKeys, ";") />
        </cfloop>

        <!--- Sort alphabetically --->
    	  <cfset allItems = ListSort(allItems, "textnocase", "asc", ";")>
    	  <cfset innertotalcount = ListLen(allItems, ";")>

        <cfif innertotalcount gt 0>
          <h5>Groups
            <cfif NOT StructIsEmpty("#currentModList#")>
              <a class="modified" data-open="#URL.modalid#" data-open-exclusions-sb>(Modified)</a>
            </cfif>
          </h5>
      		<ul>
	
			<cfset m = 1>
            <cfloop list="#allItems#" delimiters=";" index="paramname">
      				<li>#Replace(paramname, " Group", "")#</li>
      				<cfif m eq 5><cfbreak></cfif>
					<cfset m = m + 1>
    			  </cfloop>

    			  <cfif innertotalcount gt 5>
      			  <li class="more">
                <button
                  data-open="<cfoutput>#URL.toggle#</cfoutput>"
                  data-close="<cfoutput>#URL.dclose#</cfoutput>">
                  #innertotalcount - 5# more...</button></li>
    			  </cfif>
      		</ul>
        </cfif>

        <cfif isDefined("effectNoGroup")>
          <p><em>#effectNoGroup#</em></p>
        </cfif>

      <!--- ANYTHING ELSE (TEST CONDITIONS & PUBLICATION OPTIONS) --->
      <cfelse>

        <cfloop item="currentGroupName" collection="#currentCardGroups#">
          <cfif currentGroupName neq "NO-GROUP">

        	  <cfset currentGroupParams = currentCardGroups["#currentGroupName#"]>
        	  <cfset sortedGroupParamsKeys = ListSort(StructKeyList(#currentGroupParams#, ";"), "textnocase", "asc", ";")>

        	  <!--- Counts --->
        	  <cfset innertotalcount = ListLen(sortedGroupParamsKeys, ";") />

            <cfif innertotalcount gt 0>
              <h5>#currentGroupName#
                <cfif NOT StructIsEmpty("#currentModList#")>
                  <a class="modified" data-open="#URL.modalid#" data-open-exclusions-sb>(Modified)</a>
                </cfif>
              </h5>
          		<ul>
	
				<cfset m = 1>
                <cfloop list="#sortedGroupParamsKeys#" delimiters=";" index="paramname">
          				<li>#paramname#</li>
          				<cfif m eq 5><cfbreak></cfif>
						<cfset m = m + 1>
        			  </cfloop>

        			  <cfif innertotalcount gt 5>
          			  <li class="more">
                    <button
                      data-open="<cfoutput>#URL.toggle#</cfoutput>"
                      data-close="<cfoutput>#URL.dclose#</cfoutput>">
                      #innertotalcount - 5# more...</button></li>
        			  </cfif>
          		</ul>
            </cfif>

        	</cfif>
        </cfloop>

      </cfif>

    <!--- END: LOOP THROUGH EACH GROUP --->

    <!--- DO ITEMS WITHOUT A GROUP LAST (except for effects) --->
    <cfif isDefined("thisNoGroupParams")>
    	<cfloop item="paramname" collection="#thisNoGroupParams#">
    	  <cfif GenFunc.findInArray(thisGroupsTextAreas, paramname, false) eq 0 AND
                paramname neq "Year Ending:" AND
                paramname neq "Year Starting:" AND
                paramname neq "Kingdom" AND
                paramname neq "Name Search Type">

                <cfset thisval = thisNoGroupParams["#paramname#"]>
                <p><em>#paramname#</em></p>
          <cfelseif paramname eq "Kingdom">
                <cfset thisval = thisNoGroupParams["#paramname#"]>
                <p><em>#paramname#: #thisval#</em></p>
    	  </cfif>
    	</cfloop>
    </cfif>

  </cfif>

</cfloop>

</cfoutput>
