<!---    

    EXPECTED VARIABLES FROM DB/DATA TEMPLATE:

        ChemicalSearchMatchesQuery - a coldfusion query object with this name.

    EXPECTED VARIABLES FROM HANDLER:

        OUTPUTFORMAT - JSON for web, CSV, EXCEL (possibly others in future) for exports

--->

<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<!--- ERROR HANDLING, MAY NOT BE NEEDED HERE --->
<cfset error = "0">
<cfset errorHtml = "">
<cfset messageClass = ''>
<cfset messageTitle = ''>
<cfset messageText = ''>
    
<cfset recordCount = ChemicalSearchMatchesQuery.TotalRows>
<cfif recordCount eq "">
    <cfset recordCount = 0>
</cfif>    
    
<cfset displayedRecs = MATCHSTARTPOS + MATCHPAGESIZE>
<cfset MATCHMORERECORDS = 'false'> 
<cfif displayedRecs lt recordCount>
    <cfset MATCHMORERECORDS = 'true'>
</cfif>        

<cfset dataArray = "">
    

<cfif recordCount eq 0>
      
    <!--- THIS MAY NOT BE NEEDED HERE --->  

    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "There were no results found for this search. Please refine your search.">        

<cfelse>

    <cfoutput query="ChemicalSearchMatchesQuery">
        <cfset result = '{'>

        <cfset syn_str = ChemicalSearchMatchesQuery.synonyms>
        <cfif not isDefined("syn_str")>
            <cfset syn_str = "">
        </cfif>

        <cfif syn_str neq "">
            <cfset syn_str = '  |  Synonyms: ' & syn_str>
        </cfif>
            
        <cfset chem_name = ChemicalSearchMatchesQuery.chemical_name>    
        <cfif not isDefined("chem_name")>
            <cfset chem_name = "">
        </cfif>

        <cfif chem_name neq "">
            <cfset chem_name = '  | ' & chem_name>           
        </cfif>

        <cfset syn_str = REPLACE(syn_str,'"', '\"', 'ALL')>
        <cfset cas_num = REPLACE(ChemicalSearchMatchesQuery.cas_number,'"', '\"', 'ALL')>
        <cfset chem_name = REPLACE(chem_name,'"', '\"', 'ALL')>
        
        <cfset resultItemText = "#cas_num##chem_name##syn_str#">
        <cfif resultItemText EQ "">
            <cfset resultItemText = "Project Name: #ChemicalSearchMatchesQuery.project_name#">
        <cfelse>
            <cfset resultItemText = "CAS: #cas_num##chem_name##syn_str#">
        </cfif>

        <cfset result = result & '"id":"#ChemicalSearchMatchesQuery.chem_search_id#",'>
        <cfset result = result & '"text":"#resultItemText#"'>

        <cfset result = result & '}'>

        <cfset dataArray = listAppend(dataArray, result)>

    </cfoutput>
            
</cfif>
    
<!---construct json output --->

<!--- FIGURE OUT ERROR HANDLING --->

<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>



<cfset jsonString = '{"results":['>

<cfset dataString = "">
<cfloop list="#dataArray#" index="dataItem">
    <cfset dataString = listAppend(dataString, dataItem)>
</cfloop>
    
<cfset jsonString = jsonString & dataString & '],'>
       
<cfset jsonString = jsonString & '"pagination": { "more": #MATCHMORERECORDS# }'>
       
<cfset jsonString = jsonString & '}'>

<cfoutput>
    #jsonString#
</cfoutput>
