<cfset caslist = FORM.pubchemicals>
<cfset specNumbers = FORM.pubspecies>
<cfset effMeasPairs = FORM.pubeffects>
<cfset refNums_a = FORM.pubauthor>
<cfset refNums_t = FORM.pubtitle>

<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="PubsQueryRefNums" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="PubsQueryRefNumsVars">
        
        SELECT 
            distinct f.reference_number
        FROM
            references f
            LEFT JOIN tests t ON t.ecoref_number = f.reference_number
            LEFT JOIN results r ON r.test_id_fk = t.test_id
        WHERE (
            1=1            
            --if chemical entry
            <cfif len(trim(caslist))>
                AND t.test_cas IN (<CFQUERYPARAM VALUE="#caslist#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            </cfif>
            --if species entry
            <cfif len(trim(specNumbers))>
                AND t.species_number IN (<CFQUERYPARAM VALUE="#specNumbers#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            </cfif>
            --if effects entry
            <cfif len(trim(effMeasPairs))>
                AND (
                <cfset pairCount = 0>
                <cfloop index=pair list="#effMeasPairs#" delimiters=",">
                    <cfset trimmedVal = trim(pair)>
                    <cfset effCode = ListGetAt(trimmedVal, 1, "|")>
                    <cfset measCode = ListGetAt(trimmedVal, 2, "|")>

                    <cfif len(trim(effCode)) AND len(trim(measCode))>
                        <cfif pairCount GT 0> OR </cfif>
                        (REPLACE(REPLACE(r.effect, '~', ''), '/', '') = <CFQUERYPARAM VALUE="#effCode#" CFSQLTYPE="CF_SQL_VARCHAR"> AND REPLACE(REPLACE(r.measurement, '~', ''), '/', '') = <CFQUERYPARAM VALUE="#measCode#" CFSQLTYPE="CF_SQL_VARCHAR">)
                        <cfset pairCount = pairCount + 1>
                    </cfif>
                </cfloop>
                )
            </cfif>
            --if author entry  NOTE: refs for that author match are sent by refnum
            <cfif len(trim(refNums_a))>
                AND f.reference_number in (<CFQUERYPARAM VALUE="#refNums_a#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            </cfif>
            --if title entry  NOTE: refs for that title match are sent by refnum
            <cfif len(trim(refNums_t))>
                AND f.reference_number in (<CFQUERYPARAM VALUE="#refNums_t#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            </cfif>
        )

    </cfquery>
    
    <!---<cflog text ="#PubsQueryRefNumsVars.sql#">
    <cflog text ="#ArrayToList(PubsQueryRefNumsVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>
