
<!--- Build 2 dimensional array to hold available Terrestrial output field SQL column names and display values
	  - Column Order determined by order below.

	  terrestrialOutputFields[x][y]:
	  	- x dimension represents Out put field selections.
		- [x][1] - represents form field name
		- [x][2] - represents display name (column header)
		- [x][3] - represents SQL column names
		- [x][4] - represents SQL table alias
		- [x][5] - represents full name for display fields JSON lookup

--->
<cfset terrestrialOutputFields = arrayNew(2)>

<!--- <cfoutput>
#form.fieldnames#
</cfoutput> --->


<cfset ofIndex = 1>
    
<cfif isdefined("form.cb_test_number") and form.cb_test_number is not "" and form.cb_test_number is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_test_number>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Test##">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_NUMBER">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Test Number">
	<cfset ofIndex = ofIndex + 1>
</cfif>    
    
<cfif isdefined("form.cb_result_recnum") and form.cb_result_recnum is not "" and form.cb_result_recnum is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_result_recnum>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Result Rec. Num.">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "RESULT_NUMBER">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Results Record Number">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_cas_number_name") and form.cb_cas_number_name is not "" and form.cb_cas_number_name is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_cas_number_name>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "CAS##|Chem. Name">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_CAS,CHEM_PRIMARY_NAME">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "CAS Number | Chemical Name">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_cas_number_name") and form.cb_cas_number_name is not "" and form.cb_cas_number_name is not 0>
<cfelse>
	<cfif isdefined("form.cb_cas_number") and form.cb_cas_number is not "" and form.cb_cas_number is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_cas_number>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "CAS##">
		<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_CAS">
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "CAS Number">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>
    
<cfif isdefined("form.cb_cas_number_name") and form.cb_cas_number_name is not "" and form.cb_cas_number_name is not 0>
<cfelse>
	<cfif isdefined("form.cb_chem_name") and form.cb_chem_name is not "" and form.cb_chem_name is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_chem_name>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Chem. Name">
		<cfset terrestrialOutputFields[#ofIndex#][3] = "CHEM_PRIMARY_NAME">
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Chemical Name">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>
    
<cfif isdefined("form.cb_chem_grade") and form.cb_chem_grade is not "" and form.cb_chem_grade is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_chem_grade>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Chem. Grade">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_GRADE">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_GRADE_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Chemical Grade">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_exp_type") and form.cb_exp_type is not "" and form.cb_exp_type is not 0>
<cfelse>
	<cfif isdefined("form.cb_chem_analysis") and form.cb_chem_analysis is not "" and form.cb_chem_analysis is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_chem_analysis>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Chem. Anal.">
		<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "METHOD">
		<cfelse>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "METHOD_DESC">
		</cfif>
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Chemical Analysis">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cb_chem_purity") and form.cb_chem_purity is not "" and form.cb_chem_purity is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_chem_purity>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Chem. Pur.">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_PURITY,TEST_PURITY_MEAN_OP,TEST_PURITY_MEAN,TEST_PURITY_MIN_OP,TEST_PURITY_MIN,TEST_PURITY_MAX_OP,TEST_PURITY_MAX">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Chemical Purity">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_chem_formulation") and form.cb_chem_formulation is not "" and form.cb_chem_formulation is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_chem_formulation>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Chem. Form.">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_FORMULATION">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_FORMULATION_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Chemical Formulation">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_chem_radio") and form.cb_chem_radio is not "" and form.cb_chem_radio is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_chem_radio>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Chem. Radiolabel">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_RADIOLABEL">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Chemical Radiolabel">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_chem_comment") and form.cb_chem_comment is not "" and form.cb_chem_comment is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_chem_comment>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Chem. Comment">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_CHAR">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Chemical Comment">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_carrier_cas") and form.cb_carrier_cas is not "" and form.cb_carrier_cas is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_carrier_cas>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Chem. Carrier">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "CHEMICAL_CARRIER_CONCAT">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Chemical Carrier">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_species_scient_common") and form.cb_species_scient_common is not "" and form.cb_species_scient_common is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_species_scient_common>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Spec. Sci. Name|Spec. Common Name">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "LATIN_NAME,COMMON_NAME">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Species Scientific Name | Species Common Name">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_species_scient_common") and form.cb_species_scient_common is not "" and form.cb_species_scient_common is not 0>
<cfelse>
	<cfif isdefined("form.cb_species_scient_name") and form.cb_species_scient_name is not "" and form.cb_species_scient_name is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_species_scient_name>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Spec. Sci. Name">
		<cfset terrestrialOutputFields[#ofIndex#][3] = "LATIN_NAME">
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Species Scientific Name">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>
    
<cfif isdefined("form.cb_species_scient_common") and form.cb_species_scient_common is not "" and form.cb_species_scient_common is not 0>
<cfelse>
	<cfif isdefined("form.cb_species_commonname") and form.cb_species_commonname is not "" and form.cb_species_commonname is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_species_commonname>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Spec. Common Name">
		<cfset terrestrialOutputFields[#ofIndex#][3] = "COMMON_NAME">
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Species Common Name">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>
    
<cfif isdefined("form.cbSpecies_tax") and form.cbSpecies_tax is not "" and form.cbSpecies_tax is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cbSpecies_tax>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Spec. Taxon. Info.">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "KINGDOM,PHYLUM_DIVISION,SUBPHYLUM_DIV,SUPERCLASS,CLASS,TAX_ORDER,FAMILY,GENUS,SPECIES,VARIETY">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Species Taxonomic Information">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_species_group") and form.cb_species_group is not "" and form.cb_species_group is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_species_group>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Spec. Group">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "SPECIES_LIST_DESC">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Species Group">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbNcbiTaxId") and form.cbNcbiTaxId is not "" and form.cbNcbiTaxId is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = form.cbNcbiTaxId>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Spec. NCBI ID">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "NCBI_TAXID">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Species NCBI TaxID">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbDTXSID") and form.cbDTXSID is not "" and form.cbDTXSID is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = form.cbDTXSID>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Chem. DTXSID">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "DTXSID">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Chemical DTXSID">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_species_num") and form.cb_species_num is not "" and form.cb_species_num is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_species_num>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Spec. ECO ##">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "SPECIES_NUMBER">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Species ECOTOX Number">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_habitat") and form.cb_habitat is not "" and form.cb_habitat is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_habitat>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Habitat">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "ORGANISM_HABITAT">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Habitat">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbDOI") and form.cbDOI is not "" and form.cbDOI is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = form.cbDOI>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "DOI">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "DOI">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "DOI">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_organism_source") and form.cb_organism_source is not "" and form.cb_organism_source is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_organism_source>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Org. Source">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "ORGANISM_SOURCE">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "ORGANISM_SOURCE_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Organism Source">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_gender") and form.cb_gender is not "" and form.cb_gender is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_gender>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Gender">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "SEX">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Gender">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_organism_comment") and form.cb_organism_comment is not "" and form.cb_organism_comment is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_organism_comment>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Org. Comment">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "ORGANISM_CHAR">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Organism Comment">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_org_lifestage") and form.cb_org_lifestage is not "" and form.cb_org_lifestage is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_org_lifestage>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Org. Lifestg.">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "LIFESTAGE">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "LIFESTAGE_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Organism Lifestage">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_organism_age") and form.cb_organism_age is not "" and form.cb_organism_age is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_organism_age>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Org. Age">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "AGE,ORGANISM_AGE_MEAN_OP,ORGANISM_AGE_MEAN,ORGANISM_AGE_MIN_OP,ORGANISM_AGE_MIN,ORGANISM_AGE_MAX_OP,ORGANISM_AGE_MAX,AGE_UNITS">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "AGE_DESC,ORGANISM_AGE_MEAN_OP,ORGANISM_AGE_MEAN,ORGANISM_AGE_MIN_OP,ORGANISM_AGE_MIN,ORGANISM_AGE_MAX_OP,ORGANISM_AGE_MAX,AGE_UNITS_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Organism Age">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_organism_length") and form.cb_organism_length is not "" and form.cb_organism_length is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = form.cb_organism_length>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Org. Init. Length">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "ORGANISM_LENGTH,ORGANISM_LENGTH_MEAN_OP,ORGANISM_LENGTH_MEAN,ORGANISM_LENGTH_MIN_OP,ORGANISM_LENGTH_MIN,ORGANISM_LENGTH_MAX_OP,ORGANISM_LENGTH_MAX,ORGANISM_LENGTH_UNIT,ORGANISM_LENGTH_TYPE">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "ORGANISM_LENGTH_DESC,ORGANISM_LENGTH_MEAN_OP,ORGANISM_LENGTH_MEAN,ORGANISM_LENGTH_MIN_OP,ORGANISM_LENGTH_MIN,ORGANISM_LENGTH_MAX_OP,ORGANISM_LENGTH_MAX,ORGANISM_LENGTH_UNIT_DESC,ORGANISM_LENGTH_TYPE_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Organism Initial Length">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_organism_init_wt") and form.cb_organism_init_wt is not "" and form.cb_organism_init_wt is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_organism_init_wt>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Org. Init. Wt.">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "ORGANISM_INIT_WT,ORGANISM_INIT_WT_MEAN_OP,ORGANISM_INIT_WT_MEAN,ORGANISM_INIT_WT_MIN_OP,ORGANISM_INIT_WT_MIN,ORGANISM_INIT_WT_MAX_OP,ORGANISM_INIT_WT_MAX,ORGANISM_INIT_WT_UNIT">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Organism Initial Weight">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_organism_strain") and form.cb_organism_strain is not "" and form.cb_organism_strain is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = form.cb_organism_strain>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Org. Strain">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "ORGANISM_STRAIN">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Organism Strain">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_number_replicates") and form.cb_number_replicates is not "" and form.cb_number_replicates is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = form.cb_number_replicates>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Num. Replicates">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "NUMBER_REPLICATES">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Number of Replicates">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_exp_type") and form.cb_exp_type is not "" and form.cb_exp_type is not 0>
<cfelse>
	<cfif isdefined("form.cb_exp_duration_type") and form.cb_exp_duration_type is not "" and form.cb_exp_duration_type is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_exp_duration_type>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Exp. Type">
		<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "EXPOSURE_TYPE">
		<cfelse>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "EXPOSURE_TYPE_DESC">
		</cfif>
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Exposure Type">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>
    
<cfif isdefined("form.cb_media_type_loc") and form.cb_media_type_loc is not "" and form.cb_media_type_loc is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_media_type_loc>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Media Type|Test Loc.">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "MEDIA_TYPE,TEST_LOCATION">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "MEDIA_TYPE_DESC,TEST_LOCATION_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Media Type | Test Location">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_media_type_loc") and form.cb_media_type_loc is not "" and form.cb_media_type_loc is not 0>
<cfelse>
	<cfif isdefined("form.cb_media_type") and form.cb_media_type is not "" and form.cb_media_type is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_media_type>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Media Type">
		<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "MEDIA_TYPE">
		<cfelse>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "MEDIA_TYPE_DESC">
		</cfif>
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Media Type">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>
    
<cfif isdefined("form.cb_media_type_loc") and form.cb_media_type_loc is not "" and form.cb_media_type_loc is not 0>
<cfelse>
	<cfif isdefined("form.cb_test_location") and form.cb_test_location is not "" and form.cb_test_location is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_test_location>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Test Loc.">
		<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_LOCATION">
		<cfelse>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_LOCATION_DESC">
		</cfif>
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Test Location">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>
    
<cfif isdefined("form.cb_test_method") and form.cb_test_method is not "" and form.cb_test_method is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_test_method>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Chem Anal Meth">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_METHOD">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_METHOD_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Chemical Analysis (Method)">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_exp_type") and form.cb_exp_type is not "" and form.cb_exp_type is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_exp_type>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Exp. Type|Chem. Anal.">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "EXPOSURE_TYPE,METHOD">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "EXPOSURE_TYPE_DESC,METHOD_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Exposure Type | Chemical Analysis">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_doses") and form.cb_doses is not "" and form.cb_doses is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_doses>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Doses">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "DOSES,DOSE_MEAN_OP,DOSE_MEAN,DOSE_MIN_OP,DOSE_MIN,DOSE_MAX_OP,DOSE_MAX,DOSE_UNITS">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Doses">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_sample_num_unit") and form.cb_sample_num_unit is not "" and form.cb_sample_num_unit is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_sample_num_unit>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Res. Sample Number|Unit">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "SAMPLE_NUMBER,SAMPLE_SIZE_MEAN_OP,SAMPLE_SIZE_MEAN,SAMPLE_SIZE_MIN_OP,SAMPLE_SIZE_MIN,SAMPLE_SIZE_MAX_OP,SAMPLE_SIZE_MAX,SAMPLE_UNIT">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "SAMPLE_NUMBER,SAMPLE_SIZE_MEAN_OP,SAMPLE_SIZE_MEAN,SAMPLE_SIZE_MIN_OP,SAMPLE_SIZE_MIN,SAMPLE_SIZE_MAX_OP,SAMPLE_SIZE_MAX,SAMPLE_UNIT_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Result Sample Number | Unit">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_dose_number") and form.cb_dose_number is not "" and form.cb_dose_number is not 0>
<cfelse>
	<cfif isdefined("form.cb_sample_num_unit") and form.cb_sample_num_unit is not "" and form.cb_sample_num_unit is not 0>
	<cfelse>
		<cfif isdefined("form.cb_sample_unit") and form.cb_sample_unit is not "" and form.cb_sample_unit is not 0>
			<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_sample_unit>
			<cfset terrestrialOutputFields[#ofIndex#][2] = "Res. Sample Unit">
			<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
				<cfset terrestrialOutputFields[#ofIndex#][3] = "SAMPLE_UNIT">
			<cfelse>
				<cfset terrestrialOutputFields[#ofIndex#][3] = "SAMPLE_UNIT_DESC">
			</cfif>
			<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
			<cfset terrestrialOutputFields[#ofIndex#][5] = "Result Sample Unit">
			<cfset ofIndex = ofIndex + 1>
		</cfif>
	</cfif>
</cfif>

<cfif isdefined("form.cb_dose_number") and form.cb_dose_number is not "" and form.cb_dose_number is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_dose_number>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Number of Doses">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "DOSE_NUMBER">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Number of Doses">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_dose_stat_method2") and form.cb_dose_stat_method2 is not "" and form.cb_dose_stat_method2 is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_dose_stat_method2>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Conc. Type: Dose">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "CONC1_TYPE,CONC1_MEAN_OP,CONC1_MEAN,CONC1_MIN_OP,CONC1_MIN,CONC1_MAX_OP,CONC1_MAX,CONC1_UNIT,CONC2_TYPE,CONC2_MEAN_OP,CONC2_MEAN,CONC2_MIN_OP,CONC2_MIN,CONC2_MAX_OP,CONC2_MAX,CONC2_UNIT,CONC3_TYPE,CONC3_MEAN_OP,CONC3_MEAN,CONC3_MIN_OP,CONC3_MIN,CONC3_MAX_OP,CONC3_MAX,CONC3_UNIT">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "CONC1_TYPE_DESC,CONC1_MEAN_OP,CONC1_MEAN,CONC1_MIN_OP,CONC1_MIN,CONC1_MAX_OP,CONC1_MAX,CONC1_UNIT,CONC2_TYPE_DESC,CONC2_MEAN_OP,CONC2_MEAN,CONC2_MIN_OP,CONC2_MIN,CONC2_MAX_OP,CONC2_MAX,CONC2_UNIT,CONC3_TYPE_DESC,CONC3_MEAN_OP,CONC3_MEAN,CONC3_MIN_OP,CONC3_MIN,CONC3_MAX_OP,CONC3_MAX,CONC3_UNIT">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Concentration/Dose">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_effect_and_meas") and form.cb_effect_and_meas is not "" and form.cb_effect_and_meas is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_effect_and_meas>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Effect|Effect Meas.">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "EFFECT,MEASUREMENT">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "EFFECT_DESC,MEASUREMENT_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Effect | ">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_effect_and_meas") and form.cb_effect_and_meas is not "" and form.cb_effect_and_meas is not 0>
<cfelse>
	<cfif isdefined("form.cb_effect") and form.cb_effect is not "" and form.cb_effect is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_effect>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Effect">
		<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "EFFECT">
		<cfelse>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "EFFECT_DESC">
		</cfif>
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Effect">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cb_effect_and_meas") and form.cb_effect_and_meas is not "" and form.cb_effect_and_meas is not 0>
<cfelse>
	<cfif isdefined("form.cb_effect_meas") and form.cb_effect_meas is not "" and form.cb_effect_meas is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_effect_meas>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Effect Meas.">
		<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "MEASUREMENT">
		<cfelse>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "MEASUREMENT_DESC">
		</cfif>
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Effect (Measurement)">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cb_endpoint") and form.cb_endpoint is not "" and form.cb_endpoint is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_endpoint>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Endpoint|BAF/BCF">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "ENDPOINT,RESPONSE_MEAN_OP,OBSERV_RESPONSE_MEAN,RESPONSE_MIN_OP,OBSERV_RESPONSE_MIN,RESPONSE_MAX_OP,OBSERV_RESPONSE_MAX,RESULT_STAT_METHOD,OBSERV_RESPONSE_VALUE,OBSERV_RESPONSE_UNITS">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Endpoint | Bioconcentration">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_endpoint") and form.cb_endpoint is not "" and form.cb_endpoint is not 0>
<cfelse>
	<cfif isdefined("form.cb_BCF") and form.cb_BCF is not "" and form.cb_BCF is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_BCF>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "BCF">
		<cfset terrestrialOutputFields[#ofIndex#][3] = "BCF1_MEAN_OP,BCF1_MEAN,BCF1_MIN_OP,BCF1_MIN,BCF1_MAX_OP,BCF1_MAX,BCF1_UNIT,BCF2_MEAN_OP,BCF2_MEAN,BCF2_MIN_OP,BCF2_MIN,BCF2_MAX_OP,BCF2_MAX,BCF2_UNIT,BCF3_MEAN_OP,BCF3_MEAN,BCF3_MIN_OP,BCF3_MIN,BCF3_MAX_OP,BCF3_MAX,BCF3_UNIT">
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW,VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Bioconcentration">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cb_endpoint") and form.cb_endpoint is not "" and form.cb_endpoint is not 0>
<cfelse>
	<cfif isdefined("form.cb_endpoint_only") and form.cb_endpoint_only is not "" and form.cb_endpoint_only is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_endpoint_only>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Endpoint">
		<cfset terrestrialOutputFields[#ofIndex#][3] = "ENDPOINT">
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Endpoint">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>  

<cfif isdefined("form.cb_response_site_samp") and form.cb_response_site_samp is not "" and form.cb_response_site_samp is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_response_site_samp>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Resp. Site|Exp. Dur. (Days)">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "SITE,EXPOSURE_MEAN_STD_OP,EXP_DURATION_MEAN_STD,EXPOSURE_MIN_STD_OP,EXP_DURATION_MIN_STD,EXPOSURE_MAX_STD_OP,EXP_DURATION_MAX_STD,EXP_DURATION_UNIT_STD">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "SITE_DESC,EXPOSURE_MEAN_STD_OP,EXP_DURATION_MEAN_STD,EXPOSURE_MIN_STD_OP,EXP_DURATION_MIN_STD,EXPOSURE_MAX_STD_OP,EXP_DURATION_MAX_STD,EXP_DURATION_UNIT_STD_LONG">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Response Site | Exposure Duration">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_response_site_samp") and form.cb_response_site_samp is not "" and form.cb_response_site_samp is not 0>
<cfelse>
	<cfif isdefined("form.cb_exp_duration_std") and form.cb_exp_duration_std is not "" and form.cb_exp_duration_std is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_exp_duration_std>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Exp. Dur. (Days)">
		<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "EXPOSURE_MEAN_OP,EXP_DURATION_MEAN_STD,EXPOSURE_MIN_OP,EXP_DURATION_MIN_STD,EXPOSURE_MAX_OP,EXP_DURATION_MAX_STD,EXP_DURATION_UNIT_STD">
		<cfelse>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "EXPOSURE_MEAN_OP,EXP_DURATION_MEAN_STD,EXPOSURE_MIN_OP,EXP_DURATION_MIN_STD,EXPOSURE_MAX_OP,EXP_DURATION_MAX_STD,EXP_DURATION_UNIT_STD_LONG">
		</cfif>
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Exposure Duration (Days)">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cb_response_site_samp") and form.cb_response_site_samp is not "" and form.cb_response_site_samp is not 0>
<cfelse>
	<cfif isdefined("form.cb_response_site") and form.cb_response_site is not "" and form.cb_response_site is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_response_site>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Resp. Site">
		<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "SITE">
		<cfelse>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "SITE_DESC">
		</cfif>
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Response Site">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cb_observed_duration") and form.cb_observed_duration is not "" and form.cb_observed_duration is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_observed_duration>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Obs. Dur. (Author)">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "OBSERV_MEAN_OP,OBSERV_DURATION_MEAN,OBSERV_MIN_OP,OBSERV_DURATION_MIN,OBSERV_MAX_OP,OBSERV_DURATION_MAX,OBSERV_DURATION_UNIT">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "OBSERV_MEAN_OP,OBSERV_DURATION_MEAN,OBSERV_MIN_OP,OBSERV_DURATION_MIN,OBSERV_MAX_OP,OBSERV_DURATION_MAX,OBSERV_DURATION_UNIT_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Observed Duration (Author)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_observed_duration_std") and form.cb_observed_duration_std is not "" and form.cb_observed_duration_std is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_observed_duration_std>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Obs. Dur. (Days)">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "OBSERV_MEAN_STD_OP,OBSERV_DURATION_MEAN_STD,OBSERV_MIN_STD_OP,OBSERV_DURATION_MIN_STD,OBSERV_MAX_STD_OP,OBSERV_DURATION_MAX_STD,OBSERV_DURATION_UNIT_STD">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "OBSERV_MEAN_STD_OP,OBSERV_DURATION_MEAN_STD,OBSERV_MIN_STD_OP,OBSERV_DURATION_MIN_STD,OBSERV_MAX_STD_OP,OBSERV_DURATION_MAX_STD,OBSERV_DURATION_UNIT_STD_LONG">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Observed Duration (Days)">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_study_dur") and form.cb_study_dur is not "" and form.cb_study_dur is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_study_dur>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Study Dur. (Author)">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "STUDY_MEAN_OP,STUDY_MEAN,STUDY_MIN_OP,STUDY_MIN,STUDY_MAX_OP,STUDY_MAX,STUDY_DURATION_UNIT">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "STUDY_MEAN_OP,STUDY_MEAN,STUDY_MIN_OP,STUDY_MIN,STUDY_MAX_OP,STUDY_MAX,STUDY_DURATION_UNIT_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Study Duration (Author)">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_study_dur_std") and form.cb_study_dur_std is not "" and form.cb_study_dur_std is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_study_dur_std>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Study Dur. (Days)">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "STUDY_MEAN_STD_OP,STUDY_MEAN_STD,STUDY_MIN_STD_OP,STUDY_MIN_STD,STUDY_MAX_STD_OP,STUDY_MAX_STD,STUDY_DURATION_UNIT_STD">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "STUDY_MEAN_STD_OP,STUDY_MEAN_STD,STUDY_MIN_STD_OP,STUDY_MIN_STD,STUDY_MAX_STD_OP,STUDY_MAX_STD,STUDY_DURATION_UNIT_STD_LONG">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Study Duration (Days)">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_app_frequency") and form.cb_app_frequency is not "" and form.cb_app_frequency is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_app_frequency>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "App. Freq.|Unit">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "APP_FREQ_VALUE,APPLICATION_FREQ_MEAN_OP,APPLICATION_FREQ_MEAN,APPLICATION_FREQ_MIN_OP,APPLICATION_FREQ_MIN,APPLICATION_FREQ_MAX_OP,APPLICATION_FREQ_MAX,APP_FREQ_UNITS">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "APP_FREQ_VALUE,APPLICATION_FREQ_MEAN_OP,APPLICATION_FREQ_MEAN,APPLICATION_FREQ_MIN_OP,APPLICATION_FREQ_MIN,APPLICATION_FREQ_MAX_OP,APPLICATION_FREQ_MAX,APP_FREQ_UNITS_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Application Frequency | Unit">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_exp_duration") and form.cb_exp_duration is not "" and form.cb_exp_duration is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_exp_duration>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Exp. Dur. (Author)">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "EXPOSURE_MEAN_OP,EXPOSURE_MEAN,EXPOSURE_MIN_OP,EXPOSURE_MIN,EXPOSURE_MAX_OP,EXPOSURE_MAX,EXPOSURE_DURATION_UNIT">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "EXPOSURE_MEAN_OP,EXPOSURE_MEAN,EXPOSURE_MIN_OP,EXPOSURE_MIN,EXPOSURE_MAX_OP,EXPOSURE_MAX,EXPOSURE_DURATION_UNIT_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Exposure Duration (Author)">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_control") and form.cb_control is not "" and form.cb_control is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_control>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Control">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "CONTROL_TYPE">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "CONTROL_TYPE_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Control">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_study_type") and form.cb_study_type is not "" and form.cb_study_type is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_study_type>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Study Type">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "STUDY_TYPE">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Study Type">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_test_type") and form.cb_test_type is not "" and form.cb_test_type is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_test_type>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Test Type">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_TYPE">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_TYPE_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Test Type">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_organism_number") and form.cb_organism_number is not "" and form.cb_organism_number is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_organism_number>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Exp. Sample Number">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "ORGANISM_NUMBER,NUMBER_ORGANISMS_MEAN_OP,NUMBER_ORGANISMS_MEAN,NUMBER_ORGANISMS_MIN_OP,NUMBER_ORGANISMS_MIN,NUMBER_ORGANISMS_MAX_OP,NUMBER_ORGANISMS_MAX">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Exposure Sample Number">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_exp_design") and form.cb_exp_design is not "" and form.cb_exp_design is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_exp_design>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Experimental Design">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "EXPDESIGN">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Experimental Design">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_other_effects") and form.cb_other_effects is not "" and form.cb_other_effects is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_other_effects>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Other Effects">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "OTHEREFFECT">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Other Effects">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_test_comments") and form.cb_test_comments is not "" and form.cb_test_comments is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_test_comments>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Test Comments">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "TEST_REMARK">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Test Comments">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_habitat_code") and form.cb_habitat_code is not "" and form.cb_habitat_code is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_habitat_code>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Sub-Habitat">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "HABITAT_CODE,HABITAT_CODE_DESC">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Sub-Habitat">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_habitat_comment") and form.cb_habitat_comment is not "" and form.cb_habitat_comment is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_habitat_comment>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Sub-Habitat Comments">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "HABITAT_COMMENT">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Sub-Habitat Comments">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_geocode") and form.cb_geocode is not "" and form.cb_geocode is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_geocode>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Geog. Term">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "GEO_CODE,GEO_CODE_DESC">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Geographic Term">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_geographic_loc") and form.cb_geographic_loc is not "" and form.cb_geographic_loc is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_geographic_loc>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Geog. Loc">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "FS_TEST_LOCATION">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Geographic Term">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_lat_long") and form.cb_lat_long is not "" and form.cb_lat_long is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_lat_long>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Lat/Long">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "LATITUDE,LONGITUDE">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Latitude/Longitude">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_sub_strate") and form.cb_sub_strate is not "" and form.cb_sub_strate is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_sub_strate>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Substr. Term">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "SUBSTRATE_CODE">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "SUBSTRATE_CODE_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Substrate Term/Description">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_sub_strate_comment") and form.cb_sub_strate_comment is not "" and form.cb_sub_strate_comment is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_sub_strate_comment>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Substr. Descr.">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "SUBSTRATE_DESC">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Substrate Term/Description">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_app_date2") and form.cb_app_date2 is not "" and form.cb_app_date2 is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_app_date2>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Appl. Date">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "APP_DATE">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Application Date/Season">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_app_date_season") and form.cb_app_date_season is not "" and form.cb_app_date_season is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_app_date_season>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Appl. Date|Appl. Seas.">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "APP_DATE,APP_SEASON,APP_SEASON_DESC">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Application Date/Season | ">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_chem_halflife") and form.cb_chem_halflife is not "" and form.cb_chem_halflife is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_chem_halflife>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Chem. Halflife">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "HALFLIFE,HALFLIFE_MEAN_OP,HALFLIFE_MEAN,HALFLIFE_MIN_OP,HALFLIFE_MIN,HALFLIFE_MAX_OP,HALFLIFE_MAX,HALFLIFE_TIME_UNIT">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Chemical Half Life">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_app_rate") and form.cb_app_rate is not "" and form.cb_app_rate is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_app_rate>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Appl. Rate">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "APP_RATE,APP_RATE_UNITS">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Application Rate">
	<cfset ofIndex = ofIndex + 1>
</cfif>
<cfif isdefined("form.cb_app_type") and form.cb_app_type is not "" and form.cb_app_type is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_app_type>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Appl. Type">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "APP_TYPE,APP_TYPE_DESC">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Application Type">
	<cfset ofIndex = ofIndex + 1>
</cfif>
    
<cfif isdefined("form.cb_trend_effect_pct") and form.cb_trend_effect_pct is not "" and form.cb_trend_effect_pct is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_trend_effect_pct>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Trend|Eff %">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "TREND,EFFECT_PCT,EFFECT_PCT_MEAN_OP,EFFECT_PCT_MEAN,EFFECT_PCT_MIN_OP,EFFECT_PCT_MIN,EFFECT_PCT_MAX_OP,EFFECT_PCT_MAX">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "TREND_DESC,EFFECT_PCT,EFFECT_PCT_MEAN_OP,EFFECT_PCT_MEAN,EFFECT_PCT_MIN_OP,EFFECT_PCT_MIN,EFFECT_PCT_MAX_OP,EFFECT_PCT_MAX">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Trend | Effect Percent">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_trend_effect_pct") and form.cb_trend_effect_pct is not "" and form.cb_trend_effect_pct is not 0>
<cfelse>
	<cfif isdefined("form.cb_trend") and form.cb_trend is not "" and form.cb_trend is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_trend>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Trend">
		<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "TREND">
		<cfelse>
			<cfset terrestrialOutputFields[#ofIndex#][3] = "TREND_DESC">
		</cfif>
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Trend">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cb_trend_effect_pct") and form.cb_trend_effect_pct is not "" and form.cb_trend_effect_pct is not 0>
<cfelse>
	<cfif isdefined("form.cb_effect_percent") and form.cb_effect_percent is not "" and form.cb_effect_percent is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_effect_percent>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Eff %">
		<cfset terrestrialOutputFields[#ofIndex#][3] = "EFFECT_PCT,EFFECT_PCT_MEAN_OP,EFFECT_PCT_MEAN,EFFECT_PCT_MIN_OP,EFFECT_PCT_MIN,EFFECT_PCT_MAX_OP,EFFECT_PCT_MAX">
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Effect Percent">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cb_ee_comment") and form.cb_ee_comment is not "" and form.cb_ee_comment is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_ee_comment>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "EE Comment">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "EECOMMENT">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "EE_Comment">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_ionic_fraction") and form.cb_ionic_fraction is not "" and form.cb_ionic_fraction is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_ionic_fraction>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Ion">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "ION1,ION2,ION3">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Ionic Fraction">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_observed_response") and form.cb_observed_response is not "" and form.cb_observed_response is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_observed_response>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Obs. Resp.">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "RESPONSE_MEAN_OP,OBSERV_RESPONSE_MEAN,RESPONSE_MIN_OP,OBSERV_RESPONSE_MIN,RESPONSE_MAX_OP,OBSERV_RESPONSE_MAX,RESULT_STAT_METHOD,OBSERV_RESPONSE_VALUE,OBSERV_RESPONSE_UNITS">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Observed Response">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_significance_level_significant") and form.cb_significance_level_significant is not "" and form.cb_significance_level_significant is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_significance_level_significant>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Signif.|Sig. Level">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "SIGNIFICANT,SIGNIFICANCE_LEVEL,SIGNIFICANCE_LEVEL_MEAN_OP,SIGNIFICANCE_LEVEL_MEAN,SIGNIFICANCE_LEVEL_MIN_OP,SIGNIFICANCE_LEVEL_MIN,SIGNIFICANCE_LEVEL_MAX_OP,SIGNIFICANCE_LEVEL_MAX">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "SIGNIFICANT_DESC,SIGNIFICANCE_LEVEL,SIGNIFICANCE_LEVEL_MEAN_OP,SIGNIFICANCE_LEVEL_MEAN,SIGNIFICANCE_LEVEL_MIN_OP,SIGNIFICANCE_LEVEL_MIN,SIGNIFICANCE_LEVEL_MAX_OP,SIGNIFICANCE_LEVEL_MAX">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Statistical Significance | Significance Level">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_significance_level") and form.cb_significance_level is not "" and form.cb_significance_level is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_significance_level>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Sig. Level">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "SIGNIFICANCE_LEVEL,SIGNIFICANCE_LEVEL_MEAN_OP,SIGNIFICANCE_LEVEL_MEAN,SIGNIFICANCE_LEVEL_MIN_OP,SIGNIFICANCE_LEVEL_MIN,SIGNIFICANCE_LEVEL_MAX_OP,SIGNIFICANCE_LEVEL_MAX">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Significance Level">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_significant") and form.cb_significant is not "" and form.cb_significant is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_significant>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Signif.">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
	<cfelse>
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][3] = "SIGNIFICANT,SIGNIFICANT_DESC">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Statistical Significance">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_exp_comment") and form.cb_exp_comment is not "" and form.cb_exp_comment is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_exp_comment>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Exposure Comments">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "EXPOSURE_REMARK">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Exposure Comments">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_endpoint_assignment") and form.cb_endpoint_assignment is not "" and form.cb_endpoint_assignment is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_endpoint_assignment>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Endpoint Assign.">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "ASSIGN">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "ASSIGN_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Endpoint Assignment">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_species_final_wt") and form.cb_species_final_wt is not "" and form.cb_species_final_wt is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_species_final_wt>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Org. Final Wt.">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "ORGANISM_FINAL_WT,organism_FINAL_wt_mean_op,organism_FINAL_wt_mean,organism_FINAL_wt_min_op,organism_FINAL_wt_min,organism_FINAL_wt_max_op,organism_FINAL_wt_max,organism_FINAL_wt_units">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Organism Final Weight">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_intake_rate") and form.cb_intake_rate is not "" and form.cb_intake_rate is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_intake_rate>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Intake Rate">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "INTAKE_RATE,INTAKE_RATE_MEAN_OP,INTAKE_RATE_MEAN,INTAKE_RATE_MIN_OP,INTAKE_RATE_MIN,INTAKE_RATE_MAX_OP,INTAKE_RATE_MAX,INTAKE_RATE_UNIT">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Intake Rate">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_result_pct_lipid") and form.cb_result_pct_lipid is not "" and form.cb_result_pct_lipid is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_result_pct_lipid>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Result % Lipd.">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "PERCENT_LIPID,LIPID_PCT_MEAN_OP,LIPID_PCT_MEAN,LIPID_PCT_MIN_OP,LIPID_PCT_MIN,LIPID_PCT_MAX_OP,LIPID_PCT_MAX">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Result Percent Lipid">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_media_meas") and form.cb_media_meas is not "" and form.cb_media_meas is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_media_meas>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Media Meas. Wet/Dry">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "WET_DRY">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Media Measurement">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_result_drywet") and form.cb_result_drywet is not "" and form.cb_result_drywet is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_result_drywet>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Result % Dry/Wet Wt.">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "DRY_WEIGHT_PERCENT,DRY_WET_PCT_MEAN_OP,DRY_WET_PCT_MEAN,DRY_WET_PCT_MIN_OP,DRY_WET_PCT_MIN,DRY_WET_PCT_MAX_OP,DRY_WET_PCT_MAX">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Result Percent Dry/Wet Weight">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_steady_state") and form.cb_steady_state is not "" and cb_steady_state is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_steady_state>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Steady State">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "STEADY_STATE">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Steady State">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_result_comm") and form.cb_result_comm is not "" and form.cb_result_comm is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_result_comm>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Result Comment">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "RESULT_REMARK">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Result Comment">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_temperature") and form.cb_temperature is not "" and form.cb_temperature is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_temperature>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Temp.">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "TEMPERATURE,TEMP_MEAN_VALUE_OP,TEMP_MEAN_VALUE,TEMP_MIN_VALUE_OP,TEMP_MIN_VALUE,TEMP_MAX_VALUE_OP,TEMP_MAX_VALUE,TEMP_UNITS">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Temperature">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_soil_type") and form.cb_soil_type is not "" and form.cb_soil_type is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_soil_type>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Soil Type">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "SUBSTRATE_DESC">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Soil Type">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_soil_sand_perc") and form.cb_soil_sand_perc is not "" and form.cb_soil_sand_perc is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_soil_sand_perc>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Soil Sand %">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "SOIL_TEXTURE_SA_MEAN_OP,SOIL_TEXTURE_SA_MEAN,SOIL_TEXTURE_SA_MIN_OP,SOIL_TEXTURE_SA_MIN,SOIL_TEXTURE_SA_MAX_OP,SOIL_TEXTURE_SA_MAX">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Soil Clay/Sand/Silt (Sand Percent)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_soil_silt_perc") and form.cb_soil_silt_perc is not "" and form.cb_soil_silt_perc is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_soil_silt_perc>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Soil Silt %">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "SOIL_TEXTURE_SI_MEAN_OP,SOIL_TEXTURE_SI_MEAN,SOIL_TEXTURE_SI_MIN_OP,SOIL_TEXTURE_SI_MIN,SOIL_TEXTURE_SI_MAX_OP,SOIL_TEXTURE_SI_MAX">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Soil Clay/Sand/Silt (Silt Percent)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_soil_clay") and form.cb_soil_clay is not "" and form.cb_soil_clay is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_soil_clay>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Soil Clay %">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "SOIL_TEXTURE_CL_MEAN_OP,SOIL_TEXTURE_CL_MEAN,SOIL_TEXTURE_CL_MIN_OP,SOIL_TEXTURE_CL_MIN,SOIL_TEXTURE_CL_MAX_OP,SOIL_TEXTURE_CL_MAX">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Soil Clay/Sand/Silt (Sand Percent)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_soil_cation") and form.cb_soil_cation is not "" and form.cb_soil_cation is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_soil_cation>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Media CEC">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "SOIL_CEC_MEAN_OP,SOIL_CEC_MEAN,SOIL_CEC_MIN_OP,SOIL_CEC_MIN,SOIL_CEC_MAX_OP,SOIL_CEC_MAX,SOIL_CEC_UNITS">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Media Cation Exchange Capacity">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_soil_ph") and form.cb_soil_ph is not "" and form.cb_soil_ph is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_soil_ph>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Soil pH">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "SOIL_PH_MEAN_OP,SOIL_PH_MEAN,SOIL_PH_MIN_OP,SOIL_PH_MIN,SOIL_PH_MAX_OP,SOIL_PH_MAX">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Soil pH">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_soil_organic") and form.cb_soil_organic is not "" and form.cb_soil_organic is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_soil_organic>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Media Orgnc. Mat.">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "SOIL_ORG_MEAN_OP,SOIL_ORG_MATTER_MEAN,SOIL_ORG_MIN_OP,SOIL_ORG_MATTER_MIN,SOIL_ORG_MAX_OP,SOIL_ORG_MATTER_MAX,SOIL_ORG_MATTER_UNITS,SOIL_ORG_MATTER_TYPE">
	<cfelse>
		<cfset terrestrialOutputFields[#ofIndex#][3] = "SOIL_ORG_MEAN_OP,SOIL_ORG_MATTER_MEAN,SOIL_ORG_MIN_OP,SOIL_ORG_MATTER_MIN,SOIL_ORG_MAX_OP,SOIL_ORG_MATTER_MAX,SOIL_ORG_MATTER_UNITS,SOIL_ORG_MATTER_TYPE_DESC">
	</cfif>
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Media Organic Matter and Type">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_soil_moisture") and form.cb_soil_moisture is not "" and form.cb_soil_moisture is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_soil_moisture>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Media Moist.">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "SOIL_MOISTURE_MEAN_OP,SOIL_MOISTURE_MEAN,SOIL_MOISTURE_MIN_OP,SOIL_MOISTURE_MIN,SOIL_MOISTURE_MAX_OP,SOIL_MOISTURE_MAX">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Media Moisture">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_soil_dose") and form.cb_soil_dose is not "" and form.cb_soil_dose is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_soil_dose>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Soil Dose Meas.">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "MEASURED">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Soil Dos Measured">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_general_comments") and form.cb_general_comments is not "" and form.cb_general_comments is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_general_comments>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Gen. Comment">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "GENERALCOMMENT">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "General Comment">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_reference_cit") and form.cb_reference_cit is not "" and form.cb_reference_cit is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_reference_cit>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Ref. Citation">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "AUTHOR,REFERENCE_NUMBER,TITLE,SOURCE,PUBLICATION_YEAR,FULL_CITATION">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW,VW,VW,VW,VW,VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Reference Citation">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_reference_cit") and form.cb_reference_cit is not "" and form.cb_reference_cit is not 0>
<cfelse>
	<cfif isdefined("form.cb_reference_num") and form.cb_reference_num is not "" and form.cb_reference_num is not 0>
		<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_reference_num>
		<cfset terrestrialOutputFields[#ofIndex#][2] = "Ref##">
		<cfset terrestrialOutputFields[#ofIndex#][3] = "REFERENCE_NUMBER">
		<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
		<cfset terrestrialOutputFields[#ofIndex#][5] = "Reference Number">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cb_author") and form.cb_author is not "" and form.cb_author is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_author>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Author">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "AUTHOR">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Author">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cb_pub_year") and form.cb_pub_year is not "" and form.cb_pub_year is not 0>
	<cfset terrestrialOutputFields[#ofIndex#][1] = FORM.cb_pub_year>
	<cfset terrestrialOutputFields[#ofIndex#][2] = "Pub. Year">
	<cfset terrestrialOutputFields[#ofIndex#][3] = "PUBLICATION_YEAR">
	<cfset terrestrialOutputFields[#ofIndex#][4] = "VW">
	<cfset terrestrialOutputFields[#ofIndex#][5] = "Publication Year">
	<cfset ofIndex = ofIndex + 1>
</cfif>
