
<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<cfset long_description_map = {
        "ACC": "Process by which chemicals are taken into and stored in the organism. Includes lethal body burden.  The Unspecified (NER) group is for an author reported an endpoint without a specific effect.  This term only exists on Reference number 344.",
        "BEH": "Activity of an organism in response to a stimulus.  The Avoidance (AVO) subgroup contains measures of avoidance or attraction.  The Feeding Behavior (FDB) subgroup contains measures related to food and consumption and acquisition.  The Behavior (BEH) subgroup contains the remaining behavioral measurements.  All measurements related to reproductive behavior are contained in the Reproduction effect group.",
        "BCM": "Biotransformation or metabolism of chemical compounds, modes of toxic action, and biochemical organism responses. The Enzyme(s) (ENZ) subgroup contains measurements of enzymes and enzyme related activity.  The Hormone(s) (HRM) subgroup contains measurements of hormones and hormone related activity, and the Biochemistry (BCM) subgroup is comprised of the remaining biochemical measurements including protein levels and expression.",
        "CEL": "Changes in structure and chemical composition of cells and tissues in organisms. The Genetics (GEN) subgroup contains measurements of gene expression and damage.  The Histology (HIS) subgroup focuses on measurements related to structural changes and the Cell(s) (CEL) subgroup contains the remaining cell and tissue measurements.",
        "GRO": "Encompasses individual organism weight, length, development, and morphology. The Development (DVP) subgroup includes indicators of development as well as growth measurements during developmental life stages.  The Morphology (MPH) subgroup contains measurements of the structure and form of organism parts and the Growth (GRO) subgroup contains measurements of entire organisms at any point in its life cycle.",
        "MOR": "Death of individuals or measurements that indicate death.",
        "PHY": "Encompasses cell, tissue, and whole-body processes and functions. The Injury (INJ) subgroup contains measurements related to damage. The Immunological (IMM) subgroup contains disease and disorder measurements. The Intoxication (ITX) subgroup contains indicators of intoxication, and the Physiology (PHY) subgroup contains the remaining cell, tissue, and whole-body process and function measurements.",
        "POP": "Measurements related to the quantification of the number of individuals occupying the same area at a given time.",
        "REP": "Measurements related to the reproductive cycle including reproductive behaviors, offspring count, and reproductive physiology.  Offspring development effects are captured in the Development (DVP) subgroup.",
        "SYS": "Ecosystem processes (PRS) include community structure and function. Includes microbial processes.",
        "MLT": "Change in more than one effect when data were reported as one result.",
        "NA": "",
        "NER": "The author reported an endpoint, but not a specific effect. This effect only exists on a dataset reference - EcoRef 344."
    }
>
    
<!---    

    EXPECTED VARIABLES FROM DB/DATA TEMPLATE:

        AppendixCodesQuery - a coldfusion query object with this name.

    EXPECTED VARIABLES FROM HANDLER:

        OUTPUTFORMAT - JSON for web, CSV, EXCEL (possibly others in future) for exports

--->
    
<cfset columnDefs = arrayNew(2)>
    
<cfset col1Array = arrayNew(1)>
<cfset ArrayAppend(col1Array, "GROUP/EFFECT TERM(S)")>
<cfset ArrayAppend(col1Array, "ec.code")>
<cfset ArrayAppend(columnDefs, col1Array)>
    
<cfset col2Array = arrayNew(1)>
<cfset ArrayAppend(col2Array, "DESCRIPTION")>
<cfset ArrayAppend(col2Array, "ec.description")>
<cfset ArrayAppend(columnDefs, col2Array)>
    
<cfset col3Array = arrayNew(1)>
<cfset ArrayAppend(col3Array, "DEFINITION")>
<cfset ArrayAppend(col3Array, "ec.code")>
<cfset ArrayAppend(columnDefs, col3Array)>
       
       
<cfset group_effect_map = structNew()>
<cfset current_effect_group = "">
        
<cfloop query="AppendixCodesQuery">
    <cfset this_effect_group = AppendixCodesQuery.THISGROUPCODE>
        
    <cfif this_effect_group EQ current_effect_group>
        <cfset current_pair = group_effect_map[current_effect_group]>        
        <cfset current_pair[1] = current_pair[1] & ", " & AppendixCodesQuery.THISCODE>
        <cfset current_pair[2] = current_pair[2] & ", " & AppendixCodesQuery.THISDESC>
    <cfelse>
        <cfset current_effect_group = this_effect_group>
     
        <cfset current_pair = arrayNew(1)>
        <cfset current_pair[1] = AppendixCodesQuery.THISGROUPCODE & "/" & AppendixCodesQuery.THISCODE>
        <cfset current_pair[2] = AppendixCodesQuery.THISGROUPDESC & "/" & AppendixCodesQuery.THISDESC>
    </cfif>

    <cfset group_effect_map[current_effect_group] = current_pair>
</cfloop>

    
<cfset keyArray = StructKeyArray(group_effect_map)>
<cfset ArraySort(keyArray, "text", "asc")>                          <!--- how to handle sorting??? --->       

<cfif URL.export EQ "1">
    <cfset rowCount = "">
<cfelse>
    <cfset rowCount = ARRAYLEN(keyArray)>
</cfif>
    
<cfif rowCount eq "">
    <cfset rowCount = 0>
</cfif>
        
<cfset resultsArray = arrayNew(2)>    
<cfloop array="#keyArray#" index="outerGroupKey">
    <cfset rowData = arrayNew(1)>        
    <cfset current_pair = group_effect_map[outerGroupKey]>

    <cfset group_definition = "">
    <cfif StructKeyExists(long_description_map, "#outerGroupKey#")>
        <cfset group_definition = long_description_map[outerGroupKey]>
    </cfif>
           
    <cfset col1Str = current_pair[1]>
    <cfset col1Str = OutFunc.cleanStringForDataTable(col1Str, OUTPUTFORMAT)>
    <cfset ArrayAppend(rowData, col1Str)>

    <cfset col2Str = current_pair[2]>
    <cfset col2Str = OutFunc.cleanStringForDataTable(col2Str, OUTPUTFORMAT)> 
    <cfset ArrayAppend(rowData, col2Str)>
           
    <cfset col3Str = OutFunc.cleanStringForDataTable(group_definition, OUTPUTFORMAT)>
    <cfset ArrayAppend(rowData, col3Str)>
           
    <cfset ArrayAppend(resultsArray, rowData)>
               
</cfloop>

<cfinclude template="output_router.cfm">