

<cfset SORTFIELD = "ec.group_code, ec.code">

<cfif isDefined("URL.searchstr") AND URL.searchstr NEQ "">
    <cfset whereClauseValue = LCase(URL.searchstr)>
<cfelse>
    <cfset whereClauseValue = "">
</cfif>


<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="AppendixCodesQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="AppendixCodesQueryVars">
        
        SELECT
            ec.code as THISCODE,
            ec.description as THISDESC,
            ec.group_code as THISGROUPCODE,
            ec.group_description as THISGROUPDESC
        FROM effect_codes ec
        WHERE NOT ec.code like '~%'
        AND NOT ec.group_code = 'NA'
            
        <cfif whereClauseValue NEQ "">
            AND (
                lower(ec.code) like <CFQUERYPARAM VALUE="%#whereClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">
                OR lower(ec.description) like <CFQUERYPARAM VALUE="%#whereClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">
                OR lower(ec.group_code) like <CFQUERYPARAM VALUE="%#whereClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">
                OR lower(ec.group_description) like <CFQUERYPARAM VALUE="%#whereClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">
            )
        </cfif>
        
        ORDER BY #SORTFIELD#

    </cfquery>
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>


	
