
<!--- SEARCH --->

<cfif isDefined("URL.searchstr") AND URL.searchstr NEQ "">
    <cfset filteredResults = arrayNew(2)>
        
    <cfloop array="#results#" index="row">
        <cfset found = false>
        <cfloop array="#row#" index="value">
            <cfif findnocase(URL.searchstr, value) GT 0>
                <cfset found = true>
            </cfif>
        </cfloop>
            
        <cfif found>
            <cfset ArrayAppend(filteredResults, row)>
        </cfif>
    </cfloop>
        
    <cfset results = filteredResults>
    <cfset rowCount = ArrayLen(results)>
</cfif>


<!--- SORTING --->

<cfset defaultSortOrder = "1">
<cfloop index="i" from="2" to="#ArrayLen(columnNames)#">
    <cfset defaultSortOrder = defaultSortOrder & "," & i>
</cfloop>

<cfif SORTFIELD EQ "">
    <cfset SORTFIELD = defaultSortOrder>
    <cfset sortDir = "asc">
<cfelse>
    <cfset sortArray = ListToArray(SORTFIELD, " ")>
    <cfset SORTFIELD = sortArray[1]>
    <cfif ArrayLen(sortArray) GT 1>
        <cfset sortDir = sortArray[2]>
    <cfelse>
        <cfset sortDir = "asc">
    </cfif>
    
    <cfset SORTFIELD = SORTFIELD & "," & defaultSortOrder>
    <cfset SORTFIELD = listRemoveDuplicates(SORTFIELD)>
</cfif>

<cfset sortedResults = arrayNew(2)>
<cfset resultsStruct = structNew()>
        
<cfset i = 1>
<cfloop array="#results#" index="row">
    <cfset newStructKey = "">
        
    <cfloop list="#SORTFIELD#" index="colNum">
        <cfset newStructKey = newStructKey & "#row[colNum]#-">
    </cfloop>
    <cfset newStructKey = newStructKey & "#i#">
        
    <cfset resultsStruct[newStructKey] = row>           
    <cfset i = i + 1>
</cfloop>

<cfset keyArray = StructKeyArray(resultsStruct)>   
<cfset ArraySort(keyArray, "textNoCase", "#sortDir#")>
    
<cfloop array="#keyArray#" index="idx">
    <cfset row = resultsStruct[idx]>
    <cfset ArrayAppend(sortedResults, row)>
</cfloop>

<cfset results = sortedResults>
    
    
<!--- PAGING --->

<cfif URL.export NEQ "1">
    <cfif PAGESIZE GT ArrayLen(results)>
        <cfset STARTPOS = 0>
        <cfset PAGESIZE = ArrayLen(results)>
    </cfif>

    <cfset pagedResults = arrayNew(2)>
    <cfloop array="#results#" item="row" index="i"> 
        <cfif (i GT STARTPOS) AND (i LTE (STARTPOS + PAGESIZE))>
            <cfset ArrayAppend(pagedResults, row)>
        </cfif>
    </cfloop>

    <cfset results = pagedResults>
</cfif>
    
