
<cfset ParamFunc = CreateObject("component", "cfc.searchparam_functions")>
<cfset effectsMeasurementsArray = ParamFunc.effectsMeasurementsArray>

<div id="effectsParamsSidebar" class="secondary-sidebar off-canvas-absolute position-left" data-off-canvas data-transition="overlap" data-search-param="Effects">
  <h2 class="header"><button data-toggle="effectsParamsSidebar">
    <svg class="icon arrow" width="12" height="12"><use xlink:href="#chevron-left"></use></svg>
    Effect Measurements</button></h2>

  <button class="button warning reset-all">Reset</button>

  <p class="form-error no-params">You must input or check at least one option.</p>

  <form action="" class="search" data-searchparam>
    <div class="input-group prepend append mt0 mb0" tabindex="0">
      <textarea id="txAdvancedEffectEntries" rows="1" class="input-group-field auto-height" placeholder="Effect(s) (eg. food, vitellogenin, acetylcholine)" name="txAdvancedEffectEntries"></textarea>
      <label class="input-group-label" for="txAdvancedEffectEntries">
        <span class="show-for-sr">Search:</span>
        <svg class="icon" width="24" height="24"><use xlink:href="#search"></use></svg></label>
      <a href="help.cfm?sub=hd-parameters#parameters-results" target="_blank" class="input-group-button button help" title="Effects text search help"><svg class="icon" width="16" height="16" alt="Help"><use xlink:href="#question-circle"></use></svg></a>	  
    </div>
	
	<div class="row card mt0 pl2">
	  <div class="columns medium-4">
		<input type="radio" name="RBEFFECTSEARCHTYPE" value="CONTAINS" id="RBEFFECTSEARCHTYPE_C" checked="checked">
		<label for="RBEFFECTSEARCHTYPE_C">Contains</label>
	  </div>
	  <div class="columns medium-8">
		<input type="radio" name="RBEFFECTSEARCHTYPE" value="EXACT" id="RBEFFECTSEARCHTYPE_E">
		<label for="RBEFFECTSEARCHTYPE_E">Exact Match</label>
	  </div>
	</div>
	
    <p class="help-text">Enter each effect measurement on separate lines. <u>NOTE:</u> This filter will attempt to use ALL Ecotox values that match the search term.</p>
  </form>

  <form action="" data-searchparam>
    <fieldset class="card">
      <input type="checkbox" name="cbExcludePostExpMeas" id="cbExcludePostExpMeas" value="EXCLUDEPOSTEXPMEAS" class="optional">
      <label for="cbExcludePostExpMeas">Exclude Post-exposure Measurements&nbsp;&nbsp;<a href="help.cfm?sub=faq#faq-display" target="_blank" title="Post-exposure Measurements help"><svg class="icon" width="16" height="16" alt="Help"><use xlink:href="#question-circle"></use></svg></a></label>
    </fieldset>
  </form>

  <form id="effectsgroups" data-searchparam data-mod-entries-effectsgroups>
    <input class="select-all" id="ckAllEffectMeasurements" name="ckAllEffectMeasurements" type="checkbox" checked>
    <label class="select-all" for="ckAllEffectMeasurements">Any Effect Group</label>

    <fieldset>
      <ul class="no-bullet grouped with-headings column medium-6">
        <cfloop index="inputItem" array="#effectsMeasurementsArray#">
          <cfoutput>

            <cfset inputSubGroupArray = "">
            <cfset effectsMeasurementIndex = 0>
      			<cfset outputOneOnly = 0>

            <cfif IsArray(inputItem)>
              <cfset inputSubGroupArray = inputItem[2]>
              <cfset inputItem = inputItem[1]>

      			  <cfif inputItem eq "">
      				  <cfset inputItem = inputSubGroupArray[1]>
      				  <cfset outputOneOnly = 1>
      			  </cfif>
            <cfelse>
      			  <cfset outputOneOnly = 1>
            </cfif>

      			<cfset effectsMeasurementIndex = listGetAt(inputItem,1)>

    		    <cfif outputOneOnly eq 1>

      			  <cfset inputName = "ResultsGroup" & listGetAt(inputItem,1)>
      			  <cfset inputText = listGetAt(inputItem,2)>
      			  <cfset inputValue = listGetAt(inputItem,3)>

      			  <li>
        				<input id="cb#inputName#" name="cb#inputName#" value="#inputValue#" type="checkbox" checked>
        				<label for="cb#inputName#">#inputText#</label>
      			  </li>

      			<cfelse>

      			  <cfset inputName = "ResultsGroup" & listGetAt(inputItem,1)>
      			  <cfset inputText = listGetAt(inputItem,2)>
      			  <cfset inputValue = listGetAt(inputItem,3)>

      			  <li>
        				<input id="cb#inputName#" name="cb#inputName#" value="#inputValue#" type="checkbox" class="sub-select-all" checked>
        				<label for="cb#inputName#">#inputText#</label>

        				<ul class="no-bullet ml3">
        				  <cfloop index="inputSubGroupItem" array="#inputSubGroupArray#">

        					<cfset inputSubName = "ResultsGroup" & listGetAt(inputSubGroupItem,1)>
        					<cfset inputSubText = listGetAt(inputSubGroupItem,2)>
        					<cfset inputSubValue = listGetAt(inputSubGroupItem,3)>

        					<li>
        					  <input id="cb#inputSubName#" name="cb#inputSubName#" value="#inputSubValue#" type="checkbox" checked>
        					  <label for="cb#inputSubName#">#inputSubText#</label>
        					</li>
        				  </cfloop>
        				</ul>
      			  </li>

      			</cfif>

            <cfif effectsMeasurementIndex EQ 10>
              </ul>
              <ul class="no-bullet grouped with-headings column medium-6">
            </cfif>
          </cfoutput>
        </cfloop>
      </ul>
    </fieldset>

    <!--- View/Edit Effect Measurements - populated by subform --->
    <input class="hide" aria-hidden="true" type="hidden" id="measSelections" name="measSelections" value="">

    <a data-open="effectsEntriesModal" data-open-exclusions class="button centered">View/Modify Entries for Selected Effect Measurement(s)</a>
  </form>
</div>


<div class="reveal modify-entries" id="effectsEntriesModal" data-reveal data-close-on-click="false">
  <h2>View/Modify Entries for Selected Group(s)</h2>
  <button class="close-button" data-close aria-label="Close modal" type="button">
    <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
  </button>
  <p>The selection box below contains the expanded Measurements associated with the Effects you selected. To remove individual Measurements from your query, uncheck the box in the appropriate row.</p>
  <p>When you have completed your selections, click on the <strong>Save Modifications</strong> button.</p>

  <form id="effectsModal" class="content"></form>

  <div class="reveal-footer">
    <button class="button secondary float-left" data-reset-exclusions="effectsEntriesModal">Restore All</button>
    <button class="button secondary float-left" data-clear-exclusions="effectsEntriesModal">Clear All</button>
    <button class="button cancel" data-close>Cancel</button>
    <button class="button success" data-close data-save-exclusions="effectsEntriesModal">Save Modifications</button>
  </div>
</div>
