/*
 * Decompiled with CFR 0.152.
 */
package com.compoundtheory.coldfusion.cfc.spring;

import com.compoundtheory.coldfusion.cfc.CFCDynamicProxy;
import java.io.File;
import java.io.IOException;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColdFusionComponentFactory
implements ScriptFactory {
    private Class<?>[] interfaces;
    private String scriptSourceLocator;

    public ColdFusionComponentFactory(String scriptSourceLocator, Class<?>[] interfaces) {
        Assert.hasText((String)scriptSourceLocator, (String)"'scriptSourceLocator' must not be empty");
        Assert.notEmpty((Object[])interfaces, (String)"'scriptInterfaces' must not be empty");
        this.setScriptInterfaces(interfaces);
        this.setScriptSourceLocator(scriptSourceLocator);
    }

    public Object getScriptedObject(ScriptSource scriptSource, Class[] actualInterfaces) throws IOException, ScriptCompilationException {
        try {
            File file = ResourceUtils.getFile((String)this.getScriptSourceLocator());
            return CFCDynamicProxy.createInstance((File)file, (Class[])actualInterfaces);
        }
        catch (Throwable e) {
            ScriptCompilationException sce = new ScriptCompilationException(scriptSource, e);
            throw sce;
        }
    }

    public Class<?> getScriptedObjectType(ScriptSource scriptSource) throws IOException, ScriptCompilationException {
        return null;
    }

    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    private void setScriptSourceLocator(String scriptSourceLocator) {
        this.scriptSourceLocator = scriptSourceLocator;
    }

    public boolean requiresConfigInterface() {
        return true;
    }

    public boolean requiresScriptedObjectRefresh(ScriptSource scriptSource) {
        return scriptSource.isModified();
    }

    public Class<?>[] getScriptInterfaces() {
        return this.interfaces;
    }

    private void setScriptInterfaces(Class<?>[] interfaces) {
        this.interfaces = interfaces;
    }

    public String toString() {
        return "ColdFusionComponentFactory: script source locator [" + this.scriptSourceLocator + "]";
    }
}

