
<cfcomponent>

    <!--- Set application name and do not enable client cookies--->
    <cfset this.name="ecotox-new-20251205-2">
    <cfset this.clientManagement=false>
    <cfset this.sessionManagement=true>
    <cfset this.setClientCookies=false>
    <cfset this.setDomainCookies=false>
    <cfset this.rootpath = getDirectoryFromPath(getCurrentTemplatePath()) >
    <cfset this.mappings = structNew() />
    <cfset this.mappings[ "/cfc" ] =  "#this.rootpath#/cfc/" >
    <cfset this.mappings[ "/lucee_ss" ] =  "#this.rootpath#/lib/lucee-spreadsheet-main/" >
    <cfset this.scriptProtect = "all">

    <!---<cfset this.javaSettings = { loadPaths = ["#this.rootpath#/lib/lucee-spreadsheet-main/lib"] }>--->


    <!---<cfset Application.javaloader = createObject("component", "lucee_ss.javaLoader.JavaLoader").init( sourceDirectories = ["#this.rootpath#/lib/lucee-spreadsheet-main/lib"] )>--->


    <cfsetting requesttimeout="180">


    <cffunction name="onApplicationStart" returnType="boolean" output="false">

        <cflog text='Application starting up...'>

        <cfset internalOnly = 0>
        <cfif cgi.server_name eq "localhost" or cgi.server_name eq "q2626xmnay001.aa.ad.epa.gov" or cgi.server_name eq "q2626xmnay002.aa.ad.epa.gov">
            <cfset internalOnly = 1>
        <cfelse>
            <cfset internalOnly = 0>
        </cfif>

        <cfset Application.internalOnly = internalOnly>

        <!--- Set application-specific constants. --->

        <cfif findNoCase("cfpstage", cgi.server_name) eq 1><!--- OR cgi.server_name eq "localhost"--->
            <cfset qstr = cgi.query_string>
            <cfif FindNoCase("fulldb", qstr) GT 0>
                <cfset Application.Datasource = "ecotox_new"<!---regular database--->>
            <cfelse>
                <cfset Application.Datasource = "ecotox_new_scan"<!---"ecotox_small"--->>
            </cfif>
        <cfelse>
            <cfset Application.Datasource = "ecotox_new">
        </cfif>	

        <!--- Maximum number of records to be displayed--->
        <cfset Application.RecordMax = 10000>
        <cfset Application.ExploreRecordMax = 3000>

        <cfset Application.basepath = getDirectoryFromPath(getCurrentTemplatePath()) >
        <cfset Application.SiteName = "ECOTOX Knowledgebase v5">


        <!--- load the entire latest quarterly update record from ECOTOX_CONFIG here --->
        <!--- default mode is 'latest' config, forces get of most recent update --->
        <cfset configFunc = CreateObject("component", "cfc.config_functions")>

        <cfinclude template="data/config_handler.cfm">
        <cfset Application.currentUpdate = StructCopy(latestConfig)>

        <cfset URL.mode = "updateDates">
        <cfinclude template="data/config_handler.cfm">
        <cfset Application.updateDateList = dateList>

        <cfset Application.pubDateAry = configFunc.convertDatesToDbFormat("#Application.updateDateList#", "|")>


        <cfreturn true>
    </cffunction>


    <cffunction name="onRequestStart" returnType="boolean" output="false">

            <!---
                NOTE: scriptProtect should handle bad tags.  wrote new function to check for bad parameters

            <CF_INPUTFILTER scopes="FORM,COOKIE,URL"
                    chars=";,<,>,$,&,`,\,!"
                    tags="script,embed,applet,object">
            --->


        <cfset cleanInputs = CreateObject("component", "cfc.input_sanitize")>
        <cfset success = cleanInputs.runInputValidation()>


        <cfreturn success>
    </cffunction>


    <cffunction name="onRequestEnd">
        <cfscript>
            if(structKeyExists(URL, "appReset")) {
                
                WriteLog(type="Warning", text="Application reset triggered by URL.");
                ApplicationStop();

            }
        </cfscript>
    </cffunction>

</cfcomponent>
