<cfcomponent>
  <cfscript>
  
	function findInArray( thisArray, valueToFind, ignoreCase ) {
	  var foundItem = 0;
	  for( i = 1; i lte ArrayLen(thisArray) && foundItem eq 0; i++ ) {
		if(ignoreCase) {
		  if(UCase(valueToFind) eq UCase(thisArray[i])) {
		    foundItem = 1;
		  }
		}
	    else if(valueToFind eq thisArray[i]) {
		  foundItem = 1;
	    }
	  }
	  return foundItem;
	}
	
	function undefinedValueCheck( field, replacementStr ) {
	  var retval = field;
	  if( NOT isDefined(field) ) {
		retval = replacementStr;
	  }
	  return retval;
	}

	function splitListToSublists( srcList, sizeOfSublist ) {
		var arrayOfSublists = ArrayNew(1);
		var listArray = ListToArray(srcList);
		var currentSublist = "";

		for (i = 1; i LTE arrayLen(listArray); i++) {
			if (ListLen(currentSublist) LT sizeOfSublist AND i NEQ ArrayLen(listArray)) {
				currentSublist = ListAppend(currentSublist, listArray[i]);
			}
			else if (ListLen(currentSublist) eq sizeOfSublist OR i EQ arrayLen(listArray)) {
				if (i EQ arrayLen(listArray)) {
					currentSublist = ListAppend(currentSublist, listArray[i]);
				}
				
				ArrayAppend(arrayOfSublists, currentSublist);
				
				currentSublist = "";
				currentSublist = ListAppend(currentSublist, listArray[i]);
			}
		}
		return arrayOfSublists;
	}
 
  </cfscript>
</cfcomponent>