<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="BrowseCountQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="BrowseCountQueryVars">

        SELECT 
            count(distinct f.reference_number) as ref_count
        FROM
            references f
            LEFT JOIN tests t ON t.ecoref_number = f.reference_number
            LEFT JOIN species s ON s.species_number = t.species_number
            LEFT JOIN species_list_xref sx ON sx.species_number = s.species_number
            LEFT JOIN results r ON r.test_id_fk = t.test_id
        WHERE (
            1=1            
            --if chemical entry
            <cfif len(trim(caslist))>
                <cfif ListLen(trim(caslist)) LTE 1000>
                    AND t.test_cas IN (<CFQUERYPARAM VALUE="#caslist#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                <cfelse>
                    <cfset arrayOfLists = GenFunc.splitListToSublists(trim(caslist), 1000)>
                    <cfif ArrayLen(arrayOfLists) GTE 1>
                    AND (
                        <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                            <cfset thisSubList = arrayOfLists[i]>
                            <cfif i GT 1> OR </cfif>                            
                            t.test_cas IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                        </cfloop>
                    )
                    </cfif>
                </cfif>
            </cfif>
            --if species entry
            <cfif len(trim(specNumbers))>
                AND t.species_number IN (<CFQUERYPARAM VALUE="#specNumbers#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            </cfif>
            --if species group
            <cfif len(trim(specGroups))>
                AND sx.species_listid IN (<CFQUERYPARAM VALUE="#specGroups#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            </cfif>                
            --if tax class entry
            <cfif len(trim(taxClasses))>
                AND s.class in (<CFQUERYPARAM VALUE="#taxClasses#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
            </cfif>
            --if effects group entry
            <cfif len(trim(effGroups))>
                AND (REPLACE(REPLACE(r.effect, '~', ''), '/', '') IN (<CFQUERYPARAM VALUE="#effGroups#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">))
            </cfif>
            --if effects entry
            <cfif len(trim(effMeasPairs))>
                AND (
                <cfset pairCount = 0>
                <cfloop index=pair list="#effMeasPairs#" delimiters=",">
                    <cfset trimmedVal = trim(pair)>
                    <cfset effCode = ListGetAt(trimmedVal, 1, "|")>
                    <cfset measCode = ListGetAt(trimmedVal, 2, "|")>

                    <cfif len(trim(effCode)) AND len(trim(measCode))>
                        <cfif pairCount GT 0> OR </cfif>
                        (REPLACE(REPLACE(r.effect, '~', ''), '/', '') = <CFQUERYPARAM VALUE="#effCode#" CFSQLTYPE="CF_SQL_VARCHAR"> AND REPLACE(REPLACE(r.measurement, '~', ''), '/', '') = <CFQUERYPARAM VALUE="#measCode#" CFSQLTYPE="CF_SQL_VARCHAR">)
                        <cfset pairCount = pairCount + 1>
                    </cfif>
                </cfloop>
                )
            </cfif>
            --if author entry
            <cfif len(trim(refNums_a))>
                AND f.reference_number in (<CFQUERYPARAM VALUE="#refNums_a#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            </cfif>
            --if title entry
            <cfif len(trim(refNums_t))>
                AND f.reference_number in (<CFQUERYPARAM VALUE="#refNums_t#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            </cfif>
            --if ecoref from browse entry
            <cfif len(trim(refNums_rn))>
                AND f.reference_number in (<CFQUERYPARAM VALUE="#refNums_rn#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            </cfif>
            --if doi entry
            <cfif len(trim(refNums_d))>
                AND f.reference_number in (<CFQUERYPARAM VALUE="#refNums_d#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            </cfif>
            --if citation entry
            <cfif len(trim(refNums_cit))>
                AND f.reference_number in (<CFQUERYPARAM VALUE="#refNums_cit#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            </cfif>
            --if list of ecoref numbers specifically            
            <cfif len(trim(ecorefList))>
                <cfif ListLen(trim(ecorefList)) LTE 1000>
                    AND f.reference_number IN (<CFQUERYPARAM VALUE="#ecorefList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                <cfelse>
                    <cfset arrayOfLists = GenFunc.splitListToSublists(trim(ecorefList), 1000)>
                    <cfif ArrayLen(arrayOfLists) GTE 1>
                    AND (
                        <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                            <cfset thisSubList = arrayOfLists[i]>
                            <cfif i GT 1> OR </cfif>                            
                            f.reference_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                        </cfloop>
                    )
                    </cfif>
                </cfif>
            </cfif>
        )

    </cfquery>
    
<!---      <cflog text ="#BrowseCountQueryVars.sql#">  --->
<!---      <cflog text ="#ArrayToList(BrowseCountQueryVars.sqlparameters)#">  --->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>
