
<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<!--- TODO: error handling when we determine process flow
<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>
--->

<!---
    construct csv output
    export data from query_chart_data.cfm
    we want to use the query object (DetailQuery), not the formatted json
--->
        
<cfset outputFormat = "CSV">
    
<CFHEADER NAME="Content-Disposition" VALUE="attachment; filename=ECOTOX-explore-data_#RUN_TS#.csv">
<CFCONTENT TYPE="text/plain">
  
<cfprocessingdirective suppressWhiteSpace = "Yes">

<cfoutput>"Test_Num","CAS_Num","Chemical_Name","Species_Group","Species_Name","Common_Name","Class","Order","Family","Genus","Effect","Measurement","Endpoint","Duration_Std","Conc_Type","Conc_Mean_Std","Conc_Units_Std","Pub_Year","Ecoref_Num","Citation"#chr(13)##chr(10)#</cfoutput>

<cfloop query="DetailQuery">
    <cfset recordArray = "">

    <cfset q_test_id = OutFunc.cleanStringForDataTable(DetailQuery.test_id, outputFormat)>
    <cfset q_cas_number = OutFunc.cleanStringForDataTable(DetailQuery.cas_number, outputFormat)>
    <cfset q_epa_chem_substance_name = OutFunc.cleanStringForDataTable(DetailQuery.epa_chem_substance_name, outputFormat)>
    <cfset q_species_group = OutFunc.cleanStringForDataTable(DetailQuery.species_group, outputFormat)>
    <cfset q_latin_name = OutFunc.cleanStringForDataTable(DetailQuery.latin_name, outputFormat)>
    <cfset q_common_name = OutFunc.cleanStringForDataTable(DetailQuery.common_name, outputFormat)>
    <cfset q_class = OutFunc.cleanStringForDataTable(DetailQuery.class, outputFormat)>
    <cfset q_tax_order = OutFunc.cleanStringForDataTable(DetailQuery.tax_order, outputFormat)>
    <cfset q_family = OutFunc.cleanStringForDataTable(DetailQuery.family, outputFormat)>
    <cfset q_genus = OutFunc.cleanStringForDataTable(DetailQuery.genus, outputFormat)>
    <cfset q_effect_desc = OutFunc.cleanStringForDataTable(DetailQuery.effect_desc, outputFormat)>
    <cfset q_measurement_desc = OutFunc.cleanStringForDataTable(DetailQuery.measurement_desc, outputFormat)>
    <cfset q_endpoint = OutFunc.cleanStringForDataTable(DetailQuery.endpoint, outputFormat)>

    <cfset obs_duration_std_clean = OutFunc.strReplace( DetailQuery.obs_duration_std, "Not coded", "" )>
    <cfset obs_duration_std_clean = OutFunc.strReplace( obs_duration_std_clean, "Not Extracted", "" )>
    
    <cfset conc1_type_desc_clean = OutFunc.strReplace( DetailQuery.conc1_type_desc, "Not coded", "" )>
    <cfset conc1_type_desc_clean = OutFunc.strReplace( conc1_type_desc_clean, "Not Extracted", "" )>  
           
    <cfset cleanConc_clean = OutFunc.strReplace( DetailQuery.cleanConc, "Not coded", "" )>
    <cfset cleanConc_clean = OutFunc.strReplace( cleanConc_clean, "Not Extracted", "" )>  
           
    <cfset conc_units_std_clean = OutFunc.strReplace( DetailQuery.conc_units_std, "Not coded", "" )>
    <cfset conc_units_std_clean = OutFunc.strReplace( conc_units_std_clean, "Not Extracted", "" )>           
                 
    <cfset qPub_year = OutFunc.cleanStringForDataTable(DetailQuery.publication_year, outputFormat)>
    <cfset qRef_num = OutFunc.cleanStringForDataTable(DetailQuery.ecoref_number, outputFormat)>
    <cfset fullCitation = OutFunc.cleanStringForDataTable(DetailQuery.inner_citation, outputFormat)>

    <cfset recordArray = listAppend(recordArray,'#q_test_id#')>
    <cfset recordArray = listAppend(recordArray,'#q_cas_number#')>
    <cfset recordArray = listAppend(recordArray,'#q_epa_chem_substance_name#')>
    <cfset recordArray = listAppend(recordArray,'#q_species_group#')>
    <cfset recordArray = listAppend(recordArray,'#q_latin_name#')>
    <cfset recordArray = listAppend(recordArray,'#q_common_name#')>
    <cfset recordArray = listAppend(recordArray,'#q_class#')>
    <cfset recordArray = listAppend(recordArray,'#q_tax_order#')>
    <cfset recordArray = listAppend(recordArray,'#q_family#')>
    <cfset recordArray = listAppend(recordArray,'#q_genus#')>
    <cfset recordArray = listAppend(recordArray,'#q_effect_desc#')>
    <cfset recordArray = listAppend(recordArray,'#q_measurement_desc#')>
    <cfset recordArray = listAppend(recordArray,'#q_endpoint#')>
    <cfset recordArray = listAppend(recordArray,'#obs_duration_std_clean#')>
    <cfset recordArray = listAppend(recordArray,'#conc1_type_desc_clean#')>
    <cfset recordArray = listAppend(recordArray,'#cleanConc_clean#')>
    <cfset recordArray = listAppend(recordArray,'#conc_units_std_clean#')>
    <cfset recordArray = listAppend(recordArray,'#qPub_year#')>
    <cfset recordArray = listAppend(recordArray,'#qRef_num#')>
    <cfset recordArray = listAppend(recordArray,'#fullCitation#')>
        
    <cfoutput>#recordArray##chr(13)##chr(10)#</cfoutput>
</cfloop>
</cfprocessingdirective>