<!---
 * =================================================================================================
 *                           ADVANCED SEARCH ADVANCED CHEMICAL SEARCH FORM TEMPLATE
 * =================================================================================================
 * AUTHOR              : r.s.
 * FILENAME            : advanced_chemical.cfm
 * DESCRIPTION         : Template used to display chemical search form content.
 *
 *                       References alfincludes button action and caller.buttonStruct.  Also sets
 *                       hidden holdstate fields onClick/onBlur of form elements needing to be saved.
 * HISTORY             : 12/22/2002 - created file (r.s.)
 *						 01/02/2003 - modified comment structure (r.s.)
 *						 10/02/2014 SPE - ticket 3399: added new chemical group checkboxes
 *
 * =================================================================================================
--->

<cfinclude template="queries/advanced_effects_query.cfm">
<cfset loopcount = 1>
<cfset groupFlag = "">
    
<cfset allChecked = 0>
<cfif not isdefined("form.measSelections")>
    <cfset form.measSelections = "">
</cfif>
<cfif form.measSelections eq "">
    <cfset allChecked = 1>
</cfif>

<cfoutput query="GetMeasurementList">

    <cfif groupFlag is not "#GetMeasurementList.effect#">
        <cfif loopcount gt 1>
                </ul>
                <hr>
            </fieldset>
        </cfif>
          
                <fieldset class="multi-select small" data-toggle="checkboxes" data-range="true">
                    <legend>#GetMeasurementList.effect_description# - #GetMeasurementList.effect#</legend>
                    <ul class="no-bullet col-medium-2">

        <cfset groupFlag = "#GetMeasurementList.effect#">
    </cfif>

    
    <cfset checkedStr = "">        
    <cfif allChecked eq 1>
        <cfset checkedStr = " checked">
    <cfelse>
        <cfset selectionListIdx = #ListFind(form.measSelections, GetMeasurementList.Code)#>       
               
        <cfif selectionListIdx gt 0>
            <cfset checkedStr = " checked">
        </cfif>
    </cfif>
                    <li>
                        <input id="itemInGroup-#GetMeasurementList.Code#-#GetMeasurementList.effect#" type="checkbox" value="#GetMeasurementList.Code#"#checkedStr#>
                        <label for="itemInGroup-#GetMeasurementList.Code#-#GetMeasurementList.effect#">#left(GetMeasurementList.Description,45)# - #Code#</label>
                    </li>

    <cfset loopcount = loopcount + 1>
</cfoutput>

