
<cfset GenFunc = CreateObject("component", "cfc.generic_functions")>

<cfoutput>
  <div class="card">
    <div class="card-header">
      <h4>#currentCardName#</h4>
    </div>
	<div class="card-content">

<cfif StructKeyExists(paramsToDisplay, "#currentCardName#")>
  <cfset currentCardGroups = paramsToDisplay["#currentCardName#"]>
  <cfif NOT StructIsEmpty(currentCardGroups)>

  <!--- DO ITEMS WITHOUT A GROUP FIRST, AND TEXT AREAS WITHIN THAT FIRST --->
  <cfif StructKeyExists(currentCardGroups, "NO-GROUP")>
  <cfset thisNoGroupParams = currentCardGroups["NO-GROUP"]>
  <cfif NOT StructIsEmpty(thisNoGroupParams)>
	<cfset thisGroupsTextAreas = ParamFunc.getCardTextAreas(currentCardName)>
	<cfif ArrayLen(thisGroupsTextAreas) gt 0>

	<cfloop from="1" to="#ArrayLen(thisGroupsTextAreas)#" index="i">
	  <cfset thisTextArea = thisGroupsTextAreas[i]>
	  <cfif StructKeyExists(thisNoGroupParams, "#thisTextArea#")>
		<cfset thisTextAreaVal = thisNoGroupParams["#thisTextArea#"]>
		<cfif thisTextAreaVal neq "">		
		  <cfset modval = REReplace(thisTextAreaVal,"#chr(13)#|#chr(9)#|\n|\r",";","ALL")>
		  <cfset splitValArray = ListToArray(modval,";",false,true)>
		  <h5>#thisTextArea#</h5>
		  <ul>
			<cfloop from="1" to="#ArrayLen(splitValArray)#" index="j">
				<li>
				  <span class="name">#splitValArray[j]#</span>
				</li>
			</cfloop>
		  </ul>
			<cfif currentCardName eq ParamFunc.cardnames["species"]>
			  <cfset thisTextAreaVal = thisNoGroupParams["Kingdom"]>
			  <cfif thisTextAreaVal neq "">
		  <h5>Kingdom: #thisTextAreaVal#</h5>
			  </cfif>
			  <cfset thisTextAreaVal = thisNoGroupParams["Name Search Type"]>
			  <cfif thisTextAreaVal neq "">
		  <h5>Name Search Type: #thisTextAreaVal#</h5>
			  </cfif>
			</cfif>
		</cfif>		
	  </cfif>
	</cfloop>
	</cfif>

	<cfloop item="paramname" collection="#thisNoGroupParams#">
            <cfif ( GenFunc.findInArray(thisGroupsTextAreas, paramname, false ) eq 0 )>

                <cfset thisval = thisNoGroupParams["#paramname#"]>
                <cfif currentCardName eq ParamFunc.cardnames["pubs"]>
  	    <h5>#paramname# <span class="year">#thisval#</span></h5>
                <cfelse>
  		  <cfif paramname neq "Kingdom" AND paramname neq "Name Search Type">
		    <cfif currentCardName eq ParamFunc.cardnames["effect"] AND FindNoCase("group", paramname) gt 0>
			  <h5>#paramname#</h5>
			<cfelse>
			  <p><em>#paramname#</em></p>
		    </cfif>
  		  </cfif>
                </cfif>
            </cfif>
	</cfloop>
  </cfif>
  </cfif>
  
  
  <cfset sortedCardGroups = "">  
  <cfloop item="currentGroupName" collection="#currentCardGroups#">
	<cfset sortedCardGroups = ListAppend(sortedCardGroups, currentGroupName)>
  </cfloop>  
  <cfset sortedCardGroups = ListSort(sortedCardGroups, "textnocase", "asc")>

  <cfloop index="currentGroupName" list="#sortedCardGroups#">
    <cfif currentGroupName neq "NO-GROUP">
        <h5>#currentGroupName#</h5>
        <ul class="accordion" data-accordion data-multi-expand="true" data-allow-all-closed="true">
          <cfset currentGroupParams = currentCardGroups["#currentGroupName#"]>
          <cfloop item="paramname" collection="#currentGroupParams#">
                  <cfset paramval = currentGroupParams["#paramname#"]>

                  <cfif StructIsEmpty("#currentModList#")>
                <li>#paramname#</li>
                  <cfelse>
                        <cfset modItemArray = currentModList["#paramname#"]>
                        <cfif ArrayLen(modItemArray) lt 1>

                <li>#paramname#</li>

                        <cfelse>

                <li data-accordion-item>
                  #paramname# <a href="##" title="Click to see selected items">(modified)</a>
                  <ul class="accordion-content" data-tab-content>
                        <cfloop from="1" to="#ArrayLen(modItemArray)#" index="k">
                          <cfset thisval = modItemArray[k]>
                        <li>#thisval#</li>
                        </cfloop>
                  </ul>
                </li>

                        </cfif>
                  </cfif>
          </cfloop>
        </ul>
    </cfif>
  </cfloop>
</cfif>
</cfif>
    </div>
  </div>
</cfoutput>
