
<cfset OutFunc = CreateObject("component", "cfc.output_functions")>  
    
<cfparam name="URL.mode" default="">
<cfparam name="URL.export" default="">
        
<!--- paging / sorting vars --->  
<cfparam name="URL.sortfield" default="">       <!--- UI will pass this or default to col 1 on DT.  Exports will use the default value here  --->
<cfparam name="URL.sortdir" default="">
<cfparam name="URL.length" default="10000">   <!--- default is application max.  UI will pass page size, exports will not and will be capped at 10000 rows --->
<cfparam name="URL.start" default="0">       <!--- offset position for query results.  UI will pass this, default to beginning.  Exports will have full range 0-10000 --->
    
<cfparam name="URL.searchstr" default="">
<cfparam name="URL.lookupField" default="">
    
<cfset SORTFIELD = OutFunc.generateOrderByClause( URL.sortfield, URL.sortdir )>
<cfset PAGESIZE = URL.length>
<cfset STARTPOS = URL.start>
<cfset STARTPOSPLUS1 = STARTPOS + 1>
<cfset ENDPOS = PAGESIZE + STARTPOS>
    
<!--- jquery datatable specific --->
<cfparam name ="URL.draw" default="">
<cfset RETURNDRAW = URL.draw>    
    

<cfswitch expression="#URL.mode#">
    <cfcase value="chemsearch">
        
        <cfset pageTitle = "Chemicals - Last Search Date">
            
        <cfinclude template="literature/queries/chem_searches_db.cfm">

        <cfif URL.export EQ "1">
            <cfset OUTPUTFORMAT = "CSV">                             <!--- might change later and there will be more formats --->
        <cfelse>
            <cfset OUTPUTFORMAT = "JSON">                    
        </cfif>

        <cfinclude template="literature/output_db_to_json.cfm">

    </cfcase>

    <cfcase value="matchsearch">

        <cfinclude template="literature/queries/matches_by_csid_db.cfm">

        <cfif URL.export EQ "1">
            <cfset OUTPUTFORMAT = "CSV">                             <!--- might change later and there will be more formats --->
        <cfelse>
            <cfset OUTPUTFORMAT = "JSON">                    
        </cfif>

        <cfinclude template="literature/output_matches_to_json.cfm">

    </cfcase>

    <cfcase value="casexport">

        <cfinclude template="literature/queries/chem_export.cfm">

        <cfif URL.export EQ "1">
            <cfset OUTPUTFORMAT = "CSV">                             <!--- might change later and there will be more formats --->
            <cfinclude template="literature/output_cas_export_to_csv.cfm">
        <cfelse>
            <cfset OUTPUTFORMAT = "JSON">                    
        </cfif>

    </cfcase>

    <cfcase value="termsexport">

        <cfinclude template="literature/queries/terms_export.cfm">

        <cfif URL.export EQ "1">
            <cfset OUTPUTFORMAT = "CSV">                             <!--- might change later and there will be more formats --->
            <cfinclude template="literature/output_terms_export_to_csv.cfm">
        <cfelse>
            <cfset OUTPUTFORMAT = "JSON">                    
        </cfif>

    </cfcase>

    <cfcase value="lookup">

        <cfif URL.lookupField EQ "cas">
            <cfset OUTPUTFORMAT = "JSON">                             <!--- might change later and there will be more formats --->
            <cfinclude template="literature/queries/cas_by_search_id.cfm">
        <cfelseif URL.lookupField EQ "terms">
            <cfset OUTPUTFORMAT = "JSON">
            <cfinclude template="literature/queries/terms_by_search_id.cfm">
        <cfelse>
            <!--- error handling??? --->
        </cfif>

        <cfinclude template="literature/lookup_to_list.cfm">

    </cfcase>
    
    <cfdefaultcase>

        <!--- SET CONDITIONS OF ERROR HERE FOR RETURN MESSAGING --->

        <!---   TODO
        <cfinclude template="browse/error_browse_response.cfm">
        --->

    </cfdefaultcase>
</cfswitch>
    
    


