<!---    

    EXPECTED VARIABLES FROM DB/DATA TEMPLATE:

        ChemicalSearchesQuery - a coldfusion query object with this name.

    EXPECTED VARIABLES FROM HANDLER:

        OUTPUTFORMAT - JSON for web, CSV, EXCEL (possibly others in future) for exports

--->

<cfset rowCount = #ChemicalSearchesQuery.TotalRows#>
    
<cfif rowCount eq "">
    <cfset rowCount = 0>
</cfif>


<cfset resultsArray = arrayNew(2)>
<cfloop query="ChemicalSearchesQuery">
    <cfset rowData = arrayNew(1)>    

    <!--- PROJECT --->
    <cfif ChemicalSearchesQuery.use_chem_group EQ 1>
        <cfset col1Str = "<a href='explore.cfm?cgid=#ChemicalSearchesQuery.chemical_group_id#' class='title-bold' target='_blank'>#ChemicalSearchesQuery.project_name#</a>">
        <cfset col2Str = "<a href='##' class='exportLink' title='Click to export to CSV'>#ChemicalSearchesQuery.num_in_chem_group#</a>">
    <cfelseif ChemicalSearchesQuery.num_cas_numbers GT 0>
        <cfset col1Str = "<a href='explore.cfm?chemSearchId=#ChemicalSearchesQuery.chem_search_id#' class='title-bold' target='_blank'>#ChemicalSearchesQuery.project_name#</a>">
        <cfset col2Str = "<a href='##' class='exportLink' title='Click to export to CSV'>#ChemicalSearchesQuery.num_cas_numbers#</a>">
    <cfelse>
        <cfset col1Str = "<span class='title-bold'>#ChemicalSearchesQuery.project_name#</span>">
        <cfset col2Str = "">
    </cfif>

    <cfif searchClauseValue NEQ "">
        <cfset searchFilterStr = "<hr/><a href='##' class='expandRow'>[ Show Matches ]</a>">
    <cfelse>
        <cfset searchFilterStr = "">
    </cfif>

    <cfset col1Str = col1Str & searchFilterStr>

    <cfset col1Str = OutFunc.cleanStringForDataTable(col1Str, OUTPUTFORMAT)>
    <cfset ArrayAppend(rowData, col1Str)>

    <!--- CAS ##s --->
    <cfif ChemicalSearchesQuery.ask_for_cas EQ 1>
        <cfset col2Str = "<a href='contact.cfm' target='_blank'>Contact Us</a>">
    </cfif>

    <cfset col2Str = OutFunc.cleanStringForDataTable(col2Str, OUTPUTFORMAT)>
    <cfset ArrayAppend(rowData, col2Str)>

    <!--- TERMS --->
    <cfif ChemicalSearchesQuery.ask_for_terms EQ 1>
        <cfset col3Str = "<a href='contact.cfm' target='_blank'>Contact Us</a>">
    <cfelseif ChemicalSearchesQuery.num_search_terms GT 0>
        <cfset col3Str = "<a href='##' class='exportLink' title='Click to export to CSV'>#ChemicalSearchesQuery.num_search_terms#</a>">
    <cfelse>
        <cfset col3Str = "">
    </cfif>
    
    <cfset col3Str = OutFunc.cleanStringForDataTable(col3Str, OUTPUTFORMAT)>
    <cfset ArrayAppend(rowData, col3Str)>

    <!--- SEARCH DATE --->
    <cfset col4Str = ChemicalSearchesQuery.search_date_str>
    <cfset theDate = CreateDate(Left(col4Str, 4), Mid(col4Str, 5, 2), Right(col4Str, 2))>
    <cfset formattedDate = DateFormat(theDate, 'mmmm yyyy')>

    <cfset col4Str = OutFunc.cleanStringForDataTable(formattedDate, OUTPUTFORMAT)> 
    <cfset ArrayAppend(rowData, col4Str)>

    <!--- NOTES --->
    <cfif LEN(ChemicalSearchesQuery.notes) gt 25>
        <cfset abbrevNotes = LEFT(ChemicalSearchesQuery.notes, 22) & "...">
    <cfelse>
        <cfset abbrevNotes = ChemicalSearchesQuery.notes>
    </cfif>

    <cfset col5Str = "<abbr title='" & EncodeForHTML(ChemicalSearchesQuery.notes) & "'>" & EncodeForHTML(abbrevNotes) & "</abbr>">
    <cfset col5Str = OutFunc.cleanStringForDataTable(col5Str, OUTPUTFORMAT)> 
    <cfset ArrayAppend(rowData, col5Str)>

    <!--- CHEM_SEARCH_ID --->
    <cfset col6Str = ChemicalSearchesQuery.chem_search_id>
    <cfset col6Str = OutFunc.cleanStringForDataTable(col6Str, OUTPUTFORMAT)> 
    <cfset ArrayAppend(rowData, col6Str)>
           
    <cfset ArrayAppend(resultsArray, rowData)>
</cfloop>
    

<cfset error = "0">
<cfset errorHtml = "">
<cfset messageClass = ''>
<cfset messageTitle = ''>
<cfset messageText = ''>    

<cfif rowCount eq 0>

    <cfset rowCount = 0>
    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "There were no results found for this selection. Please refine your search.">
    
</cfif>
        
<!---construct json output --->

<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>
    
<cfset dataString = "">
<cfloop array="#resultsArray#" index="thisRow">
    <cfset row = "">
    <cfloop array="#thisRow#" index="thisValue">
        <cfset row = listAppend(row, "#thisValue#")>    
    </cfloop>
        
    <cfset row = "[" & row & "]">    
    <cfset dataString = listAppend(dataString, row)>
</cfloop>
    
<cfset jsonString = '{"queryError":"#error#","errorHtml":"#errorHtml#","draw":"#RETURNDRAW#","recordsTotal":"#rowCount#","recordsFiltered":"#rowCount#","records":[' & dataString & ']}'>

<cfprocessingdirective suppressWhiteSpace = "Yes">
<cfoutput>
    #jsonString#
</cfoutput>
</cfprocessingdirective>



