 <!---construct csv output --->

<cfif URL.export EQ "1">
    <cfset rowCount = "">
<cfelse>
    <cfset rowCount = ChemSearchTermsExportQuery.TotalRows>
</cfif>
    
<cfif rowCount eq "">
    <cfset rowCount = 0>
</cfif>

<cfset columnDefs = arrayNew(2)>
    
<cfset col1Array = arrayNew(1)>
<cfset ArrayAppend(col1Array, "SEARCH TERM")>
<cfset ArrayAppend(col1Array, "search_term")>
<cfset ArrayAppend(columnDefs, col1Array)>
       
    
<cfset resultsArray = arrayNew(2)>
<cfloop query="ChemSearchTermsExportQuery">
    <cfset rowData = arrayNew(1)>

    <cfset project = ChemSearchTermsExportQuery.project_name>
    <cfset search_date = ChemSearchTermsExportQuery.search_date_str>
    
    <cfset col1Str = ChemSearchTermsExportQuery.search_term>
    <cfset col1Str = OutFunc.cleanStringForDataTable(col1Str, OUTPUTFORMAT)>
    <cfset ArrayAppend(rowData, col1Str)>
           
    <cfset ArrayAppend(resultsArray, rowData)>
</cfloop>


<cfset fileName = "ECOTOX-Chem-Search-Terms-#project#-#search_date#">
    
<CFHEADER NAME="Content-Disposition" VALUE="attachment; filename=#fileName#.csv">
<CFCONTENT TYPE="text/plain">
  
<cfprocessingdirective suppressWhiteSpace = "Yes">

<cfset columnNameList = "">
<cfloop array="#columnDefs#" index="thisDef">
    <cfset thisColName = OutFunc.cleanStringForDataTable(thisDef[1], OUTPUTFORMAT)>
    <cfset columnNameList = listAppend(columnNameList, '#thisColName#')>
</cfloop>

<cfoutput>#columnNameList##chr(13)##chr(10)#</cfoutput>
    
<cfset dataList = "">
<cfloop array="#resultsArray#" index="thisRow">
    <cfset row = "">
    <cfloop array="#thisRow#" index="thisValue">
        <cfset thisCsvValue = thisValue>
        <cfset row = listAppend(row, '#thisCsvValue#')>    
    </cfloop>
        
    <cfoutput>#row##chr(13)##chr(10)#</cfoutput>
</cfloop>
    
</cfprocessingdirective>
    
    