
<cfset defaultSortOrder = "cas_number, epa_chem_substance_name">

<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="ChemSearchCasExportQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="ChemSearchCasExportQueryVars">

        SELECT chem_search_id, project_name, search_date_str, cas_number, epa_chem_substance_name, chem_primary_name

            <!--- NOTE: 'ON OVERFLOW TRUNCATE' is only available in > Oracle 12.2.  staging/prod db is 12.1.0.2.0
            , LISTAGG(chem_syn, ' | ' ON OVERFLOW TRUNCATE '...') WITHIN GROUP (ORDER BY chem_syn) as synonyms--->

            , LISTAGG(chem_syn, ' | ') WITHIN GROUP (ORDER BY chem_syn) as synonyms
        FROM (            
            SELECT
                cs.id as chem_search_id, cs.project_name, TO_CHAR(cs.search_date, 'YYYYMMDD') as search_date_str
                , cs.use_chem_group, cs.chemical_group_id
                , csc.cas_number as cas_number
                , c.epa_chem_substance_name as epa_chem_substance_name
                , c.chem_primary_name as chem_primary_name
                , csy.chem_synonym_name as chem_syn
            from
                chemical_searches cs
                inner join chemical_searches_cas csc on cs.id = csc.chem_search_id_fk
                left join chemicals c on csc.cas_number = c.cas_number
                left join chemical_synonyms csy on c.cas_number = csy.cas_number
            where
                cs.display = 1
                AND cs.id = <CFQUERYPARAM VALUE="#URL.csid#" CFSQLTYPE="CF_SQL_INTEGER">
            UNION
            SELECT
                cs2.id as chem_search_id, cs2.project_name, TO_CHAR(cs2.search_date, 'YYYYMMDD') as search_date_str
                , cs2.use_chem_group, cs2.chemical_group_id
                , cx.cas_number as cas_number
                , c2.epa_chem_substance_name as epa_chem_substance_name
                , c2.chem_primary_name as chem_primary_name
                , csy2.chem_synonym_name as chem_syn
            from
                chemical_searches cs2
                inner join chemical_list_xref cx on cs2.use_chem_group = 1 and cs2.chemical_group_id = cx.chemical_listid
                left join chemicals c2 on cx.cas_number = c2.cas_number
                left join chemical_synonyms csy2 on c2.cas_number = csy2.cas_number
            where
                cs2.display = 1
                AND cs2.id = <CFQUERYPARAM VALUE="#URL.csid#" CFSQLTYPE="CF_SQL_INTEGER">
        ) oq
        group by chem_search_id, project_name, search_date_str, cas_number, epa_chem_substance_name, chem_primary_name
        order by #defaultSortOrder#

    </cfquery>
    
    <!---<cflog text ="#ChemSearchCasExportQueryVars.sql#">--->
    <!---<cflog text ="#ArrayToList(ChemSearchCasExportQueryVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>

